/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.es.pojo;

import com.chinamcloud.bigdata.haiheservice.es.EsFeedbackQuery;
import com.chinamcloud.bigdata.haiheservice.es.pojo.IEsBuildAgg;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.search.aggregations.bucket.histogram.ExtendedBounds;

public class EsBuildDateHistogramAgg
implements IEsBuildAgg {
    @Override
    public AggregationBuilder buildAgg(EsFeedbackQuery query) {
        String pubTimeBegin = query.getPubTimeBegin();
        String pubTimeEnd = query.getPubTimeEnd();
        DateHistogramInterval dateHistogramInterval = query.getFacetDateHistogramInterval();
        String facetField = query.getFacetField();
        DateHistogramAggregationBuilder agg = ((DateHistogramAggregationBuilder)((DateHistogramAggregationBuilder)AggregationBuilders.dateHistogram((String)"agg").field("pubTimeStr")).dateHistogramInterval(dateHistogramInterval).format("yyyy-MM-dd HH:mm:ss")).minDocCount(0L);
        if (!StringUtils.isEmpty((CharSequence)pubTimeBegin) && !StringUtils.isEmpty((CharSequence)pubTimeEnd)) {
            agg.extendedBounds(new ExtendedBounds(pubTimeBegin, pubTimeEnd));
        }
        agg.subAggregation((AggregationBuilder)AggregationBuilders.sum((String)"revenue").field("emotionScore"));
        return agg;
    }
}

