/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.es.result;

import com.chinamcloud.bigdata.haiheservice.es.EsFeedbackQuery;
import com.chinamcloud.bigdata.haiheservice.es.bean.EsApsSearchField;
import com.chinamcloud.bigdata.haiheservice.es.result.EsPagedResult;
import com.chinamcloud.bigdata.haiheservice.es.result.EsSearchResult;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.metrics.avg.Avg;
import org.elasticsearch.search.aggregations.metrics.tophits.TopHits;
import org.springframework.util.ObjectUtils;

public class EsNewsProcessor {
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public EsPagedResult<EsSearchResult> processReuslt(EsFeedbackQuery query, SearchResponse response, String event) {
        Integer pageIndex = query.getPageIndex();
        Integer pageSize = query.getPageSize();
        Terms agg = (Terms)response.getAggregations().get("agg");
        Integer totalCount = agg.getBuckets().size();
        EsSearchResult searchResult = new EsSearchResult();
        ArrayList<EsApsSearchField> records = new ArrayList<EsApsSearchField>();
        EsPagedResult<EsSearchResult> pageResult = new EsPagedResult<EsSearchResult>();
        pageResult.setTotalCount(totalCount);
        pageResult.setToPage(pageIndex);
        pageResult.setPageSize(pageSize);
        pageResult.setTotalPages(pageResult.getTotalPages());
        for (Terms.Bucket entry : agg.getBuckets()) {
            Object key = entry.getKey();
            long docCount = entry.getDocCount();
            if (ObjectUtils.isEmpty((Object)key) || docCount == 0L) continue;
            TopHits topHits = (TopHits)entry.getAggregations().get("top");
            SearchHit[] searchHits = topHits.getHits().getHits();
            Avg avg = (Avg)entry.getAggregations().get("avg_emotionScore");
            double value = avg.getValue();
            Integer emotionScore = Integer.parseInt(new DecimalFormat("0").format(value));
            Long pointsCount = docCount;
            for (SearchHit searchHit : searchHits) {
                Map source = searchHit.getSource();
                EsApsSearchField record = this.processBase(source);
                if (emotionScore != null) {
                    record.setEmotionScore(emotionScore);
                }
                if (pointsCount != null) {
                    record.setPointsCount(pointsCount);
                }
                records.add(record);
            }
        }
        searchResult.setRecords(records);
        pageResult.setResult(searchResult);
        return pageResult;
    }

    public EsApsSearchField processReuslt(GetResponse response) {
        Map sourceAsMap = response.getSourceAsMap();
        EsApsSearchField result = this.processBase(sourceAsMap);
        return result;
    }

    public EsPagedResult<EsSearchResult> processReuslt(EsFeedbackQuery query, SearchResponse response) {
        SearchHit[] searchHits;
        EsSearchResult searchResult = new EsSearchResult();
        ArrayList<EsApsSearchField> records = new ArrayList<EsApsSearchField>();
        EsPagedResult<EsSearchResult> pageResult = new EsPagedResult<EsSearchResult>();
        pageResult.setTotalCount((int)response.getHits().getTotalHits());
        pageResult.setToPage(query.getPageIndex());
        pageResult.setPageSize(query.getPageSize());
        pageResult.setTotalPages(pageResult.getTotalPages());
        pageResult.setResult(searchResult);
        for (SearchHit searchHit : searchHits = response.getHits().getHits()) {
            Map source = searchHit.getSource();
            records.add(this.processBase(source));
        }
        searchResult.setRecords(records);
        return pageResult;
    }

    private String setString(Object obj) {
        if (obj == null) {
            return null;
        }
        return String.valueOf(obj);
    }

    private Long setLong(Object obj) {
        if (obj == null) {
            return null;
        }
        return Long.valueOf(obj.toString());
    }

    private Integer setInteger(Object obj) {
        if (obj == null) {
            return null;
        }
        return Integer.valueOf(obj.toString());
    }

    private Boolean setBoolean(Object obj) {
        if (obj == null) {
            return null;
        }
        return Boolean.valueOf(obj.toString());
    }

    private List<String> setList(Object obj) {
        if (obj instanceof ArrayList) {
            return (List)obj;
        }
        return null;
    }

    private Map<String, String> setMap(Object obj) {
        if (obj instanceof Map) {
            return (Map)obj;
        }
        return null;
    }

    private EsApsSearchField processBase(Map<String, Object> source) {
        EsApsSearchField apsFeedback = new EsApsSearchField();
        apsFeedback.setCity(this.setString(source.get("city")));
        apsFeedback.setCluster(this.setString(source.get("cluster")));
        apsFeedback.setClusterId(this.setLong(source.get("clusterId")));
        apsFeedback.setCountry(this.setString(source.get("country")));
        apsFeedback.setCrawlerKeywords(this.setString(source.get("crawlerKeywords")));
        apsFeedback.setCreatedAt(this.setLong(source.get("createdAt")));
        apsFeedback.setDescription(this.setString(source.get("description")));
        apsFeedback.setEmotionScore(this.setInteger(source.get("emotionScore")));
        apsFeedback.setEmotionTendency(this.setInteger(source.get("emotionTendency")));
        apsFeedback.setId(this.setString(source.get("id")));
        apsFeedback.setKeywords(this.setString(source.get("keywords")));
        apsFeedback.setLangType(this.setString(source.get("langType")));
        apsFeedback.setMonitorTopicId(this.setInteger(source.get("monitorTopicId")));
        apsFeedback.setNewestFeedbackId(this.setLong(source.get("newestFeedbackId")));
        apsFeedback.setNewestFeedbackSubject(this.setString(source.get("newestFeedbackSubject")));
        apsFeedback.setNewestTime(this.setLong(source.get("newestTime")));
        apsFeedback.setParentSource(this.setString(source.get("parentSource")));
        apsFeedback.setPics(this.setList(source.get("pics")));
        apsFeedback.setProductId(this.setInteger(source.get("productId")));
        apsFeedback.setPubTime(this.setLong(source.get("pubTime")));
        apsFeedback.setRefererUrl(this.setString(source.get("refererUrl")));
        apsFeedback.setSource(this.setString(source.get("source")));
        apsFeedback.setSourceId(this.setInteger(source.get("sourceId")));
        apsFeedback.setSpiderTopicId(this.setInteger(source.get("spiderTopicId")));
        apsFeedback.setSubject(this.setString(source.get("subject")));
        apsFeedback.setSummaryKeywordList(this.setList(source.get("summaryKeywordList")));
        apsFeedback.setTbNickname(this.setString(source.get("tbNickname")));
        apsFeedback.setTranslateSubject(this.setString(source.get("translateSubject")));
        apsFeedback.setUrlMD5(this.setString(source.get("urlMD5")));
        apsFeedback.setCover(this.setString(source.get("cover")));
        apsFeedback.setDigest(this.setString(source.get("digest")));
        return apsFeedback;
    }
}

