/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.interceptor;

import com.alibaba.fastjson.JSON;
import com.chinamcloud.bigdata.haiheservice.CodeResult;
import com.chinamcloud.bigdata.haiheservice.UserManager;
import com.chinamcloud.bigdata.haiheservice.bean.User;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class LoginInterceptor
implements HandlerInterceptor {
    private static Logger logger = LogManager.getLogger(LoginInterceptor.class);
    @Autowired
    private UserManager userManager;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String token = request.getParameter("access_token");
        logger.info("token=" + token);
        if (StringUtils.isEmpty((CharSequence)token)) {
            String contentType = request.getContentType();
            if (StringUtils.isEmpty((CharSequence)contentType) || contentType.indexOf("application/json") < 0) {
                response.getWriter().write("params_error");
            } else {
                response.setContentType("application/json");
                response.getWriter().write(JSON.toJSONString((Object)CodeResult.failedResultByMsgSource("token_error")));
            }
            return false;
        }
        User user = this.userManager.gerUserInfo(token);
        if (user == null) {
            response.setContentType("application/json");
            response.getWriter().write(JSON.toJSONString((Object)CodeResult.failedResultByMsgSource("token_error")));
            return false;
        }
        request.setAttribute("user", (Object)user);
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
    }
}

