/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.service;

import com.chinamcloud.bigdata.haiheservice.bean.AnalysisRecord;
import com.chinamcloud.bigdata.haiheservice.bean.AnalysisReq;
import com.chinamcloud.bigdata.haiheservice.bean.AnalysisResult;
import com.chinamcloud.bigdata.haiheservice.bean.AnalysisTask;
import com.chinamcloud.bigdata.haiheservice.dao.AnalysisDao;
import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AnalysisService {
    private static Logger logger = LogManager.getLogger(AnalysisService.class);
    @Autowired
    private AnalysisDao dao;

    public boolean isAnalysisReqExisted(String url, long ownerId) {
        return this.dao.selectAnalysisReqExisted(url, ownerId);
    }

    public long addAnalysisReq(String url, long ownerId, AnalysisTask.Type type) {
        return this.dao.addAnalysisReq(url, ownerId, type);
    }

    public void updateReqPre(long ownerId, String url, long recordId, AnalysisTask.Type type) {
        this.dao.updateReqPre(ownerId, url, recordId, type);
    }

    public void updateReqPost(long ownerId, String url, long recordId, AnalysisTask.Type type, AnalysisReq.Status status) {
        logger.info("recordId=" + recordId + " ownerId" + ownerId + " url=" + url + " type=" + type.getIntValue() + " status=" + status.getIntValue());
        if (AnalysisTask.Type.YUAN_CHUANG == type) {
            this.dao.updateReqPostYC(ownerId, url, status);
        } else if (AnalysisTask.Type.WEI_BO == type) {
            this.dao.updateReqPost(ownerId, url, recordId, status);
        }
    }

    public List<AnalysisReq> selectReqStatus(int id, long ownerId) {
        return this.dao.selectReqStatus(id, ownerId);
    }

    public List<AnalysisReq> selectAnalysisReq(List<String> ids, long ownerId) {
        return this.dao.selectAnalysisReq(ids, ownerId);
    }

    public List<AnalysisReq> selectAnalysisReqList(long ownerId, int type) {
        return this.dao.selectAnalysisReqList(ownerId, type);
    }

    public void deleteAnalysisReq(long id) {
        this.dao.deleteAnalysisReq(id);
    }

    public List<AnalysisReq> selectAnalysisReqHistoryList(long ownerId, String url, int type) {
        return this.dao.selectAnalysisReqHistoryList(ownerId, url, type);
    }

    public void updateReqRecordId(long ownerId, String url, long recordId) {
        this.dao.updateReqRecordId(ownerId, url, recordId);
    }

    public List<AnalysisTask> getAnalysisTask() {
        return this.dao.getAnalysisTask();
    }

    public boolean isAnalysisExisted(String url, long ownerId) {
        return this.dao.isAnalysisExisted(url, ownerId);
    }

    public void addAnalysisTask(AnalysisTask task) {
        this.dao.addAnalysisTask(task);
    }

    public void updateTask(AnalysisTask task) {
        this.dao.updateTask(task);
    }

    public long saveAnalysisRecord(AnalysisRecord record) {
        return this.dao.saveAnalysisRecord(record);
    }

    public long saveAnalysisRecordYC(AnalysisRecord record) {
        return this.dao.saveAnalysisRecordYC(record);
    }

    public List<AnalysisRecord> selectAnalysisRecordList(long ownerId, int type) {
        return this.dao.selectAnalysisRecordList(ownerId, type);
    }

    public List<AnalysisRecord> selectAnalysisRecord(long ownerId, String url, int type, Date modifyTime) {
        return this.dao.selectAnalysisRecord(ownerId, url, type, modifyTime);
    }

    public AnalysisRecord selectRecord(long id, long ownerId) {
        return this.dao.selectRecord(id, ownerId);
    }

    public AnalysisRecord selectRecordByAnalysisId(long analisisId, long ownerId) {
        return this.dao.selectRecordByAnalysisId(analisisId, ownerId);
    }

    public void updateRecord(int analisisId, long resultId) {
        this.dao.updateRecord(analisisId, resultId);
    }

    public void updateRecordForwards(long id, int forwards) {
        this.dao.updateRecordForwards(id, forwards);
    }

    public long saveAnalysisResult(AnalysisResult result) {
        return this.dao.saveAnalysisResult(result);
    }

    public AnalysisResult selectAnalysisResultById(int id, long ownerId) {
        return this.dao.selectAnalysisResultById(id, ownerId);
    }

    public AnalysisResult selectAnalysisResultHistory(long ownerId, String url, int type, Date modifyTime) {
        return this.dao.selectAnalysisResultHistory(ownerId, url, type, modifyTime);
    }
}

