/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.xz;

import com.chinamcloud.bigdata.haiheservice.bean.BaseSearchFullResult;
import com.chinamcloud.bigdata.haiheservice.bean.Page;
import com.chinamcloud.bigdata.haiheservice.xz.IAliDataParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.taobao.kelude.aps.feedback.model.SearchResult;
import com.taobao.kelude.common.PagedResult;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;

public abstract class BaseSearchDataPageParser<T>
implements IAliDataParser<Page<T>> {
    @Override
    public Page<T> parserData(String data) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.setDateFormat((DateFormat)new SimpleDateFormat("MMM dd, yyyy hh:mm:ss aaa", Locale.ENGLISH));
        BaseSearchFullResult result = null;
        try {
            result = (BaseSearchFullResult)mapper.readValue(data, BaseSearchFullResult.class);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (result != null && result.isSuccess()) {
            PagedResult<SearchResult> pageResult = result.getData();
            List<T> t = this.parseRecords((SearchResult)pageResult.getResult());
            Page<T> page = new Page<T>(t);
            page.setPageSize(pageResult.getPageSize());
            page.setTotalCount(pageResult.getTotalCount());
            page.setTotalPages(pageResult.getTotalPages());
            return page;
        }
        return null;
    }

    protected abstract List<T> parseRecords(SearchResult var1);
}

