/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.controller;

import com.chinamcloud.bigdata.haiheservice.CodeResult;
import com.chinamcloud.bigdata.haiheservice.afterprocessor.EmotionTendencyAfterProcessor;
import com.chinamcloud.bigdata.haiheservice.afterprocessor.HotwordsAfterProcessor;
import com.chinamcloud.bigdata.haiheservice.bean.HotWords;
import com.chinamcloud.bigdata.haiheservice.bean.User;
import com.chinamcloud.bigdata.haiheservice.i18n.MessageSource;
import com.chinamcloud.bigdata.haiheservice.pojo.GlobalHotEventParams;
import com.chinamcloud.bigdata.haiheservice.pojo.HotNewsDetailParams;
import com.chinamcloud.bigdata.haiheservice.pojo.HotParams;
import com.chinamcloud.bigdata.haiheservice.pojo.RelatedNewsParams;
import com.chinamcloud.bigdata.haiheservice.service.HotWordsService;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RequestMapping(value={"/global"})
@RestController
public class GlobalHotController {
    private static Logger logger = LogManager.getLogger(GlobalHotController.class);
    private static final List<Integer> excludeSpiderTopicIds = new ArrayList<Integer>();
    private static final List<Integer> productIds;
    @Autowired
    private HotWordsService hotwordService;

    @RequestMapping(value={"/getHotTopic"}, method={RequestMethod.POST})
    public Object getHotTopic(@Valid @RequestBody GlobalHotEventParams params, BindingResult bindResult, HttpServletRequest request) {
        params.setHistogramInterval("year");
        params.setExcludeSpiderTopicIds(excludeSpiderTopicIds);
        params.setProduceIds(productIds);
        params.setParentSource(true);
        ModelAndView view = new ModelAndView("/es/basic/hotTopic.do");
        view.addObject("params", (Object)params);
        return view;
    }

    @RequestMapping(value={"/getHotTopicTrend"}, method={RequestMethod.POST})
    public Object getHotTopicTrend(@Valid @RequestBody GlobalHotEventParams params, BindingResult bindResult, HttpServletRequest request) {
        params.setExcludeSpiderTopicIds(excludeSpiderTopicIds);
        params.setHistogramInterval("hour");
        params.setProduceIds(productIds);
        params.setParentSource(true);
        ModelAndView view = new ModelAndView("/es/basic/topicTrend.do");
        view.addObject("params", (Object)params);
        return view;
    }

    @RequestMapping(value={"/news"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object gethotNews(@Valid @RequestBody GlobalHotEventParams params, BindingResult bindResult, HttpServletRequest request) {
        if (bindResult.getErrorCount() > 0) {
            return new CodeResult(CodeResult.Code.Failed, MessageSource.getMsg("params_error"));
        }
        params.setExcludeSpiderTopicIds(excludeSpiderTopicIds);
        params.setProduceIds(productIds);
        ModelAndView view = new ModelAndView("/es/basic/hotNews.do");
        view.addObject("params", (Object)params);
        return view;
    }

    @RequestMapping(value={"/newsDetail"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object getNewsDetail(@Valid @RequestBody HotNewsDetailParams params, BindingResult bindResult, HttpServletRequest request) {
        if (bindResult.hasErrors()) {
            return new CodeResult(CodeResult.Code.Failed, MessageSource.getMsg("params_error"));
        }
        User user = (User)request.getAttribute("user");
        HotParams hotParams = new HotParams();
        try {
            hotParams.setId(params.getDocId());
        }
        catch (NumberFormatException e) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        ModelAndView view = new ModelAndView("/es/basic/newsDetail.do");
        view.addObject("params", (Object)hotParams);
        view.addObject("user", (Object)user);
        return view;
    }

    @RequestMapping(value={"/relatedNews"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object relatedNew(@RequestBody @Validated RelatedNewsParams params, BindingResult result, HttpServletRequest request) {
        String clusterId;
        if (result.hasErrors()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        HotParams hotParams = new HotParams();
        String cluster = params.getCluster();
        if (StringUtils.isNotBlank((CharSequence)cluster)) {
            hotParams.setCluster(cluster);
        }
        if (StringUtils.isNotBlank((CharSequence)(clusterId = params.getClusterId()))) {
            hotParams.setClusterId(clusterId);
        }
        hotParams.setDay(params.getDay());
        hotParams.setPage(params.getPage());
        hotParams.setSize(params.getSize());
        hotParams.setSortFields(params.getSortFields());
        hotParams.setExcludeSpiderTopicIds(excludeSpiderTopicIds);
        hotParams.setProduceIds(productIds);
        hotParams.setParentSource(true);
        ModelAndView view = new ModelAndView("/es/basic/relatedNews.do");
        view.addObject("params", (Object)hotParams);
        return view;
    }

    @RequestMapping(value={"/getSenSourceFacet"}, method={RequestMethod.POST})
    public Object getSentimentSourceFacet(@Valid @RequestBody GlobalHotEventParams params, HttpServletRequest request) {
        params.setFacetField("tb_nickname");
        params.setExcludeSpiderTopicIds(excludeSpiderTopicIds);
        params.setProduceIds(productIds);
        params.setParentSource(true);
        ModelAndView view = new ModelAndView("/es/basic/facet.do");
        view.addObject("params", (Object)params);
        return view;
    }

    @RequestMapping(value={"/getTopicStatistics"}, method={RequestMethod.POST})
    public Object getEventStatistics(@Valid @RequestBody GlobalHotEventParams params, BindingResult bindResult, HttpServletRequest request) {
        params.setExcludeSpiderTopicIds(excludeSpiderTopicIds);
        params.setProduceIds(productIds);
        params.setParentSource(true);
        ModelAndView view = new ModelAndView("/es/basic/topicStatistics.do");
        view.addObject("params", (Object)params);
        return view;
    }

    @RequestMapping(value={"/getTopicTrend"}, method={RequestMethod.POST})
    public Object getEventTrend(@Valid @RequestBody GlobalHotEventParams params, BindingResult bindResult, HttpServletRequest request) {
        params.setExcludeSpiderTopicIds(excludeSpiderTopicIds);
        params.setHistogramInterval("hour");
        params.setProduceIds(productIds);
        params.setParentSource(true);
        ModelAndView view = new ModelAndView("/es/basic/topicTrend.do");
        view.addObject("params", (Object)params);
        return view;
    }

    @RequestMapping(value={"/getHotWords"}, method={RequestMethod.POST})
    public Object getHotWords() {
        HotParams params = new HotParams();
        params.setDay("1");
        params.setFacetField("summary_keywords");
        params.setExcludeSpiderTopicIds(excludeSpiderTopicIds);
        params.setProduceIds(productIds);
        params.setParentSource(true);
        List<HotWords> hotWords = this.hotwordService.getHotWords();
        HotwordsAfterProcessor afterProcessor = new HotwordsAfterProcessor(hotWords);
        params.setAfterProcessor(afterProcessor);
        ModelAndView modelAndView = new ModelAndView("/es/basic/facet.do");
        modelAndView.addObject("params", (Object)params);
        return modelAndView;
    }

    @RequestMapping(value={"/getEmotionTendency"}, method={RequestMethod.POST})
    public Object getEmotionTendency(HttpServletRequest request) {
        User user = (User)request.getAttribute("user");
        HotParams params = new HotParams();
        params.setFacetField("emotion_tendency");
        params.setExcludeSpiderTopicIds(excludeSpiderTopicIds);
        params.setProduceIds(productIds);
        params.setParentSource(true);
        EmotionTendencyAfterProcessor afterProcessor = new EmotionTendencyAfterProcessor();
        params.setAfterProcessor(afterProcessor);
        ModelAndView view = new ModelAndView("/es/basic/facet.do");
        view.addObject("params", (Object)params);
        return view;
    }

    @RequestMapping(value={"/export"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object export(@Valid @RequestBody GlobalHotEventParams params, BindingResult bindResult, HttpServletRequest request) {
        if (bindResult.getErrorCount() > 0) {
            return new CodeResult(CodeResult.Code.Failed, MessageSource.getMsg("params_error"));
        }
        params.setExcludeSpiderTopicIds(excludeSpiderTopicIds);
        params.setProduceIds(productIds);
        ModelAndView view = new ModelAndView("/es/basic/exportNews.do");
        view.addObject("params", (Object)params);
        return view;
    }

    @RequestMapping(value={"/statistic"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object statistic(@Valid @RequestBody GlobalHotEventParams params, BindingResult bindResult, HttpServletRequest request) {
        if (bindResult.getErrorCount() > 0) {
            return new CodeResult(CodeResult.Code.Failed, MessageSource.getMsg("params_error"));
        }
        params.setExcludeSpiderTopicIds(excludeSpiderTopicIds);
        params.setProduceIds(productIds);
        params.setSize(0);
        ModelAndView view = new ModelAndView("/es/basic/statisticNews.do");
        view.addObject("params", (Object)params);
        return view;
    }

    static {
        excludeSpiderTopicIds.add(28931);
        productIds = new ArrayList<Integer>();
        productIds.add(53691);
        productIds.add(51644);
    }
}

