/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.controller;

import com.chinamcloud.bigdata.haiheservice.CodeResult;
import com.chinamcloud.bigdata.haiheservice.afterprocessor.EmotionTendencyAfterProcessor;
import com.chinamcloud.bigdata.haiheservice.bean.HotTopic;
import com.chinamcloud.bigdata.haiheservice.bean.Page;
import com.chinamcloud.bigdata.haiheservice.pojo.HotNewsDetailParams;
import com.chinamcloud.bigdata.haiheservice.pojo.HotNewsParams;
import com.chinamcloud.bigdata.haiheservice.pojo.HotParams;
import com.chinamcloud.bigdata.haiheservice.pojo.PredictHotEventParams;
import com.chinamcloud.bigdata.haiheservice.pojo.RegionHotEventParams;
import com.chinamcloud.bigdata.haiheservice.pojo.RelatedNewsParams;
import com.chinamcloud.bigdata.haiheservice.service.PredictEventService;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/predict"})
public class PredictEventController {
    @Autowired
    private PredictEventService predictEventService;
    private static final int productId = 53691;

    @RequestMapping(value={"/getHotTopic"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object listHotEvent(@RequestBody @Validated PredictHotEventParams params) {
        int page = params.getPage();
        int size = params.getSize();
        List<HotTopic> hotEvent = this.predictEventService.selectPredictEvent();
        if (hotEvent != null && hotEvent.size() > 0) {
            List<HotTopic> subList = hotEvent.subList((page - 1) * size, Math.min(page * size, hotEvent.size()));
            int totalCount = hotEvent.size();
            int totalPages = totalCount / size + 1;
            Page<HotTopic> result = new Page<HotTopic>(subList);
            result.setTotalPages(totalPages);
            result.setTotalCount(totalCount);
            return new CodeResult(CodeResult.Code.Success, result);
        }
        return new CodeResult(CodeResult.Code.Success, Collections.EMPTY_LIST);
    }

    @RequestMapping(value={"/getHotTopicTrend"}, method={RequestMethod.POST})
    public Object getHotTopicTrend(@Valid @RequestBody RegionHotEventParams params, BindingResult bindResult) {
        if (bindResult.hasErrors()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        params.setProduceIds(Arrays.asList(53691));
        params.setHistogramInterval("hour");
        ModelAndView view = new ModelAndView("/es/basic/topicTrend.do");
        view.addObject("params", (Object)params);
        return view;
    }

    @RequestMapping(value={"/getHotTopicTrendByDay"}, method={RequestMethod.POST})
    public Object getDayFacetBySite(@RequestBody Map<String, String> params) {
        String clusterId = params.get("clusterId");
        if (StringUtils.isEmpty((CharSequence)clusterId)) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        HotParams hotParams = new HotParams();
        hotParams.setProduceIds(Arrays.asList(53691));
        hotParams.setDay("1");
        hotParams.setClusterId(clusterId);
        hotParams.setDateInterval("hour");
        hotParams.setFacetField("pubTimeStr");
        ModelAndView view = new ModelAndView("/es/basic/sentimentTrend.do");
        view.addObject("params", (Object)hotParams);
        return view;
    }

    @RequestMapping(value={"/news"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object hotNews(@RequestBody @Validated HotNewsParams params, BindingResult result) {
        if (result.hasErrors()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        params.setProduceIds(Arrays.asList(53691));
        ModelAndView modelAndView = new ModelAndView("/es/basic/hotNews.do");
        modelAndView.addObject("params", (Object)params);
        return modelAndView;
    }

    @RequestMapping(value={"/relatedNews"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object relatedNew(@RequestBody @Validated RelatedNewsParams params, BindingResult result) {
        if (result.hasErrors()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        HotParams hotParams = new HotParams();
        hotParams.setClusterId(params.getClusterId());
        hotParams.setProduceIds(Arrays.asList(53691));
        hotParams.setPage(params.getPage());
        hotParams.setSize(params.getSize());
        ModelAndView modelAndView = new ModelAndView("/es/basic/relatedNews.do");
        modelAndView.addObject("params", (Object)hotParams);
        return modelAndView;
    }

    @RequestMapping(value={"/newsDetail"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object newsDetail(@RequestBody @Validated HotNewsDetailParams params, BindingResult bindResult) {
        if (bindResult.hasErrors()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        HotParams hotParams = new HotParams();
        try {
            hotParams.setId(params.getDocId());
        }
        catch (NumberFormatException e) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        ModelAndView view = new ModelAndView("/es/basic/newsDetail.do");
        hotParams.setProduceIds(Arrays.asList(53691));
        view.addObject("params", (Object)hotParams);
        return view;
    }

    @RequestMapping(value={"/getEmotionTendency"}, method={RequestMethod.POST})
    public Object getEmotionTendency(@RequestBody Map<String, String> params, HttpServletRequest request) {
        String clusterId = params.get("clusterId");
        if (StringUtils.isEmpty((CharSequence)clusterId)) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        HotParams hotParams = new HotParams();
        hotParams.setProduceIds(Arrays.asList(53691));
        hotParams.setFacetField("emotion_tendency");
        hotParams.setClusterId(clusterId);
        EmotionTendencyAfterProcessor afterProcessor = new EmotionTendencyAfterProcessor();
        hotParams.setAfterProcessor(afterProcessor);
        ModelAndView view = new ModelAndView("/es/basic/facet.do");
        view.addObject("params", (Object)hotParams);
        return view;
    }
}

