/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.controller;

import com.chinamcloud.bigdata.haiheservice.CodeResult;
import com.chinamcloud.bigdata.haiheservice.bean.KeyWords;
import com.chinamcloud.bigdata.haiheservice.bean.MonitorTopic;
import com.chinamcloud.bigdata.haiheservice.bean.User;
import com.chinamcloud.bigdata.haiheservice.pojo.UserDefineTopic;
import com.chinamcloud.bigdata.haiheservice.service.MonitorTopicService;
import com.chinamcloud.bigdata.haiheservice.util.TopicKeywordUtils;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/topic"})
public class TopicController {
    @Autowired
    private MonitorTopicService monitorTopicService;

    @RequestMapping(value={"/addTopic"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object addTopic(@RequestBody @Validated(value={UserDefineTopic.AddTopic.class}) UserDefineTopic userDefineTopic, BindingResult result, HttpServletRequest request) {
        if (result.hasErrors()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        User user = (User)request.getAttribute("user");
        if (!this.monitorTopicService.checkQuoat(user, 1, TopicKeywordUtils.clcTopicKeyWords(userDefineTopic.getKeywords()))) {
            return CodeResult.failedResultByMsgSource("topic_quota_error");
        }
        List<KeyWords> list = TopicKeywordUtils.parseTopicKeyWords(userDefineTopic.getKeywords());
        if (list.size() == 0) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        MonitorTopic monitorTopic = new MonitorTopic();
        monitorTopic.setKeyWords(list);
        monitorTopic.setName(userDefineTopic.getName());
        monitorTopic.setType(MonitorTopic.Type.USER_DEFINE);
        monitorTopic.setProductId(53691);
        monitorTopic.setUid(user.getId());
        monitorTopic.setSubscribable(MonitorTopic.Subscribable.NO);
        monitorTopic.setRegisterTime(new Date());
        monitorTopic.setCreatedAtTime(new Date());
        monitorTopic.setIncludeSearch(userDefineTopic.getIncludeSearch());
        this.monitorTopicService.saveUserDefineTopic(monitorTopic);
        try {
            this.monitorTopicService.reportQuoat(user, 1, TopicKeywordUtils.clcTopicKeyWords(userDefineTopic.getKeywords()));
        }
        catch (Exception e) {
            return CodeResult.failedResult("cmc_frame_error");
        }
        return CodeResult.successResult();
    }

    @RequestMapping(value={"/delTopic"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object delTopic(@RequestBody Map<String, String> params, HttpServletRequest request) {
        Long topicId;
        try {
            topicId = Long.valueOf(params.get("topicId"));
        }
        catch (Exception e) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        User user = (User)request.getAttribute("user");
        MonitorTopic topic = this.monitorTopicService.selectUserSubDefineTopic(user.getId(), topicId);
        if (topic == null) {
            return CodeResult.failedResultByMsgSource("topic_not_exist");
        }
        List<KeyWords> keyWords = topic.getKeyWords();
        List<String> tmps = keyWords.stream().map(x -> x.getKeyWord()).collect(Collectors.toList());
        this.monitorTopicService.delUserDefineTopic(topicId, user.getId());
        try {
            this.monitorTopicService.reportQuoat(user, -1, -TopicKeywordUtils.clcTopicKeyWords(tmps));
        }
        catch (Exception e) {
            return CodeResult.failedResult("cmc_frame_error");
        }
        return CodeResult.successResult();
    }

    @RequestMapping(value={"/getDefineTopic"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object selectUserDefineTopic(HttpServletRequest request) {
        User user = (User)request.getAttribute("user");
        Long userId = user.getId();
        List<MonitorTopic> list = this.monitorTopicService.selectUserSubDefineTopics(userId);
        list.forEach(x -> {
            Long uid = x.getUid();
            x.setOwner(uid != null && userId.equals(uid) ? (byte)1 : (byte)0);
        });
        return CodeResult.successResult(null, list);
    }

    @RequestMapping(value={"/getDefineHotTopic"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object selectHotDefineTopic(@RequestBody Map<String, String> params, HttpServletRequest request) {
        String size = params.get("size");
        int intSize = 5;
        if (!StringUtils.isEmpty((CharSequence)size)) {
            try {
                intSize = Integer.valueOf(size);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (intSize > 50) {
            intSize = 50;
        }
        User user = (User)request.getAttribute("user");
        Long userId = user.getId();
        List<MonitorTopic> list = this.monitorTopicService.selectDefineHotTopics(userId, intSize);
        list.forEach(x -> {
            Long uid = x.getUid();
            x.setOwner(uid != null && userId.equals(uid) ? (byte)1 : (byte)0);
        });
        return CodeResult.successResult(null, list);
    }

    @RequestMapping(value={"/updateDefineTopic"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object updateDefineTopic(@RequestBody @Validated(value={UserDefineTopic.UpdateTopic.class}) UserDefineTopic topic, BindingResult result, HttpServletRequest request) {
        if (result.hasErrors()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        this.monitorTopicService.updateTopicIndexTime(topic.getTopicId());
        User user = (User)request.getAttribute("user");
        MonitorTopic dbTopic = this.monitorTopicService.selectDefineTopic(topic.getTopicId());
        if (dbTopic == null) {
            return CodeResult.failedResultByMsgSource("topic_not_exist");
        }
        Long uid = dbTopic.getUid();
        if (uid == null || !user.getId().equals(uid)) {
            return CodeResult.failedResultByMsgSource("topic_only_edit_by_owner");
        }
        if (dbTopic.getSubscribable() == MonitorTopic.Subscribable.YES) {
            return CodeResult.failedResultByMsgSource("topic_only_edit_by_noteffect");
        }
        int keywordCount = 0;
        List<String> dbKeywords = dbTopic.getKeyWords().stream().map(x -> x.getKeyWord()).collect(Collectors.toList());
        keywordCount = TopicKeywordUtils.clcTopicKeyWords(topic.getKeywords()) - TopicKeywordUtils.clcTopicKeyWords(dbKeywords);
        if (keywordCount > 0 && !this.monitorTopicService.checkQuoat(user, 0, keywordCount)) {
            return CodeResult.failedResultByMsgSource("topic_quota_error");
        }
        MonitorTopic updateTopic = new MonitorTopic();
        boolean edit = false;
        if (!StringUtils.isEmpty((CharSequence)topic.getSub())) {
            updateTopic.setSubscribable(MonitorTopic.Subscribable.valueOfInt(Integer.valueOf(topic.getSub())));
            edit = true;
        }
        if (topic.getKeywords() != null && topic.getKeywords().size() > 0) {
            updateTopic.setKeyWords(TopicKeywordUtils.parseTopicKeyWords(topic.getKeywords()));
            edit = true;
        }
        if (!StringUtils.isEmpty((CharSequence)topic.getName())) {
            updateTopic.setName(topic.getName());
            edit = true;
        }
        if (!edit) {
            return CodeResult.successResult();
        }
        updateTopic.setId(topic.getTopicId());
        Integer status = topic.getIncludeSearch();
        if (status == null) {
            status = dbTopic.getIncludeSearch();
        }
        updateTopic.setIncludeSearch(status);
        updateTopic.setRegisterTime(new Date());
        this.monitorTopicService.updateDefineTopic(updateTopic);
        if (keywordCount != 0) {
            try {
                this.monitorTopicService.reportQuoat(user, 0, keywordCount);
            }
            catch (Exception e) {
                return CodeResult.failedResult("cmc_frame_error");
            }
        }
        return CodeResult.successResult();
    }

    @RequestMapping(value={"/subDefineTopic"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object subDefineTopic(@RequestBody Map<String, String> params, HttpServletRequest request) {
        Long topicId = null;
        try {
            topicId = Long.valueOf(params.get("topicId"));
        }
        catch (Exception e) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        User user = (User)request.getAttribute("user");
        MonitorTopic topic = this.monitorTopicService.selectDefineTopic(topicId);
        List<String> keywords = topic.getKeyWords().stream().map(x -> x.getKeyWord()).collect(Collectors.toList());
        if (!this.monitorTopicService.checkQuoat(user, 1, TopicKeywordUtils.clcTopicKeyWords(keywords))) {
            return CodeResult.failedResultByMsgSource("topic_quota_error");
        }
        this.monitorTopicService.subDefineTopic(user.getId(), topicId);
        this.monitorTopicService.updateTopicIndexTime(topicId);
        this.monitorTopicService.reportQuoat(user, 1, TopicKeywordUtils.clcTopicKeyWords(keywords));
        return CodeResult.successResult();
    }

    @RequestMapping(value={"/getDefineTopicById"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object getDefineTopicById(@RequestBody Map<String, String> params, HttpServletRequest request) {
        Long topicId = null;
        try {
            topicId = Long.valueOf(params.get("topicId"));
        }
        catch (Exception e) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        User user = (User)request.getAttribute("user");
        MonitorTopic topic = this.monitorTopicService.selectDefineTopic(topicId);
        if (topic != null) {
            boolean isOwner;
            boolean bl = isOwner = topic.getUid() != null && user.getId().equals(topic.getUid());
            if (isOwner || topic.getSubscribable() == MonitorTopic.Subscribable.YES) {
                topic.setOwner(isOwner ? (byte)1 : 0);
                return CodeResult.successResult(null, topic);
            }
        }
        return CodeResult.failedResultByMsgSource("topic_not_exist");
    }
}

