/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.controller.dp;

import com.chinamcloud.bigdata.haiheservice.afterprocessor.HotwordsAfterProcessor;
import com.chinamcloud.bigdata.haiheservice.bean.HotWords;
import com.chinamcloud.bigdata.haiheservice.pojo.GlobalHotEventParams;
import com.chinamcloud.bigdata.haiheservice.pojo.HotParams;
import com.chinamcloud.bigdata.haiheservice.service.HotWordsService;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RequestMapping(value={"/dp/global"})
@RestController
public class DpGlobalHotController {
    private static final List<Integer> excludeSpiderTopicIds = new ArrayList<Integer>();
    private static final List<Integer> productIds;
    @Autowired
    private HotWordsService hotwordService;

    @RequestMapping(value={"/getHotTopic"}, method={RequestMethod.POST})
    public Object getHotTopic(@Valid @RequestBody GlobalHotEventParams params, BindingResult bindResult, HttpServletRequest request) {
        params.setHistogramInterval("year");
        params.setExcludeSpiderTopicIds(excludeSpiderTopicIds);
        params.setProduceIds(productIds);
        params.setParentSource(true);
        ModelAndView view = new ModelAndView("/es/basic/hotTopic.do");
        view.addObject("params", (Object)params);
        return view;
    }

    @RequestMapping(value={"/getHotWords"}, method={RequestMethod.POST})
    public Object getHotWords() {
        HotParams params = new HotParams();
        params.setDay("1");
        params.setFacetField("summary_keywords");
        params.setProduceIds(productIds);
        params.setExcludeSpiderTopicIds(excludeSpiderTopicIds);
        List<HotWords> hotWords = this.hotwordService.getHotWords();
        HotwordsAfterProcessor afterProcessor = new HotwordsAfterProcessor(hotWords);
        params.setAfterProcessor(afterProcessor);
        ModelAndView modelAndView = new ModelAndView("/es/basic/facet.do");
        modelAndView.addObject("params", (Object)params);
        return modelAndView;
    }

    static {
        excludeSpiderTopicIds.add(28931);
        productIds = new ArrayList<Integer>();
        productIds.add(53691);
        productIds.add(51644);
    }
}

