/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.controller.dp;

import com.chinamcloud.bigdata.haiheservice.CodeResult;
import com.chinamcloud.bigdata.haiheservice.RegionKeywordsConfigManager;
import com.chinamcloud.bigdata.haiheservice.afterprocessor.CitySentimentValueAfterProcessor;
import com.chinamcloud.bigdata.haiheservice.afterprocessor.CountySentimentValueAfterProcessor;
import com.chinamcloud.bigdata.haiheservice.afterprocessor.EmotionTendencyAfterProcessor;
import com.chinamcloud.bigdata.haiheservice.afterprocessor.EventStatisticAfterProcessor;
import com.chinamcloud.bigdata.haiheservice.afterprocessor.TopicStatisticAfterProcessor;
import com.chinamcloud.bigdata.haiheservice.es.pojo.TermAggBucket;
import com.chinamcloud.bigdata.haiheservice.pojo.HotParams;
import com.chinamcloud.bigdata.haiheservice.pojo.RegionHotEventParams;
import com.chinamcloud.bigdata.haiheservice.service.ConfigService;
import com.chinamcloud.bigdata.haiheservice.util.TopicKeywordUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/dp/region"})
public class DpRegionHotController {
    @Resource
    private RegionKeywordsConfigManager manager;
    @Resource
    private ConfigService service;

    @RequestMapping(value={"/getEventStatistics"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object getEventStatistics(@Valid @RequestBody RegionHotEventParams params, BindingResult bindResult) {
        String province = params.getTopicId();
        String city = params.getCityId();
        String county = params.getCountyId();
        Collection<String> keywords = null;
        keywords = StringUtils.isNotBlank((CharSequence)province) && StringUtils.isNotBlank((CharSequence)city) && StringUtils.isNotBlank((CharSequence)county) ? Arrays.asList(county) : (StringUtils.isNotBlank((CharSequence)province) && StringUtils.isNotBlank((CharSequence)city) ? this.service.getAreaNames(province, city) : (StringUtils.isNotBlank((CharSequence)province) && StringUtils.isBlank((CharSequence)city) ? this.manager.getRegionKeyWordsList(province) : null));
        if (keywords == null || keywords.isEmpty()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        params.setAfterProcessor(new EventStatisticAfterProcessor());
        params.setDescription(TopicKeywordUtils.buildQueryByStr(new ArrayList<String>(keywords)));
        ModelAndView view = new ModelAndView("/es/basic/eventStatistics.do");
        view.addObject("params", (Object)params);
        return view;
    }

    @RequestMapping(value={"/getEventTrend"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object getEventTrend(@Valid @RequestBody RegionHotEventParams params, BindingResult bindResult) {
        if (bindResult.hasErrors()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        String province = params.getTopicId();
        String city = params.getCityId();
        String county = params.getCountyId();
        Collection<String> keywords = null;
        keywords = StringUtils.isNotBlank((CharSequence)province) && StringUtils.isNotBlank((CharSequence)city) && StringUtils.isNotBlank((CharSequence)county) ? Arrays.asList(county) : (StringUtils.isNotBlank((CharSequence)province) && StringUtils.isNotBlank((CharSequence)city) ? this.service.getAreaNames(province, city) : (StringUtils.isNotBlank((CharSequence)province) && StringUtils.isBlank((CharSequence)city) ? this.manager.getRegionKeyWordsList(province) : null));
        if (keywords == null || keywords.isEmpty()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        params.setAfterProcessor(new EventStatisticAfterProcessor());
        params.setDescription(TopicKeywordUtils.buildQueryByStr(new ArrayList<String>(keywords)));
        ModelAndView view = new ModelAndView("/es/basic/eventTrend.do");
        view.addObject("params", (Object)params);
        return view;
    }

    @RequestMapping(value={"/getTopicStatistics"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object getTopicStatistics(@Valid @RequestBody RegionHotEventParams params, BindingResult bindResult) {
        if (bindResult.hasErrors()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        String province = params.getTopicId();
        String city = params.getCityId();
        String county = params.getCountyId();
        Collection<String> keywords = null;
        keywords = StringUtils.isNotBlank((CharSequence)province) && StringUtils.isNotBlank((CharSequence)city) && StringUtils.isNotBlank((CharSequence)county) ? Arrays.asList(county) : (StringUtils.isNotBlank((CharSequence)province) && StringUtils.isNotBlank((CharSequence)city) ? this.service.getAreaNames(province, city) : (StringUtils.isNotBlank((CharSequence)province) && StringUtils.isBlank((CharSequence)city) ? this.manager.getRegionKeyWordsList(province) : null));
        if (keywords == null || keywords.isEmpty()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        params.setAfterProcessor(new TopicStatisticAfterProcessor());
        params.setDescription(TopicKeywordUtils.buildQueryByStr(new ArrayList<String>(keywords)));
        params.setHistogramInterval("year");
        ModelAndView view = new ModelAndView("/es/basic/topicStatistics.do");
        view.addObject("params", (Object)params);
        return view;
    }

    @RequestMapping(value={"/news"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object hotNews(@RequestBody @Validated RegionHotEventParams params, BindingResult result) {
        if (result.hasErrors()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        String province = params.getTopicId();
        String city = params.getCityId();
        String county = params.getCountyId();
        Collection<String> keywords = null;
        keywords = StringUtils.isNotBlank((CharSequence)province) && StringUtils.isNotBlank((CharSequence)city) && StringUtils.isNotBlank((CharSequence)county) ? Arrays.asList(county) : (StringUtils.isNotBlank((CharSequence)province) && StringUtils.isNotBlank((CharSequence)city) ? this.service.getAreaNames(province, city) : (StringUtils.isNotBlank((CharSequence)province) && StringUtils.isBlank((CharSequence)city) ? this.manager.getRegionKeyWordsList(province) : null));
        if (keywords == null || keywords.isEmpty()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        params.setDescription(TopicKeywordUtils.buildQueryByStr(new ArrayList<String>(keywords)));
        ModelAndView view = new ModelAndView("/es/basic/hotNews.do");
        view.addObject("params", (Object)params);
        return view;
    }

    @RequestMapping(value={"/getHotWords"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object getHotWords(@Valid @RequestBody RegionHotEventParams params, BindingResult bindResult) {
        if (bindResult.hasErrors()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        String province = params.getTopicId();
        String city = params.getCityId();
        String county = params.getCountyId();
        Collection<String> keywords = null;
        keywords = StringUtils.isNotBlank((CharSequence)province) && StringUtils.isNotBlank((CharSequence)city) && StringUtils.isNotBlank((CharSequence)county) ? Arrays.asList(county) : (StringUtils.isNotBlank((CharSequence)province) && StringUtils.isNotBlank((CharSequence)city) ? this.service.getAreaNames(province, city) : (StringUtils.isNotBlank((CharSequence)province) && StringUtils.isBlank((CharSequence)city) ? this.manager.getRegionKeyWordsList(province) : null));
        if (keywords == null || keywords.isEmpty()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        params.setDescription(TopicKeywordUtils.buildQueryByStr(new ArrayList<String>(keywords)));
        params.setFacetField("summary_keywords");
        params.setFacetMincount(1);
        ModelAndView view = new ModelAndView("/es/basic/facet.do");
        view.addObject("params", (Object)params);
        return view;
    }

    @RequestMapping(value={"/getEmotionTendency"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object getEmotionTendency(@Valid @RequestBody RegionHotEventParams params, BindingResult bindResult) {
        if (bindResult.hasErrors()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        String province = params.getTopicId();
        String city = params.getCityId();
        String county = params.getCountyId();
        Collection<String> keywords = null;
        keywords = StringUtils.isNotBlank((CharSequence)province) && StringUtils.isNotBlank((CharSequence)city) && StringUtils.isNotBlank((CharSequence)county) ? Arrays.asList(county) : (StringUtils.isNotBlank((CharSequence)province) && StringUtils.isNotBlank((CharSequence)city) ? this.service.getAreaNames(province, city) : (StringUtils.isNotBlank((CharSequence)province) && StringUtils.isBlank((CharSequence)city) ? this.manager.getRegionKeyWordsList(province) : null));
        if (keywords == null || keywords.isEmpty()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        params.setAfterProcessor(new EmotionTendencyAfterProcessor());
        params.setDescription(TopicKeywordUtils.buildQueryByStr(new ArrayList<String>(keywords)));
        params.setFacetField("emotion_tendency");
        ModelAndView view = new ModelAndView("/es/basic/facet.do");
        view.addObject("params", (Object)params);
        return view;
    }

    @RequestMapping(value={"/getProvinceSentimentValue"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object getProvinceSentimentValue(@Valid @RequestBody Map<String, String> params) {
        String province = params.get("topicId");
        Map<String, Set<String>> keywords = null;
        if (StringUtils.isBlank((CharSequence)province)) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        keywords = this.manager.getCategoryMapping(province);
        if (keywords.size() == 0) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        HotParams hotParams = new HotParams();
        ModelAndView view = new ModelAndView("/es/basic/termBucketAgg.do");
        if (this.manager.checkISAll(province)) {
            LinkedList termAggBuckets = new LinkedList();
            keywords.forEach((x, y) -> termAggBuckets.add(new TermAggBucket((List<String>)new ArrayList<String>((Collection<String>)y), "description", (String)x)));
            view.addObject("termBucket", termAggBuckets);
        } else {
            LinkedList termAggBuckets = new LinkedList();
            keywords.values().iterator().next().stream().map(x -> new TermAggBucket(Arrays.asList(x), "description", (String)x)).collect(Collectors.toList());
            view.addObject("termBucket", termAggBuckets);
        }
        hotParams.setDescription(TopicKeywordUtils.buildQueryByStr(new ArrayList<String>(this.manager.getRegionKeyWordsList(province))));
        view.addObject("params", (Object)hotParams);
        return view;
    }

    @RequestMapping(value={"/getCitySentimentValue"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object getCitySentimentValue(@Valid @RequestBody Map<String, String> params) {
        String province = params.get("topicId");
        Map<String, Set<String>> keywords = null;
        if (StringUtils.isBlank((CharSequence)province)) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        keywords = this.manager.getCategoryMapping(province);
        if (keywords == null || keywords.size() == 0) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        HotParams hotParams = new HotParams();
        ModelAndView view = new ModelAndView("/es/basic/termBucketAgg.do");
        Set<String> value = keywords.values().iterator().next();
        value.stream().map(x -> new TermAggBucket(Arrays.asList(x), "description", (String)x)).collect(Collectors.toList());
        view.addObject("termBucket", value.stream().map(x -> new TermAggBucket(Arrays.asList(x), "description", (String)x)).collect(Collectors.toList()));
        hotParams.setDescription(TopicKeywordUtils.buildQueryByStr(new ArrayList<String>(this.manager.getRegionKeyWordsList(province))));
        CitySentimentValueAfterProcessor afterProcessor = new CitySentimentValueAfterProcessor(this.service.getAlias());
        hotParams.setAfterProcessor(afterProcessor);
        view.addObject("params", (Object)hotParams);
        return view;
    }

    @RequestMapping(value={"/getAreaSentimentValue"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object getAreaSentimentValue(@Valid @RequestBody Map<String, String> params) {
        String province = params.get("topicId");
        String city = params.get("cityId");
        List<String> keywords = null;
        keywords = StringUtils.isNotBlank((CharSequence)province) && StringUtils.isNotBlank((CharSequence)city) ? this.service.getAreaNames(province, city) : null;
        if (keywords == null || keywords.isEmpty()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        HotParams hotParams = new HotParams();
        ModelAndView view = new ModelAndView("/es/basic/termBucketAgg.do");
        List termAggBuckets = keywords.stream().map(x -> new TermAggBucket(Arrays.asList(x), "description", (String)x)).collect(Collectors.toList());
        hotParams.setDescription(TopicKeywordUtils.buildQueryByStr(new ArrayList<String>(keywords)));
        CountySentimentValueAfterProcessor afterProcessor = new CountySentimentValueAfterProcessor(this.service.getAlias());
        hotParams.setAfterProcessor(afterProcessor);
        view.addObject("params", (Object)hotParams);
        view.addObject("termBucket", termAggBuckets);
        return view;
    }

    @RequestMapping(value={"/getSenSourceFacet"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object getSentimentSourceFacet(@Valid @RequestBody RegionHotEventParams params, BindingResult bindResult) {
        if (bindResult.hasErrors()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        String province = params.getTopicId();
        String city = params.getCityId();
        String county = params.getCountyId();
        Collection<String> keywords = null;
        keywords = StringUtils.isNotBlank((CharSequence)province) && StringUtils.isNotBlank((CharSequence)city) && StringUtils.isNotBlank((CharSequence)county) ? Arrays.asList(county) : (StringUtils.isNotBlank((CharSequence)province) && StringUtils.isNotBlank((CharSequence)city) ? this.service.getAreaNames(province, city) : (StringUtils.isNotBlank((CharSequence)province) && StringUtils.isBlank((CharSequence)city) ? this.manager.getRegionKeyWordsList(province) : null));
        if (keywords == null || keywords.isEmpty()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        params.setDescription(TopicKeywordUtils.buildQueryByStr(new ArrayList<String>(keywords)));
        params.setFacetField("tb_nickname");
        params.setFacetLimit(500);
        ModelAndView view = new ModelAndView("/es/basic/facet.do");
        view.addObject("params", (Object)params);
        return view;
    }
}

