/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.dao;

import com.chinamcloud.bigdata.haiheservice.bean.KeyWords;
import com.chinamcloud.bigdata.haiheservice.bean.MonitorTopic;
import com.chinamcloud.bigdata.haiheservice.bean.TopicIndex;
import com.chinamcloud.bigdata.haiheservice.db.mapper.KeywordsMapper;
import com.chinamcloud.bigdata.haiheservice.db.mapper.MonitorTopicMapper;
import com.chinamcloud.bigdata.haiheservice.db.mapper.MonitorTopicWithIndexMapper;
import com.chinamcloud.bigdata.haiheservice.exception.MsgException;
import com.chinamcloud.bigdata.haiheservice.i18n.MessageSource;
import com.chinamcloud.bigdata.haiheservice.util.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ArgumentPreparedStatementSetter;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.stereotype.Repository;

@Repository
public class MonitorTopicDao {
    @Autowired
    private JdbcTemplate jdbcTemplate;
    private Consumer<MonitorTopic> keywordsConsumer = x -> x.setKeyWords(this.selectTopicKeywords(x.getId()));

    public void delUserDefineTopic(Long topicId, Long userId) {
        this.jdbcTemplate.update("DELETE FROM `t_user_topic` WHERE `topicId`=? AND `userId`=?", new Object[]{topicId, userId});
    }

    private void buildeTopicKeyWordsRelation(final Long topicId, final List<Long> keyWordsIds) {
        this.jdbcTemplate.batchUpdate("insert into `t_topic_keyword`(`topicId`,`keywordId`) values(?,?)", new BatchPreparedStatementSetter(){

            public int getBatchSize() {
                return keyWordsIds.size();
            }

            public void setValues(PreparedStatement ps, int i) throws SQLException {
                ps.setLong(1, topicId);
                ps.setLong(2, (Long)keyWordsIds.get(i));
            }
        });
    }

    private long saveDefineTopic(MonitorTopic topic) {
        DBUtils.ParamSQLWrapper wrapper;
        try {
            wrapper = DBUtils.buildInsertSQL(topic);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        this.jdbcTemplate.update(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
                PreparedStatement statement = con.prepareStatement(wrapper.getSql(), 1);
                ArgumentPreparedStatementSetter statementSetter = new ArgumentPreparedStatementSetter(wrapper.getParamValues());
                statementSetter.setValues(statement);
                return statement;
            }
        }, (KeyHolder)keyHolder);
        return keyHolder.getKey().longValue();
    }

    private List<Long> saveDefineTopicKeyWords(final List<KeyWords> keyWords) {
        return (List)this.jdbcTemplate.execute((ConnectionCallback)new ConnectionCallback<List<Long>>(){

            public List<Long> doInConnection(Connection con) throws SQLException, DataAccessException {
                PreparedStatement statement = con.prepareStatement("INSERT INTO `t_keyword`(`keyword`) VALUES (?)", 1);
                for (KeyWords k : keyWords) {
                    statement.setString(1, k.getKeyWord());
                    statement.addBatch();
                }
                statement.executeBatch();
                ArrayList<Long> list = new ArrayList<Long>();
                ResultSet resultSet = statement.getGeneratedKeys();
                while (resultSet.next()) {
                    list.add(resultSet.getLong(1));
                }
                return list;
            }
        });
    }

    private void deleteDefineTopicKeyWords(Long topicId) {
        this.jdbcTemplate.update("DELETE `t_topic_keyword`.*,`t_keyword`.* FROM `t_topic_keyword`,`t_keyword` WHERE `t_topic_keyword`.`keywordId`=`t_keyword`.`id` AND `topicId`=?", new Object[]{topicId});
    }

    public void saveTopicIndex(TopicIndex topicIndex) {
        String sql = "REPLACE INTO `t_topic_index`(`topicId`,`docTotal`,`hotTotal`,`emotionTotal`,`mediaCoverTotal`,`pre_doc_count`,`yesterday_doc_count`,`pre_hot_value`,`yesterday_hot_value`,`pre_media_cover`,`yesterday_media_cover`,`pre_emotion_value`,`yesterday_emotion_value`,`time`,`updateTime`) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        this.jdbcTemplate.update("REPLACE INTO `t_topic_index`(`topicId`,`docTotal`,`hotTotal`,`emotionTotal`,`mediaCoverTotal`,`pre_doc_count`,`yesterday_doc_count`,`pre_hot_value`,`yesterday_hot_value`,`pre_media_cover`,`yesterday_media_cover`,`pre_emotion_value`,`yesterday_emotion_value`,`time`,`updateTime`) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", new Object[]{topicIndex.getTopicId(), topicIndex.getDocTotal(), topicIndex.getHotTotal(), topicIndex.getEmotionTotal(), topicIndex.getMediaCoverTotal(), topicIndex.getPreDocCount(), topicIndex.getYesterdayDocCount(), topicIndex.getPreHotValue(), topicIndex.getYesterdayHotValue(), topicIndex.getPreMediaCover(), topicIndex.getYesterdayMediaCover(), topicIndex.getPreEmotionValue(), topicIndex.getYesterdayEmotionValue(), topicIndex.getTime(), topicIndex.getUpdateTime()});
    }

    public void saveUserDefineTopic(MonitorTopic topic) {
        List<Long> keywordsIds = this.saveDefineTopicKeyWords(topic.getKeyWords());
        long topicId = this.saveDefineTopic(topic);
        this.buildeTopicKeyWordsRelation(topicId, keywordsIds);
        Long userId = topic.getUid();
        if (userId != null) {
            this.subDefineTopic(userId, topicId, 600);
        }
        this.insertTopicIndexIdTime(topicId);
    }

    private List<MonitorTopic> selectUserSubDefineTopics(Long userId, boolean fillKeywords, String[] sortFields, Long topicId) {
        ArrayList<Number> mapper = new ArrayList<Number>();
        mapper.add(MonitorTopic.Type.USER_DEFINE.intValue());
        StringBuilder query_user_topic = new StringBuilder();
        query_user_topic.append("SELECT DISTINCT t_topic.*,tti.docTotal,tti.hotTotal,tti.emotionTotal,tti.mediaCoverTotal,").append("tti.pre_doc_count,tti.yesterday_doc_count,tti.pre_hot_value,tti.yesterday_hot_value,").append("tti.updateTime,tti.pre_media_cover,tti.yesterday_media_cover,tti.pre_emotion_value,tti.yesterday_emotion_value").append(" FROM t_user_topic LEFT JOIN t_topic ON t_user_topic.topicId=t_topic.id LEFT JOIN t_topic_index ").append("tti ON tti.topicId=t_user_topic.topicId WHERE t_topic.type=?");
        if (topicId != null) {
            query_user_topic.append(" AND `t_user_topic`.`topicId`=?");
            mapper.add(topicId);
        }
        if (userId != null) {
            query_user_topic.append(" AND `t_user_topic`.`userId`=?");
            mapper.add(userId);
        }
        if (sortFields != null && sortFields.length > 0) {
            query_user_topic.append(" order by ").append(StringUtils.join((Object[])sortFields, (String)","));
        }
        return this.jdbcTemplate.query(query_user_topic.toString(), mapper.toArray(), (RowMapper)(fillKeywords ? new MonitorTopicWithIndexMapper(this.keywordsConsumer) : new MonitorTopicWithIndexMapper()));
    }

    public List<MonitorTopic> selectDefineTopics() {
        return this.jdbcTemplate.query("select * from  `t_topic` where `type`=?", new Object[]{MonitorTopic.Type.USER_DEFINE.intValue()}, (RowMapper)new MonitorTopicMapper(this.keywordsConsumer, false));
    }

    public List<KeyWords> selectTopicKeywords(Long id) {
        return this.jdbcTemplate.query("SELECT tk.* FROM `t_topic_keyword` ttk LEFT JOIN `t_keyword` tk ON  tk.`id`=ttk.`keywordId` WHERE ttk.`topicId`=?", new Object[]{id}, (RowMapper)new KeywordsMapper());
    }

    public List<MonitorTopic> selectDefineHotTopics(long userId, int size) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT t_topic.*,tti.docTotal,tti.hotTotal,tti.emotionTotal,tti.mediaCoverTotal,").append("tti.pre_doc_count,tti.yesterday_doc_count,tti.pre_hot_value,tti.yesterday_hot_value,").append("tti.pre_media_cover,tti.yesterday_media_cover,tti.pre_emotion_value,tti.yesterday_emotion_value").append(" FROM t_topic LEFT JOIN (SELECT topicId FROM t_user_topic WHERE userId = ?) AS c ON c.topicId = t_topic.id").append(" LEFT JOIN t_topic_index tti ON tti.topicId = t_topic.id WHERE t_topic.type = ? AND t_topic.subscribable=1 AND(t_topic.uid != ? AND c.topicId IS NULL)").append(" ORDER BY docTotal DESC LIMIT ?");
        return this.jdbcTemplate.query(sql.toString(), new Object[]{userId, MonitorTopic.Type.USER_DEFINE.intValue(), userId, size}, (RowMapper)new MonitorTopicWithIndexMapper(this.keywordsConsumer));
    }

    public MonitorTopic selectDefineTopic(Long topicId) {
        List topics = this.jdbcTemplate.query("SELECT * FROM `t_topic` WHERE `type`=? AND `id`=?", new Object[]{MonitorTopic.Type.USER_DEFINE.intValue(), topicId}, (RowMapper)new MonitorTopicMapper(this.keywordsConsumer, false));
        return topics.size() > 0 ? (MonitorTopic)topics.get(0) : null;
    }

    public List<MonitorTopic> selectUserSubDefineTopics(Long userId) {
        return this.selectUserSubDefineTopics(userId, true, new String[]{"t_topic.registerTime desc"}, null);
    }

    public MonitorTopic selectUserSubDefineTopic(Long userId, Long topicId) {
        List<MonitorTopic> topics = this.selectUserSubDefineTopics(userId, true, null, topicId);
        return topics.size() > 0 ? topics.get(0) : null;
    }

    public void updateDefineTopic(MonitorTopic topic) {
        List<KeyWords> keyWords;
        DBUtils.ParamSQLWrapper wrapper;
        try {
            wrapper = DBUtils.buildUpdateSQL(topic);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (wrapper != null) {
            this.jdbcTemplate.update(wrapper.getSql(), wrapper.getParamValues());
        }
        if ((keyWords = topic.getKeyWords()) != null && keyWords.size() > 0) {
            this.deleteDefineTopicKeyWords(topic.getId());
            List<Long> keywordsId = this.saveDefineTopicKeyWords(keyWords);
            this.buildeTopicKeyWordsRelation(topic.getId(), keywordsId);
        }
    }

    public boolean subDefineTopic(Long userId, Long topicId, int monith) {
        List list = this.jdbcTemplate.query("SELECT t_topic.`id`,t_topic.`subscribable`,t.`subEndTime`,`t_topic`.`uid` FROM t_topic LEFT JOIN (SELECT `topicId`,`subEndTime` FROM `t_user_topic` WHERE `userId`=?) AS t ON t.topicId=t_topic.`id` WHERE t_topic.`id`=? AND `t_topic`.`type`=?", new Object[]{userId, topicId, MonitorTopic.Type.USER_DEFINE.intValue()}, (RowMapper)new RowMapper<Object[]>(){

            public Object[] mapRow(ResultSet rs, int rowNum) throws SQLException {
                Object[] o = new Object[]{rs.getInt("subscribable"), rs.getTimestamp("subEndTime"), rs.getLong("id"), rs.getLong("uid")};
                return o;
            }
        });
        if (list.size() == 0) {
            throw new MsgException(MessageSource.getMsg("topic_not_exist"));
        }
        Object[] o = (Object[])list.get(0);
        if (!(o[3] != null && o[3].equals(userId) || (Integer)o[0] != 0)) {
            throw new MsgException(MessageSource.getMsg("topic_can_not_sub"));
        }
        Timestamp subEndTime = (Timestamp)o[1];
        Date date = new Date();
        if (subEndTime == null || subEndTime.before(date)) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.set(2, calendar.get(2) + monith);
            Timestamp timestamp = new Timestamp(calendar.getTime().getTime());
            this.jdbcTemplate.update("INSERT INTO `t_user_topic`(`userId`,`topicId`,`subBeginTime`,`subEndTime`) VALUES(?,?,?,?)", new Object[]{userId, o[2], new Timestamp(date.getTime()), timestamp});
            return true;
        }
        throw new MsgException(MessageSource.getMsg("user_has_sub"));
    }

    public void updateTopicIndexTime(Long topicId) {
        String sql = "UPDATE t_topic_index SET updateTime = ? WHERE topicId = ?";
        this.jdbcTemplate.update(sql, new Object[]{new Date(), topicId});
    }

    public void insertTopicIndexIdTime(Long topicId) {
        String sql = "INSERT INTO t_topic_index (topicId) VALUES(?)";
        this.jdbcTemplate.update(sql, new Object[]{topicId});
    }
}

