/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.es;

import com.chinamcloud.bigdata.haiheservice.es.EsFeedbackQuery;
import com.chinamcloud.bigdata.haiheservice.es.pojo.EsBuildQuery;
import com.chinamcloud.bigdata.haiheservice.es.pojo.EsBuildSort;
import com.chinamcloud.bigdata.haiheservice.es.pojo.EsBuilderPos;
import com.chinamcloud.bigdata.haiheservice.es.pojo.EsQueryParams;
import java.util.Collection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;

public class ParamsEsQueryProcessor {
    private static Logger logger = LogManager.getLogger(ParamsEsQueryProcessor.class);
    private EsFeedbackQuery feedbackQuery;
    private EsQueryParams params;

    public ParamsEsQueryProcessor(EsFeedbackQuery feedbackQuery) {
        this.feedbackQuery = feedbackQuery;
    }

    protected void setParams() {
        this.setId().setBuilderQuery().setPos().setSort();
    }

    protected ParamsEsQueryProcessor setId() {
        String id = this.feedbackQuery.getId();
        if (id != null) {
            this.params.setId(id);
        }
        return this;
    }

    protected ParamsEsQueryProcessor setBuilderQuery() {
        QueryBuilder query = EsBuildQuery.getQuery(this.feedbackQuery);
        if (query != null) {
            this.params.setQuery(query);
        }
        return this;
    }

    protected ParamsEsQueryProcessor setPos() {
        int[] pos = EsBuilderPos.getSearchPos(this.feedbackQuery);
        if (pos.length == 2) {
            this.params.setPos(pos);
        }
        return this;
    }

    protected ParamsEsQueryProcessor setSort() {
        Collection<FieldSortBuilder> sort = EsBuildSort.getSearchSort(this.feedbackQuery);
        if (sort != null) {
            this.params.setSort(sort);
        }
        return this;
    }

    public void process(EsQueryParams params) throws Exception {
        this.params = params;
        this.setParams();
    }
}

