/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.es.dao;

import com.chinamcloud.bigdata.haiheservice.es.pojo.EsQueryParams;
import java.util.Collection;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.springframework.stereotype.Component;

@Component
public class EsBaseDao {
    public GetResponse searchDocument(EsQueryParams params) {
        TransportClient client = params.getClient();
        String typeName = params.getTypeName();
        String indexName = params.getIndexName();
        String id = params.getId();
        GetResponse response = (GetResponse)client.prepareGet(indexName, typeName, String.valueOf(id)).get();
        return response;
    }

    public SearchResponse faceter(EsQueryParams params) {
        TransportClient client = params.getClient();
        String typeName = params.getTypeName();
        String indexName = params.getIndexName();
        QueryBuilder query = params.getQuery();
        AggregationBuilder agg = params.getAgg();
        SearchRequestBuilder builder = client.prepareSearch(new String[]{indexName}).setTypes(new String[]{typeName}).setQuery(query).addAggregation(agg);
        SearchResponse response = (SearchResponse)builder.execute().actionGet();
        return response;
    }

    public SearchResponse searcher(EsQueryParams params) {
        TransportClient client = params.getClient();
        String typeName = params.getTypeName();
        String indexName = params.getIndexName();
        QueryBuilder query = params.getQuery();
        int[] pos = params.getPos();
        Collection<FieldSortBuilder> sort = params.getSort();
        SearchRequestBuilder requestBuilder = client.prepareSearch(new String[]{indexName}).setTypes(new String[]{typeName}).setQuery(query).setFrom(pos[0]).setSize(pos[1]);
        if (sort != null && sort.size() > 0) {
            sort.forEach(x -> requestBuilder.addSort((SortBuilder)x));
        }
        SearchResponse response = (SearchResponse)requestBuilder.execute().actionGet();
        return response;
    }
}

