/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.es.parser;

import com.chinamcloud.bigdata.haiheservice.bean.HotTopic;
import com.chinamcloud.bigdata.haiheservice.bean.Page;
import com.chinamcloud.bigdata.haiheservice.bean.Trend;
import com.chinamcloud.bigdata.haiheservice.es.bean.HotTopicStatistic;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class HotTopicDataParser {
    private SimpleDateFormat dateFormat2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.ENGLISH);

    public Page<HotTopic> parseRecords(List<HotTopicStatistic> result) {
        ArrayList<HotTopic> topics = new ArrayList<HotTopic>();
        for (HotTopicStatistic feedback : result) {
            HotTopic topic = new HotTopic();
            List<Trend> doc_value = feedback.getDoc_value();
            List<Trend> emotion_value = feedback.getEmotion_value();
            List<Trend> hot_value = feedback.getHot_value();
            List<Trend> media_cover = feedback.getMedia_cover();
            long docValue = doc_value.stream().mapToLong(x -> x.getValue()).sum();
            long hotValue = hot_value.stream().mapToLong(x -> x.getValue()).sum();
            long emotionScore = emotion_value.stream().mapToLong(x -> x.getValue()).sum();
            long mediaCover = media_cover.stream().mapToLong(x -> x.getValue()).sum();
            topic.setDocValue(docValue);
            topic.setEmotionScore(emotionScore);
            topic.setHotValue(hotValue);
            topic.setMediaCover(mediaCover);
            topic.setCluster(feedback.getCluster());
            topic.setTitle(feedback.getCluster());
            topic.setClusterId(feedback.getNews().get(0).getClusterId());
            topic.setDescription(feedback.getNews().get(0).getDescription());
            topic.setPubTime(this.dateFormat2.format(feedback.getNews().get(0).getPubTime()));
            topic.setPubTimeEnd(this.dateFormat2.format(feedback.getNews().get(feedback.getNews().size() - 1).getPubTime()));
            topics.add(topic);
        }
        Page<HotTopic> pager = new Page<HotTopic>(topics);
        pager.setTotalCount(result.size());
        pager.setPageSize(1);
        pager.setTotalPages(1);
        return pager;
    }
}

