/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.es.parser;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.chinamcloud.bigdata.haiheservice.bean.HotNews;
import com.chinamcloud.bigdata.haiheservice.es.bean.EsApsSearchField;
import com.chinamcloud.bigdata.haiheservice.es.result.EsPagedResult;
import com.chinamcloud.bigdata.haiheservice.es.result.EsSearchResult;
import com.chinamcloud.bigdata.haiheservice.util.JSONUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class NewsDetailParser {
    private SimpleDateFormat dateFormat2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.ENGLISH);

    public HotNews parseRecords(EsPagedResult<EsSearchResult> result) {
        List<EsApsSearchField> records = ((EsSearchResult)result.getResult()).getRecords();
        if (records != null && records.size() > 0) {
            EsApsSearchField feedback = records.get(0);
            HotNews hotNew = new HotNews();
            String description = feedback.getDescription();
            if (StringUtils.isEmpty((CharSequence)description)) {
                description = "";
            }
            hotNew.setDescription(description);
            hotNew.setSrc(feedback.getTbNickname());
            hotNew.setCity(feedback.getCrawlerKeywords());
            hotNew.setDocId(feedback.getId());
            hotNew.setEmotionScore(feedback.getEmotionScore());
            hotNew.setEmotionTendency(feedback.getEmotionTendency());
            hotNew.setPubTime(this.dateFormat2.format(feedback.getPubTime()));
            hotNew.setTitle(feedback.getSubject());
            hotNew.setUrl(feedback.getRefererUrl());
            hotNew.setPics(feedback.getPics());
            hotNew.setClusterId(feedback.getClusterId());
            hotNew.setExportTime(this.dateFormat2.format(new Date()));
            hotNew.setSource(feedback.getSource());
            hotNew.setKeywords(feedback.getSummaryKeywordList());
            return hotNew;
        }
        return null;
    }

    private List<String> parsePics(Map<String, String> cfsMap) {
        JSONArray jsonArray;
        String valueStr;
        ArrayList<String> picUrls = new ArrayList<String>();
        if (cfsMap != null && !StringUtils.isEmpty((CharSequence)(valueStr = cfsMap.get("101148"))) && (jsonArray = JSONUtils.parseJSONArray(valueStr)) != null) {
            int jsonArrayLength = jsonArray.size();
            for (int i = 0; i < jsonArrayLength; ++i) {
                JSONObject attachment = jsonArray.getJSONObject(i);
                String picUrl = attachment.getString("url");
                if (StringUtils.isEmpty((CharSequence)picUrl)) continue;
                picUrls.add(picUrl);
            }
        }
        return picUrls;
    }
}

