/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.es.pojo;

import com.chinamcloud.bigdata.haiheservice.es.EsFeedbackQuery;
import com.chinamcloud.bigdata.haiheservice.es.pojo.EsBuildSort;
import com.chinamcloud.bigdata.haiheservice.es.pojo.EsBuilderPos;
import com.chinamcloud.bigdata.haiheservice.es.pojo.IEsBuildAgg;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortOrder;

public class EsHotEventAndNewsAgg
implements IEsBuildAgg {
    @Override
    public AggregationBuilder buildAgg(EsFeedbackQuery query) {
        String field = query.getFacetField();
        FieldSortBuilder facetSort = EsBuildSort.getFacetSort(query);
        int size = EsBuilderPos.getFacetPos(query);
        Integer facetMincount = query.getFacetMincount();
        TermsAggregationBuilder aggregation = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"agg").field(field)).size(size).minDocCount((long)facetMincount.intValue());
        if (facetSort.getFieldName().equals("emotionScore")) {
            if (SortOrder.DESC == facetSort.order()) {
                aggregation.order(Terms.Order.aggregation((String)"avg_emotionScore", (boolean)false));
            } else {
                aggregation.order(Terms.Order.aggregation((String)"avg_emotionScore", (boolean)true));
            }
        } else if (facetSort.getFieldName().equals("pubTime")) {
            if (SortOrder.DESC == facetSort.order()) {
                aggregation.order(Terms.Order.aggregation((String)"newest_pubime", (boolean)false));
            } else {
                aggregation.order(Terms.Order.aggregation((String)"newest_pubime", (boolean)true));
            }
        }
        ((TermsAggregationBuilder)((TermsAggregationBuilder)aggregation.subAggregation((AggregationBuilder)AggregationBuilders.topHits((String)"top").size(1).sort("pubTime", SortOrder.DESC))).subAggregation((AggregationBuilder)AggregationBuilders.avg((String)"avg_emotionScore").field("emotionScore"))).subAggregation((AggregationBuilder)AggregationBuilders.max((String)"newest_pubime").field("pubTime"));
        return aggregation;
    }
}

