/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.parser;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.chinamcloud.bigdata.haiheservice.bean.SenSourceFacet;
import com.chinamcloud.bigdata.haiheservice.util.JSONUtils;
import com.chinamcloud.bigdata.haiheservice.xz.IAliDataParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SenSourceFacetParser
implements IAliDataParser<List<SenSourceFacet>> {
    private static Logger logger = LogManager.getLogger(SenSourceFacetParser.class);

    @Override
    public List<SenSourceFacet> parserData(String data) {
        JSONObject jsonObject = JSONUtils.getJSONObject(data);
        JSONObject dataObject = JSONUtils.getJSONObject("data", jsonObject);
        JSONArray listDataArray = JSONUtils.getJSONArray("result", dataObject);
        logger.info("listDataArray2=" + listDataArray);
        if (listDataArray != null) {
            int length = listDataArray.size();
            ArrayList<SenSourceFacet> facets = new ArrayList<SenSourceFacet>();
            try {
                for (int i = 0; i < length; ++i) {
                    JSONObject object = listDataArray.getJSONObject(i);
                    if (object == null) continue;
                    int count = Integer.parseInt(object.getString("count"));
                    SenSourceFacet facet = new SenSourceFacet();
                    facet.setFeedbackCount(count);
                    facets.add(facet);
                }
                return facets;
            }
            catch (Exception e) {
                e.printStackTrace();
                facets = null;
                logger.error("param listData failed", (Throwable)e);
            }
        }
        return Collections.emptyList();
    }
}

