/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.parser;

import com.alibaba.fastjson.JSONObject;
import com.chinamcloud.bigdata.haiheservice.bean.FacetTrend;
import com.chinamcloud.bigdata.haiheservice.bean.HotNews;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TopicStateAnalyserParser {
    private static Logger logger = LogManager.getLogger(TopicStateAnalyserParser.class);
    private SimpleDateFormat formatToHour = new SimpleDateFormat("yyyy-MM-dd HH");
    private SimpleDateFormat formatToDay = new SimpleDateFormat("yyyy-MM-dd");

    public JSONObject parserData(List<HotNews> newsList, String pubTimeStart, String pubTimeEnd) {
        ArrayList<Long> timePoints = new ArrayList<Long>();
        ArrayList<FacetTrend> topics = new ArrayList<FacetTrend>();
        if (newsList == null || newsList.size() == 0) {
            JSONObject object = new JSONObject();
            object.put("timeType", (Object)"hour");
            object.put("doc_value", null);
            object.put("emotion_value", null);
            return object;
        }
        try {
            long timeStart = this.formatToHour.parse(pubTimeStart.substring(0, 13)).getTime();
            long timeEnd = this.formatToHour.parse(pubTimeEnd.substring(0, 13)).getTime();
            int betweenHours = (int)((timeEnd / 1000L - timeStart / 1000L) / 3600L);
            if (betweenHours <= 24) {
                for (int i = 0; i < betweenHours + 1; ++i) {
                    topics.add(new FacetTrend());
                    timePoints.add(timeStart + (long)(1000 * i * 60 * 60));
                }
                return (JSONObject)this.parserDataByHour(newsList, topics, timePoints, betweenHours + 1);
            }
            timeStart = this.formatToDay.parse(pubTimeStart.substring(0, 10)).getTime();
            timeEnd = this.formatToDay.parse(pubTimeEnd.substring(0, 10)).getTime();
            int betweenDays = (int)((timeEnd / 1000L - timeStart / 1000L) / 86400L);
            for (int i = 0; i < betweenDays + 1; ++i) {
                topics.add(new FacetTrend());
                timePoints.add(timeStart + (long)(1000 * i * 24 * 60 * 60));
            }
            return (JSONObject)this.parserDataByDay(newsList, topics, timePoints, betweenDays + 1);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Object parserDataByHour(List<HotNews> newsList, List<FacetTrend> topics, List<Long> timePoints, int interval) {
        try {
            for (HotNews hotNews : newsList) {
                long pubTime = this.formatToHour.parse(hotNews.getPubTime().substring(0, 13)).getTime();
                int emotionScore = hotNews.getEmotionScore();
                int index = (int)((pubTime / 1000L - timePoints.get(0) / 1000L) / 3600L);
                logger.info("pubTime=" + pubTime);
                logger.info("timePoint[0]=" + timePoints.get(0));
                logger.info("index=" + index);
                if (index < 0) {
                    index = 0;
                } else if (index > interval) {
                    index = interval;
                }
                topics.get(index).setTimePoint(timePoints.get(index));
                topics.get(index).setDocCount(topics.get(index).getDocCount() + 1L);
                topics.get(index).setEmotionScore(topics.get(index).getEmotionScore() + (long)emotionScore);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        JSONObject object = new JSONObject();
        object.put("timeType", (Object)"hour");
        List<TopicPerporityCount> emotionResult = this.processEmotionResult(topics, timePoints, interval);
        List<TopicPerporityCount> docValutResult = this.processDocValueResult(topics, timePoints, interval);
        List<TopicPerporityCount> emotionTrendResult = this.processEmotion2DocValueResult(emotionResult, docValutResult, timePoints);
        object.put("doc_value", docValutResult);
        object.put("emotion_value", emotionTrendResult);
        return object;
    }

    public Object parserDataByDay(List<HotNews> newsList, List<FacetTrend> topics, List<Long> timePoints, int interval) {
        try {
            for (HotNews hotNews : newsList) {
                long pubTime = this.formatToDay.parse(hotNews.getPubTime().substring(0, 10)).getTime();
                int emotionScore = hotNews.getEmotionScore();
                int index = (int)((pubTime / 1000L - timePoints.get(0) / 1000L) / 86400L);
                if (index < 0) {
                    index = 0;
                } else if (index > interval) {
                    index = interval;
                }
                timePoints.get(index);
                topics.get(index).setTimePoint(timePoints.get(index));
                topics.get(index).setDocCount(topics.get(index).getDocCount() + 1L);
                topics.get(index).setEmotionScore(topics.get(index).getEmotionScore() + (long)emotionScore);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        JSONObject object = new JSONObject();
        object.put("timeType", (Object)"day");
        List<TopicPerporityCount> emotionResult = this.processEmotionResult(topics, timePoints, interval);
        List<TopicPerporityCount> docValutResult = this.processDocValueResult(topics, timePoints, interval);
        List<TopicPerporityCount> emotionTrendResult = this.processEmotion2DocValueResult(emotionResult, docValutResult, timePoints);
        object.put("doc_value", docValutResult);
        object.put("emotion_value", emotionTrendResult);
        return object;
    }

    private List<TopicPerporityCount> processEmotionResult(List<FacetTrend> topics, List<Long> timePoints, int interval) {
        ArrayList<TopicPerporityCount> result = new ArrayList<TopicPerporityCount>();
        for (int i = 0; i < interval; ++i) {
            long emotionScore;
            TopicPerporityCount tmp = new TopicPerporityCount();
            long time = timePoints.get(i);
            tmp.setTime(time);
            if (i == 0) {
                emotionScore = topics.get(i).getEmotionScore();
                tmp.setCount(emotionScore);
            } else {
                emotionScore = topics.get(i - 1).getEmotionScore() + topics.get(i).getEmotionScore();
                tmp.setCount(emotionScore);
                topics.get(i).setEmotionScore(emotionScore);
            }
            result.add(tmp);
        }
        return result;
    }

    private List<TopicPerporityCount> processDocValueResult(List<FacetTrend> topics, List<Long> timePoints, int interval) {
        ArrayList<TopicPerporityCount> result = new ArrayList<TopicPerporityCount>();
        for (int i = 0; i < interval; ++i) {
            long docCount;
            TopicPerporityCount tmp = new TopicPerporityCount();
            long time = timePoints.get(i);
            tmp.setTime(time);
            if (i == 0) {
                docCount = topics.get(i).getDocCount();
                tmp.setCount(docCount);
            } else {
                docCount = topics.get(i - 1).getDocCount() + topics.get(i).getDocCount();
                tmp.setCount(docCount);
                topics.get(i).setDocCount(docCount);
            }
            result.add(tmp);
        }
        return result;
    }

    private List<TopicPerporityCount> processEmotion2DocValueResult(List<TopicPerporityCount> emotionResult, List<TopicPerporityCount> docValueResult, List<Long> timePoints) {
        ArrayList<TopicPerporityCount> result = new ArrayList<TopicPerporityCount>();
        for (int i = 0; i < emotionResult.size(); ++i) {
            TopicPerporityCount tmp = new TopicPerporityCount();
            long time = timePoints.get(i);
            tmp.setTime(time);
            long emotionValue = emotionResult.get(i).getCount();
            long docValue = docValueResult.get(i).getCount();
            if (docValue != 0L) {
                tmp.setCount(emotionValue / docValue);
            } else {
                tmp.setCount(0L);
            }
            result.add(tmp);
        }
        return result;
    }

    class TopicPerporityCount {
        long time;
        long count;

        TopicPerporityCount() {
        }

        public long getTime() {
            return this.time;
        }

        public void setTime(long time) {
            this.time = time;
        }

        public long getCount() {
            return this.count;
        }

        public void setCount(long count) {
            this.count = count;
        }
    }
}

