/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.service;

import com.chinamcloud.bigdata.haiheservice.bean.AlarmContactorBean;
import com.chinamcloud.bigdata.haiheservice.bean.AlarmWatchInfoBean;
import com.chinamcloud.bigdata.haiheservice.dao.AlarmConfigDao;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AlarmConfigService {
    @Autowired
    private AlarmConfigDao dao;

    public AlarmContactorBean saveContactor(AlarmContactorBean bean) {
        long id = this.dao.saveContactor(bean);
        AlarmContactorBean result = null;
        if (id > 0L) {
            result = new AlarmContactorBean();
            result.setId(id);
        }
        return result;
    }

    public boolean updateContactor(AlarmContactorBean bean) {
        return this.dao.updateContactor(bean);
    }

    public boolean deleteContactor(long id) {
        return this.dao.deleteContactor(id);
    }

    public List<AlarmContactorBean> getAllContactors(long userId) {
        List<AlarmContactorBean> allContactors = this.dao.getAllContactors(userId);
        HashSet<AlarmContactorBean> result = new HashSet<AlarmContactorBean>(allContactors);
        return new ArrayList<AlarmContactorBean>(result);
    }

    public List<AlarmContactorBean> getContactorsByTaskId(long userId, long taskId) {
        List<AlarmContactorBean> contactorsByTaskId = this.dao.getContactorsByTaskId(userId, taskId);
        HashSet<AlarmContactorBean> result = new HashSet<AlarmContactorBean>(contactorsByTaskId);
        return new ArrayList<AlarmContactorBean>(result);
    }

    public AlarmWatchInfoBean saveWatchInfo(AlarmWatchInfoBean bean) {
        long taskId = this.dao.saveWatchInfo(bean);
        AlarmWatchInfoBean result = null;
        if (taskId > 0L) {
            result = new AlarmWatchInfoBean();
            result.setTaskId(taskId);
        }
        return result;
    }

    public boolean updateWatchInfo(AlarmWatchInfoBean bean) {
        return this.dao.updateWatchInfo(bean);
    }

    public AlarmWatchInfoBean getWatchInfo(long userId, long taskId) {
        return this.dao.getWatchInfo(userId, taskId);
    }

    public List<AlarmWatchInfoBean> getWatchTask(long userId) {
        return this.dao.getWatchTask(userId);
    }

    public List<AlarmWatchInfoBean> getWatchTaskWithContactors() {
        return this.dao.getWatchTaskWithContactors();
    }

    public boolean deleteWatchTask(long userId, int taskId) {
        return this.dao.deleteWatchTask(userId, taskId);
    }

    public boolean setWatchTaskStatus(long userId, int taskId, AlarmWatchInfoBean.Status status) {
        return this.dao.setWatchTaskStatus(userId, taskId, status);
    }
}

