/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.util;

public class AliSearchKeyRuleUtils {
    private static final String RULE_PATTERN = "[\u4e00-\u9fa5\\w\\s]+";

    public static boolean matchRule(String str) {
        if (!str.matches(RULE_PATTERN)) {
            return false;
        }
        String[] array = str.split(" ");
        boolean check = true;
        for (String temp : array) {
            int i = temp.length();
            int chineseCount = 0;
            int engCount = 0;
            int numberCount = 0;
            WordType type = null;
            block6: while (i > 0) {
                type = AliSearchKeyRuleUtils.getWordType(temp.charAt(--i));
                switch (type) {
                    case CHINESE: {
                        ++chineseCount;
                        continue block6;
                    }
                    case ENG: {
                        ++engCount;
                        continue block6;
                    }
                    case NUMBER: {
                        ++numberCount;
                        continue block6;
                    }
                }
            }
            int totalWord = chineseCount + numberCount + engCount;
            if (chineseCount > 2 || totalWord >= 4 && numberCount < totalWord) continue;
            check = false;
            break;
        }
        return check;
    }

    private static boolean isChinese(char c) {
        return c >= '\u4e00' && c <= '\u9fa5';
    }

    private static boolean isNumber(char c) {
        return c >= '0' && c <= '9';
    }

    private static boolean isEng(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    private static WordType getWordType(char c) {
        if (AliSearchKeyRuleUtils.isChinese(c)) {
            return WordType.CHINESE;
        }
        if (AliSearchKeyRuleUtils.isEng(c)) {
            return WordType.ENG;
        }
        if (AliSearchKeyRuleUtils.isNumber(c)) {
            return WordType.NUMBER;
        }
        return WordType.FORBIDDEN;
    }

    private static enum WordType {
        ENG,
        CHINESE,
        NUMBER,
        FORBIDDEN;

    }
}

