/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.bean;

import com.chinamcloud.bigdata.haiheservice.bean.Page;
import java.util.Iterator;
import java.util.List;

public class PageDataIterator<T>
implements Iterator<T> {
    private int currentIndex = 0;
    private int currentPage = 1;
    private int totalPage = 0;
    private Page<T> page;
    private IPageDataGenerator<T> function;

    public PageDataIterator(IPageDataGenerator<T> function) {
        this.function = function;
    }

    @Override
    public boolean hasNext() {
        if (this.page == null && (this.totalPage == 0 || this.currentPage <= this.totalPage)) {
            this.page = this.function.generate(this.currentPage);
        }
        List<T> records = null;
        if (this.page != null && (records = this.page.getRecords()) != null && records.size() > 0 && (this.currentIndex < records.size() || this.currentPage < this.totalPage)) {
            if (this.totalPage == 0) {
                this.totalPage = this.page.getTotalPages();
            }
            return true;
        }
        return false;
    }

    @Override
    public T next() {
        List<T> records = this.page.getRecords();
        T t = records.get(this.currentIndex);
        ++this.currentIndex;
        if (this.currentIndex >= records.size()) {
            ++this.currentPage;
            this.currentIndex = 0;
            this.page = null;
        }
        return t;
    }

    public static interface IPageDataGenerator<T> {
        public Page<T> generate(int var1);
    }
}

