/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.cache;

import java.util.ArrayList;
import java.util.Collection;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;

public class AppCacheManager
implements CacheManager {
    private CacheManager redisCacheManager;
    private CacheManager ehCacheManager;
    private static final String redisPrefix = "redis";

    public Cache getCache(String name) {
        if (name.startsWith(redisPrefix)) {
            return this.redisCacheManager.getCache(name);
        }
        return this.ehCacheManager.getCache(name);
    }

    public Collection<String> getCacheNames() {
        ArrayList<String> cacheNames = new ArrayList<String>();
        if (this.redisCacheManager != null) {
            cacheNames.addAll(this.redisCacheManager.getCacheNames());
        }
        if (this.ehCacheManager != null) {
            cacheNames.addAll(this.ehCacheManager.getCacheNames());
        }
        return cacheNames;
    }

    public CacheManager getRedisCacheManager() {
        return this.redisCacheManager;
    }

    public void setRedisCacheManager(CacheManager redisCacheManager) {
        this.redisCacheManager = redisCacheManager;
    }

    public CacheManager getEhCacheManager() {
        return this.ehCacheManager;
    }

    public void setEhCacheManager(CacheManager ehCacheManager) {
        this.ehCacheManager = ehCacheManager;
    }
}

