/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.cache;

import java.util.Objects;
import java.util.regex.Pattern;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.data.redis.cache.RedisCache;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.core.RedisOperations;

public class ExtendedRedisCacheManager
extends RedisCacheManager {
    private static Logger logger = LogManager.getLogger(ExtendedRedisCacheManager.class);
    private static final ScriptEngine scriptEngine = new ScriptEngineManager().getEngineByName("JavaScript");
    private static final Pattern pattern = Pattern.compile("[+\\-*/%]");
    private char separator = (char)35;

    public ExtendedRedisCacheManager(RedisOperations redisOperations) {
        super(redisOperations);
    }

    protected RedisCache createCache(String cacheName) {
        long expiration = this.computeExpiration(cacheName);
        int index = cacheName.indexOf(this.getSeparator());
        if (index > 0) {
            expiration = this.getExpiration(cacheName, index, expiration);
        }
        return new RedisCache(cacheName, this.isUsePrefix() ? this.getCachePrefix().prefix(cacheName) : null, this.getRedisOperations(), expiration);
    }

    protected long getExpiration(String name, int separatorIndex, long defalutExp) {
        Long expiration = null;
        String expirationAsString = name.substring(separatorIndex + 1);
        try {
            expiration = pattern.matcher(expirationAsString).find() ? Long.valueOf(NumberUtils.toLong((String)scriptEngine.eval(expirationAsString).toString(), (long)defalutExp)) : Long.valueOf(NumberUtils.toLong((String)expirationAsString, (long)defalutExp));
        }
        catch (ScriptException e) {
            logger.error("\u7f13\u5b58\u65f6\u95f4\u8f6c\u6362\u9519\u8bef:{},\u5f02\u5e38:{}", (Object)name, (Object)e.getMessage());
        }
        return Objects.nonNull(expiration) ? expiration : defalutExp;
    }

    public char getSeparator() {
        return this.separator;
    }

    public void setSeparator(char separator) {
        this.separator = separator;
    }
}

