/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.controller;

import com.chinamcloud.bigdata.haiheservice.CodeResult;
import com.chinamcloud.bigdata.haiheservice.bean.AlarmContactorBean;
import com.chinamcloud.bigdata.haiheservice.bean.AlarmWatchInfoBean;
import com.chinamcloud.bigdata.haiheservice.bean.User;
import com.chinamcloud.bigdata.haiheservice.i18n.MessageSource;
import com.chinamcloud.bigdata.haiheservice.service.AlarmConfigService;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/alarm"})
public class AlarmConfigController {
    @Autowired
    private AlarmConfigService alarmContactorService;

    @RequestMapping(value={"/saveContactor"}, method={RequestMethod.POST})
    public Object saveContactor(@Valid @RequestBody AlarmContactorBean param, BindingResult bindingResult, HttpServletRequest request) {
        if (bindingResult.hasErrors()) {
            return new CodeResult(CodeResult.Code.Failed, MessageSource.getMsg("params_error"));
        }
        User user = (User)request.getAttribute("user");
        AlarmWatchInfoBean task = this.alarmContactorService.getWatchInfo(user.getId(), param.getTaskId());
        if (task == null) {
            return CodeResult.failedResultByMsgSource("task_not_exist");
        }
        AlarmContactorBean result = this.alarmContactorService.saveContactor(param);
        if (result != null) {
            return new CodeResult(CodeResult.Code.Success, result);
        }
        return new CodeResult(CodeResult.Code.Failed);
    }

    @RequestMapping(value={"/updateContactor"}, method={RequestMethod.POST})
    public Object updateContactor(@Valid @RequestBody AlarmContactorBean param, BindingResult bindingResult, HttpServletRequest request) {
        if (bindingResult.hasErrors()) {
            return new CodeResult(CodeResult.Code.Failed, MessageSource.getMsg("params_error"));
        }
        User user = (User)request.getAttribute("user");
        AlarmWatchInfoBean task = this.alarmContactorService.getWatchInfo(user.getId(), param.getTaskId());
        if (task == null) {
            return CodeResult.failedResultByMsgSource("task_not_exist");
        }
        if (this.alarmContactorService.updateContactor(param)) {
            return new CodeResult(CodeResult.Code.Success);
        }
        return new CodeResult(CodeResult.Code.Failed);
    }

    @RequestMapping(value={"/deleteContactor"}, method={RequestMethod.POST})
    public Object deleteContactor(@RequestBody Map<String, String> params, HttpServletRequest request) {
        Long taskId;
        Integer id;
        try {
            id = Integer.valueOf(params.get("id"));
            taskId = Long.valueOf(params.get("taskId"));
        }
        catch (NumberFormatException e) {
            return new CodeResult(CodeResult.Code.Failed, MessageSource.getMsg("params_error"));
        }
        User user = (User)request.getAttribute("user");
        AlarmWatchInfoBean task = this.alarmContactorService.getWatchInfo(user.getId(), taskId);
        if (task == null) {
            return CodeResult.failedResultByMsgSource("task_not_exist");
        }
        if (this.alarmContactorService.deleteContactor(id.intValue())) {
            return new CodeResult(CodeResult.Code.Success);
        }
        return new CodeResult(CodeResult.Code.Failed);
    }

    @RequestMapping(value={"/getAllContactors"}, method={RequestMethod.POST})
    public Object getAllContactors(HttpServletRequest request) {
        User user = (User)request.getAttribute("user");
        List<AlarmContactorBean> result = this.alarmContactorService.getAllContactors(user.getId());
        return new CodeResult(CodeResult.Code.Success, result);
    }

    @RequestMapping(value={"/getContactorsByTaskId"}, method={RequestMethod.POST})
    public Object getContactorsByTaskId(@RequestBody Map<String, String> params, HttpServletRequest request) {
        Integer taskId;
        try {
            taskId = Integer.valueOf(params.get("taskId"));
        }
        catch (NumberFormatException e) {
            return new CodeResult(CodeResult.Code.Failed, MessageSource.getMsg("params_error"));
        }
        User user = (User)request.getAttribute("user");
        AlarmWatchInfoBean task = this.alarmContactorService.getWatchInfo(user.getId(), taskId.intValue());
        if (task == null) {
            return CodeResult.failedResultByMsgSource("task_not_exist");
        }
        List<AlarmContactorBean> result = this.alarmContactorService.getContactorsByTaskId(user.getId(), taskId.intValue());
        return new CodeResult(CodeResult.Code.Success, result);
    }

    @RequestMapping(value={"/saveWatchInfo"}, method={RequestMethod.POST})
    public Object saveWatchInfo(@Valid @RequestBody AlarmWatchInfoBean param, BindingResult bindingResult, HttpServletRequest request) {
        if (bindingResult.hasErrors()) {
            return new CodeResult(CodeResult.Code.Failed, MessageSource.getMsg("params_error"));
        }
        User user = (User)request.getAttribute("user");
        param.setUserId(user.getId());
        AlarmWatchInfoBean result = this.alarmContactorService.saveWatchInfo(param);
        if (result != null) {
            return new CodeResult(CodeResult.Code.Success, result);
        }
        return new CodeResult(CodeResult.Code.Failed);
    }

    @RequestMapping(value={"/updateWatchInfo"}, method={RequestMethod.POST})
    public Object updateWatchInfo(@Valid @RequestBody AlarmWatchInfoBean param, BindingResult bindingResult, HttpServletRequest request) {
        if (bindingResult.hasErrors() || param.getTaskId() == null) {
            return new CodeResult(CodeResult.Code.Failed, MessageSource.getMsg("params_error"));
        }
        User user = (User)request.getAttribute("user");
        AlarmWatchInfoBean task = this.alarmContactorService.getWatchInfo(user.getId(), param.getTaskId());
        if (task == null) {
            return CodeResult.failedResultByMsgSource("task_not_exist");
        }
        if (this.alarmContactorService.updateWatchInfo(param)) {
            return new CodeResult(CodeResult.Code.Success);
        }
        return new CodeResult(CodeResult.Code.Failed);
    }

    @RequestMapping(value={"/getWatchInfo"}, method={RequestMethod.POST})
    public Object getWatchInfo(@RequestBody Map<String, String> params, HttpServletRequest request) {
        Integer taskId;
        try {
            taskId = Integer.valueOf(params.get("taskId"));
        }
        catch (NumberFormatException e) {
            return new CodeResult(CodeResult.Code.Failed, MessageSource.getMsg("params_error"));
        }
        User user = (User)request.getAttribute("user");
        AlarmWatchInfoBean result = this.alarmContactorService.getWatchInfo(user.getId(), taskId.intValue());
        if (result == null) {
            return CodeResult.failedResultByMsgSource("task_not_exist");
        }
        return new CodeResult(CodeResult.Code.Success, result);
    }

    @RequestMapping(value={"/getWatchTask"}, method={RequestMethod.POST})
    public Object getWatchTask(HttpServletRequest request) {
        User user = (User)request.getAttribute("user");
        List<AlarmWatchInfoBean> result = this.alarmContactorService.getWatchTask(user.getId());
        return new CodeResult(CodeResult.Code.Success, result);
    }

    @RequestMapping(value={"/deleteWatchTask"}, method={RequestMethod.POST})
    public Object deleteWatchTask(@RequestBody Map<String, String> params, HttpServletRequest request) {
        Integer taskId;
        try {
            taskId = Integer.valueOf(params.get("taskId"));
        }
        catch (NumberFormatException e) {
            return new CodeResult(CodeResult.Code.Failed, MessageSource.getMsg("params_error"));
        }
        User user = (User)request.getAttribute("user");
        AlarmWatchInfoBean task = this.alarmContactorService.getWatchInfo(user.getId(), taskId.intValue());
        if (task == null) {
            return CodeResult.failedResultByMsgSource("task_not_exist");
        }
        if (this.alarmContactorService.deleteWatchTask(user.getId(), taskId)) {
            return new CodeResult(CodeResult.Code.Success);
        }
        return new CodeResult(CodeResult.Code.Failed);
    }

    @RequestMapping(value={"/setWatchTaskStatus"}, method={RequestMethod.POST})
    public Object setWatchTaskStatus(@RequestBody Map<String, String> params, HttpServletRequest request) {
        AlarmWatchInfoBean.Status status;
        Integer taskId;
        try {
            taskId = Integer.valueOf(params.get("taskId"));
            status = AlarmWatchInfoBean.Status.valueOfInt(Integer.valueOf(params.get("status")));
        }
        catch (NumberFormatException e) {
            return new CodeResult(CodeResult.Code.Failed, MessageSource.getMsg("params_error"));
        }
        User user = (User)request.getAttribute("user");
        AlarmWatchInfoBean task = this.alarmContactorService.getWatchInfo(user.getId(), taskId.intValue());
        if (task == null) {
            return CodeResult.failedResultByMsgSource("task_not_exist");
        }
        if (this.alarmContactorService.setWatchTaskStatus(user.getId(), taskId, status)) {
            return new CodeResult(CodeResult.Code.Success);
        }
        return new CodeResult(CodeResult.Code.Failed);
    }
}

