/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.controller.dp;

import com.chinamcloud.bigdata.haiheservice.CodeResult;
import com.chinamcloud.bigdata.haiheservice.bean.FacetResult;
import com.chinamcloud.bigdata.haiheservice.bean.SiteConfig;
import com.chinamcloud.bigdata.haiheservice.bean.SiteStatistic;
import com.chinamcloud.bigdata.haiheservice.bean.User;
import com.chinamcloud.bigdata.haiheservice.pojo.DirectSiteNewsParams;
import com.chinamcloud.bigdata.haiheservice.pojo.HotNewsDetailParams;
import com.chinamcloud.bigdata.haiheservice.pojo.HotParams;
import com.chinamcloud.bigdata.haiheservice.service.SiteStatisticService;
import com.chinamcloud.bigdata.haiheservice.service.UserService;
import com.chinamcloud.bigdata.haiheservice.util.ContainsUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/dp/directSite"})
public class DpDirectSiteController {
    private static final Integer product = 53691;
    private static Logger logger = LogManager.getLogger(DpDirectSiteController.class);
    @Autowired
    private SiteStatisticService service;
    @Autowired
    private UserService userService;

    @RequestMapping(value={"/getCatStatus"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object getCatStatus(HttpServletRequest request) {
        User user = (User)request.getAttribute("user");
        SiteConfig status = null;
        try {
            status = this.service.findSiteStatus(user.getId());
        }
        catch (Exception e) {
            logger.error((Object)e);
            return CodeResult.failedResultByMsgSource("server_error");
        }
        return CodeResult.successResult(null, status);
    }

    @RequestMapping(value={"/getCatCount"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object getCatCount(HttpServletRequest request) {
        User user = (User)request.getAttribute("user");
        List<User> users = this.userService.getUserInfoByGroupId(user.getGroupId());
        StringBuffer userIds = new StringBuffer(user.getId() + ",");
        for (User u : users) {
            if (u.getId().equals(user.getId())) continue;
            userIds.append(u.getId() + ",");
        }
        List<FacetResult> result = null;
        try {
            result = this.service.findSiteCount(userIds.substring(0, userIds.length() - 1));
        }
        catch (Exception e) {
            logger.error((Object)e);
            return CodeResult.failedResultByMsgSource("server_error");
        }
        return CodeResult.successResult(null, result);
    }

    @RequestMapping(value={"/getSitesByCatId"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object getSitesByCatId(@RequestBody Map<String, String> values, HttpServletRequest request) {
        int intId;
        String id = values.get("catId");
        String split = values.get("split");
        if (StringUtils.isEmpty((CharSequence)id) && StringUtils.isEmpty((CharSequence)split)) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        try {
            intId = Integer.valueOf(id);
        }
        catch (Exception e) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        User user = (User)request.getAttribute("user");
        Map<String, List<SiteStatistic>> result = null;
        List<User> users = this.userService.getUserInfoByGroupId(user.getGroupId());
        StringBuffer userIds = new StringBuffer(user.getId() + ",");
        if (users != null) {
            for (User u : users) {
                if (u.getId().equals(user.getId())) continue;
                userIds.append(u.getId() + ",");
            }
        }
        try {
            result = this.service.findSitesWithConfig(userIds.substring(0, userIds.length() - 1), intId, split);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return CodeResult.failedResultByMsgSource("server_error");
        }
        return CodeResult.successResult(null, result);
    }

    @RequestMapping(value={"/saveSiteConfig"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object saveSiteConfig(@RequestBody @Validated SiteConfig config, BindingResult bindingResult, HttpServletRequest request) {
        if (bindingResult.hasErrors()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        User user = (User)request.getAttribute("user");
        try {
            boolean result = this.service.saveSiteConfig(user.getId(), config);
            if (!result) {
                return CodeResult.failedResultByMsgSource("params_error");
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            return CodeResult.failedResultByMsgSource("server_error");
        }
        return CodeResult.successResult();
    }

    @RequestMapping(value={"/news"})
    public Object hotNews(@RequestBody @Validated DirectSiteNewsParams params, BindingResult result, HttpServletRequest request) {
        if (result.hasErrors()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        User user = (User)request.getAttribute("user");
        List<User> users = this.userService.getUserInfoByGroupId(user.getGroupId());
        StringBuffer userIds = new StringBuffer(user.getId() + ",");
        for (User u : users) {
            if (u.getId().equals(user.getId())) continue;
            userIds.append(u.getId() + ",");
        }
        String catId = params.getCatId();
        List<String> sourceIds = params.getSourceIds();
        if (sourceIds == null || sourceIds.size() == 0) {
            List<SiteStatistic> siteStatistics;
            try {
                siteStatistics = StringUtils.isEmpty((CharSequence)catId) ? this.service.findStatisticListByUserIds(userIds.substring(0, userIds.length() - 1)) : this.service.findStatisticList(userIds.substring(0, userIds.length() - 1), (int)Integer.valueOf(catId));
            }
            catch (NumberFormatException e) {
                return CodeResult.failedResultByMsgSource("params_error");
            }
            if (siteStatistics.size() == 0) {
                return CodeResult.successResult(null, Collections.emptyList());
            }
            Map<String, Integer> values = siteStatistics.stream().collect(Collectors.toMap(x -> String.valueOf(x.getSourceId()), x -> x.getSourceType()));
            params.setSourceIds(new ArrayList<String>(values.keySet()));
            ModelAndView view = new ModelAndView("/es/basic/hotNews.do");
            view.addObject("cache", (Object)true);
            view.addObject("params", (Object)params);
            return view;
        }
        List<SiteStatistic> siteStatistics = this.service.findStatisticListByUserIds(userIds.substring(0, userIds.length() - 1));
        Map<String, Integer> values = siteStatistics.stream().collect(Collectors.toMap(x -> String.valueOf(x.getSourceId()), x -> x.getSourceType()));
        if (!ContainsUtils.isSubset(values.keySet(), sourceIds)) {
            return CodeResult.failedResultByMsgSource("site_not_sub");
        }
        params.setSourceIds(sourceIds);
        ModelAndView view = new ModelAndView("/es/basic/hotNews.do");
        view.addObject("params", (Object)params);
        view.addObject("cache", (Object)true);
        return view;
    }

    @RequestMapping(value={"/getSenSourceFacet"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object getSenSource(@RequestBody Map<String, String> values, BindingResult bindResult, HttpServletRequest request) {
        List result;
        int intId;
        String id = values.get("catId");
        if (StringUtils.isEmpty((CharSequence)id)) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        try {
            intId = Integer.valueOf(id);
        }
        catch (Exception e) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        User user = (User)request.getAttribute("user");
        try {
            List<SiteStatistic> list = this.service.findStatisticList(user.getId(), intId);
            result = list.stream().map(x -> x.getName().trim()).collect(Collectors.toList());
        }
        catch (Exception e) {
            logger.error((Object)e);
            return CodeResult.failedResultByMsgSource("server_error");
        }
        return CodeResult.successResult(null, result);
    }

    @RequestMapping(value={"/newsDetail"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object newsDetail(@RequestBody @Validated HotNewsDetailParams params, BindingResult bindResult, HttpServletRequest request) {
        if (bindResult.hasErrors()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        User user = (User)request.getAttribute("user");
        HotParams hotParams = new HotParams();
        try {
            hotParams.setId(params.getDocId());
        }
        catch (Exception e) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        hotParams.setProduceIds(Arrays.asList(product));
        ModelAndView view = new ModelAndView("/es/basic/newsDetail.do");
        view.addObject("params", (Object)hotParams);
        view.addObject("user", (Object)user);
        return view;
    }
}

