/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.dao;

import com.chinamcloud.bigdata.haiheservice.bean.ChargeAnalysisStatistic;
import com.chinamcloud.bigdata.haiheservice.bean.ChargeNewsStatistic;
import com.chinamcloud.bigdata.haiheservice.bean.ChargeTopicSubStatistic;
import com.chinamcloud.bigdata.haiheservice.bean.Trend;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class ChargeStatisticDao {
    @Autowired
    private JdbcTemplate jdbcTemplate;

    public ChargeTopicSubStatistic getTopicStatistic(long userId) {
        List statistics = this.jdbcTemplate.query("SELECT (SELECT COUNT(id) FROM `t_user_topic` LEFT JOIN `t_topic` ON `t_user_topic`.`topicId`=t_topic.`id` WHERE `t_user_topic`.`userId`=? AND `t_topic`.type =1) AS region,(SELECT COUNT(id) FROM `t_user_topic` LEFT JOIN `t_topic` ON `t_user_topic`.`topicId`=t_topic.`id` WHERE `t_user_topic`.`userId`=? AND `t_topic`.type =4) AS user_define", new Object[]{userId, userId}, (RowMapper)new RowMapper<ChargeTopicSubStatistic>(){

            public ChargeTopicSubStatistic mapRow(ResultSet arg0, int arg1) throws SQLException {
                ChargeTopicSubStatistic statistic = new ChargeTopicSubStatistic();
                statistic.setMediaCat(0L);
                statistic.setMonitorSite(0L);
                statistic.setRegion(arg0.getLong("region"));
                statistic.setUserDefine(arg0.getLong("user_define"));
                return statistic;
            }
        });
        return statistics.size() > 0 ? (ChargeTopicSubStatistic)statistics.get(0) : null;
    }

    public ChargeAnalysisStatistic getAnalysisStatistic(long userId) {
        List statistics = this.jdbcTemplate.query("SELECT (SELECT COUNT(id) FROM `t_analysis_req` WHERE `ownerId`=? AND `type`=1) AS weiboAnalysis,(SELECT COUNT(id) FROM `t_analysis_req` WHERE `ownerId`=? AND `type`=0) AS ycAnalysis", new Object[]{userId, userId}, (RowMapper)new RowMapper<ChargeAnalysisStatistic>(){

            public ChargeAnalysisStatistic mapRow(ResultSet arg0, int arg1) throws SQLException {
                ChargeAnalysisStatistic chargeAnalysisStatistic = new ChargeAnalysisStatistic();
                chargeAnalysisStatistic.setWeiboAnalysis(arg0.getLong("weiboAnalysis"));
                chargeAnalysisStatistic.setYcAnalysis(arg0.getLong("ycAnalysis"));
                return chargeAnalysisStatistic;
            }
        });
        return statistics.size() > 0 ? (ChargeAnalysisStatistic)statistics.get(0) : null;
    }

    public List<Trend> getDataStatistic(Long ownerId, Date fromDt, Date toDt, int statisticType) {
        String sql = "";
        if (statisticType == 1) {
            sql = "select DATE_FORMAT(actionTime,'%Y-%m-%d 00:00:00') time, count(1) count from t_article_action WHERE actionTime>=? and actionTime<=? and ownerId=? group by time";
        } else if (statisticType == 0) {
            sql = "select DATE_FORMAT(actionTime,'%Y-%m-%d %H:00:00') time, count(1) count from t_article_action WHERE actionTime>=? and actionTime<=? and ownerId=? group by time";
        }
        return this.jdbcTemplate.query(sql, new Object[]{new Timestamp(fromDt.getTime()), new Timestamp(toDt.getTime()), ownerId}, (RowMapper)new RowMapper<Trend>(){

            public Trend mapRow(ResultSet rs, int arg1) throws SQLException {
                Trend trend = new Trend();
                Timestamp timestamp = rs.getTimestamp("time");
                long time = timestamp.getTime();
                long count = rs.getLong("count");
                trend.setTime(time);
                trend.setValue(count);
                return trend;
            }
        });
    }

    public void saveNewsStatistic(final List<ChargeNewsStatistic> results) {
        String sql = "INSERT INTO `t_charge_news`(`ownerId`,`subStartTime`,`subEndTime`,`value`,`type`) VALUES(?,?,?,?,?)";
        this.jdbcTemplate.batchUpdate(sql, new BatchPreparedStatementSetter(){

            public void setValues(PreparedStatement ps, int i) throws SQLException {
                ChargeNewsStatistic result = (ChargeNewsStatistic)results.get(i);
                ps.setInt(1, (int)result.getOwnerId());
                ps.setTimestamp(2, new Timestamp(result.getSubStartTime().getTime()));
                ps.setTimestamp(3, new Timestamp(result.getSubEndTime().getTime()));
                ps.setLong(4, result.getValue());
                ps.setString(5, result.getType());
            }

            public int getBatchSize() {
                return results.size();
            }
        });
    }

    public List<Trend> getNewsStatistic(Long ownerId, Date fromDt, Date toDt, int statisticType) {
        String sql = "";
        if (statisticType == 1) {
            sql = "select DATE_FORMAT(subStartTime,'%Y-%m-%d 00:00:00') time, sum(`value`) count from t_charge_news WHERE subStartTime>=? and subStartTime<=? and ownerId=? group by time";
        } else if (statisticType == 0) {
            sql = "select DATE_FORMAT(subStartTime,'%Y-%m-%d %H:00:00') time, sum(`value`) count from t_charge_news WHERE subStartTime>=? and subStartTime<=? and ownerId=? group by time";
        }
        return this.jdbcTemplate.query(sql, new Object[]{new Timestamp(fromDt.getTime()), new Timestamp(toDt.getTime()), ownerId}, (RowMapper)new RowMapper<Trend>(){

            public Trend mapRow(ResultSet rs, int arg1) throws SQLException {
                Trend trend = new Trend();
                Timestamp timestamp = rs.getTimestamp("time");
                long time = timestamp.getTime();
                long count = rs.getLong("count");
                trend.setTime(time);
                trend.setValue(count);
                return trend;
            }
        });
    }
}

