/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.dao;

import com.chinamcloud.bigdata.haiheservice.bean.CustomCloumnBean;
import com.chinamcloud.bigdata.haiheservice.bean.FacetResult;
import com.chinamcloud.bigdata.haiheservice.bean.SiteConfig;
import com.chinamcloud.bigdata.haiheservice.bean.SiteStatistic;
import com.chinamcloud.bigdata.haiheservice.db.mapper.SiteStatisticMapper;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class SiteStatisticDao {
    @Autowired
    private JdbcTemplate jdbcTemplate;

    public List<SiteStatistic> findSitesByUserId(Long userId) {
        return this.jdbcTemplate.query("SELECT `sourceType`,`comment`,`total`,`todayTotal`,`sourceId` FROM `t_user_crawler` WHERE `userId`=?", new Object[]{userId}, (RowMapper)new SiteStatisticMapper());
    }

    public List<SiteStatistic> findStatisticListByUserIds(Long ... userIds) {
        if (userIds.length == 0) {
            return this.jdbcTemplate.query("SELECT  sourceId,`sourceType`,`comment`,`total`,`todayTotal` FROM `t_user_crawler`  GROUP BY `sourceId`", (RowMapper)new SiteStatisticMapper());
        }
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate((JdbcOperations)this.jdbcTemplate);
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("userIds", Arrays.asList(userIds));
        return namedParameterJdbcTemplate.query("SELECT  sourceId,`sourceType`,`comment`,`total`,`todayTotal` FROM `t_user_crawler`  WHERE `userId` in(:userIds) GROUP BY `sourceId`", (SqlParameterSource)parameters, (RowMapper)new SiteStatisticMapper());
    }

    public List<SiteStatistic> findStatisticList(Long userId, Integer catId) {
        return this.jdbcTemplate.query("SELECT `sourceType`,`comment`,`total`,`todayTotal`,`sourceId` FROM `t_user_crawler` WHERE `userId`=? and `sourceType`=?", new Object[]{userId, catId}, (RowMapper)new SiteStatisticMapper());
    }

    public List<SiteStatistic> findStatisticList(String userIds, Integer catId) {
        return this.jdbcTemplate.query("SELECT `sourceType`,`comment`,`total`,`todayTotal`,`sourceId` FROM `t_user_crawler` WHERE `userId` in (" + userIds + ") and `sourceType`=? group by sourceId", new Object[]{catId}, (RowMapper)new SiteStatisticMapper());
    }

    public boolean updateStatistic(SiteStatistic siteStatistic) {
        return this.jdbcTemplate.update("UPDATE `t_user_crawler` SET `total`=?,`todayTotal`=? WHERE `sourceId`=?", new Object[]{siteStatistic.getTotal(), siteStatistic.getTodayTotal(), siteStatistic.getSourceId()}) > 0;
    }

    public boolean updateStatistic(List<SiteStatistic> siteStatistics) {
        ArrayList<Object[]> batchArgs = new ArrayList<Object[]>();
        String sql = "UPDATE `t_user_crawler` SET `total`=?,`todayTotal`=? WHERE `sourceId`=?";
        for (SiteStatistic bean : siteStatistics) {
            batchArgs.add(new Object[]{bean.getTotal(), bean.getTodayTotal(), bean.getSourceId()});
        }
        int[] batchUpdate = this.jdbcTemplate.batchUpdate(sql, batchArgs);
        return batchUpdate.length > 0;
    }

    public List<SiteStatistic> findSourceIdListByUserId(String provinceId) {
        return this.jdbcTemplate.query("SELECT `sourceId`,`comment` FROM `t_user_sourceid` WHERE `provinceId`= ?", new Object[]{provinceId}, (RowMapper)new RowMapper<SiteStatistic>(){

            public SiteStatistic mapRow(ResultSet rs, int rowNum) throws SQLException {
                SiteStatistic bean = new SiteStatistic();
                bean.setName(rs.getString("comment"));
                bean.setSourceId(rs.getInt("sourceId"));
                return bean;
            }
        });
    }

    public SiteConfig findSiteStatus(long userId) {
        List list = this.jdbcTemplate.query("SELECT * FROM `t_user_crawler_config` WHERE `userId`=?", new Object[]{userId}, (RowMapper)new RowMapper<SiteConfig>(){

            public SiteConfig mapRow(ResultSet rs, int rowNum) throws SQLException {
                SiteConfig conf = new SiteConfig();
                conf.setWangzhanVisible(rs.getString("wangzhanVisible"));
                conf.setWeiboVisible(rs.getString("weiboVisible"));
                conf.setWeixinVisible(rs.getString("weixinVisible"));
                return conf;
            }
        });
        return list.size() > 0 ? (SiteConfig)list.get(0) : null;
    }

    public Map<Long, SiteConfig> findSiteStatus(String userIds) {
        List list = this.jdbcTemplate.query("SELECT * FROM `t_user_crawler_config` WHERE `userId` in (" + userIds + ") group by userId", new Object[0], (RowMapper)new RowMapper<Map<Long, SiteConfig>>(){

            public Map<Long, SiteConfig> mapRow(ResultSet rs, int rowNum) throws SQLException {
                HashMap<Long, SiteConfig> map = new HashMap<Long, SiteConfig>();
                SiteConfig conf = new SiteConfig();
                conf.setWangzhanVisible(rs.getString("wangzhanVisible"));
                conf.setWeiboVisible(rs.getString("weiboVisible"));
                conf.setWeixinVisible(rs.getString("weixinVisible"));
                map.put(rs.getLong("userId"), conf);
                return map;
            }
        });
        HashMap<Long, SiteConfig> map = new HashMap<Long, SiteConfig>();
        for (Map configMap : list) {
            map.putAll(configMap);
        }
        return map;
    }

    public List<FacetResult> findSiteCount(long userId) {
        List list = this.jdbcTemplate.query("SELECT sourceType, count(*) as value from t_user_crawler WHERE userId = ? GROUP BY sourceType", new Object[]{userId}, (RowMapper)new RowMapper<FacetResult>(){

            public FacetResult mapRow(ResultSet rs, int rowNum) throws SQLException {
                FacetResult bean = new FacetResult();
                bean.setName(rs.getString("sourceType"));
                bean.setValue(rs.getLong("value"));
                return bean;
            }
        });
        return list;
    }

    public Map<Long, List<FacetResult>> findSiteCount(String userIds) {
        List list = this.jdbcTemplate.query("SELECT sourceType, count(*) as value,userId as negative from (select * from t_user_crawler WHERE userId in (" + userIds + ") GROUP BY sourceId)tb GROUP BY sourceType,userId", new Object[0], (RowMapper)new RowMapper<FacetResult>(){

            public FacetResult mapRow(ResultSet rs, int rowNum) throws SQLException {
                FacetResult bean = new FacetResult();
                bean.setName(rs.getString("sourceType"));
                bean.setValue(rs.getLong("value"));
                bean.setNegative(rs.getLong("negative"));
                return bean;
            }
        });
        HashMap<Long, List<FacetResult>> map = new HashMap<Long, List<FacetResult>>();
        for (final FacetResult facetResult : list) {
            List<FacetResult> facetResults = map.get(facetResult.getNegative());
            if (facetResults == null) {
                map.put(facetResult.getNegative(), (List<FacetResult>)new ArrayList<FacetResult>(){
                    {
                        this.add(facetResult);
                    }
                });
                continue;
            }
            if (facetResults.contains(facetResult)) continue;
            facetResults.add(facetResult);
        }
        return map;
    }

    public SiteConfig findSiteConfig(long userId) {
        List list = this.jdbcTemplate.query("SELECT * FROM `t_user_crawler_config` WHERE `userId`=?", new Object[]{userId}, (RowMapper)new RowMapper<SiteConfig>(){

            public SiteConfig mapRow(ResultSet rs, int rowNum) throws SQLException {
                SiteConfig conf = new SiteConfig();
                conf.setWangzhanVisible(rs.getString("wangzhanVisible"));
                conf.setWangzhanSourcesIds(rs.getString("wangzhanSourcesIds"));
                conf.setWeiboVisible(rs.getString("weiboVisible"));
                conf.setWeiboSourcesIds(rs.getString("weiboSourcesIds"));
                conf.setWeixinVisible(rs.getString("weixinVisible"));
                conf.setWeixinSourcesIds(rs.getString("weixinSourcesIds"));
                return conf;
            }
        });
        return list.size() > 0 ? (SiteConfig)list.get(0) : null;
    }

    public Map<Long, SiteConfig> findSiteConfig(String userIds) {
        List list = this.jdbcTemplate.query("SELECT * FROM `t_user_crawler_config` WHERE `userId` in (" + userIds + ")", new Object[0], (RowMapper)new RowMapper<Map<Long, SiteConfig>>(){

            public Map<Long, SiteConfig> mapRow(ResultSet rs, int rowNum) throws SQLException {
                HashMap<Long, SiteConfig> map = new HashMap<Long, SiteConfig>();
                SiteConfig conf = new SiteConfig();
                conf.setWangzhanVisible(rs.getString("wangzhanVisible"));
                conf.setWangzhanSourcesIds(rs.getString("wangzhanSourcesIds"));
                conf.setWeiboVisible(rs.getString("weiboVisible"));
                conf.setWeiboSourcesIds(rs.getString("weiboSourcesIds"));
                conf.setWeixinVisible(rs.getString("weixinVisible"));
                conf.setWeixinSourcesIds(rs.getString("weixinSourcesIds"));
                map.put(rs.getLong("userId"), conf);
                return map;
            }
        });
        HashMap<Long, SiteConfig> map = new HashMap<Long, SiteConfig>();
        for (Map configMap : list) {
            map.putAll(configMap);
        }
        return map;
    }

    public List<SiteStatistic> findStatisticListBySourceIds(long userId, String[] sourceIds) {
        if (sourceIds.length == 0) {
            return this.jdbcTemplate.query("SELECT  sourceId,`sourceType`,`comment`,`total`,`todayTotal` FROM `t_user_crawler` WHERE `userId` = ?", new Object[]{userId}, (RowMapper)new SiteStatisticMapper());
        }
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate((JdbcOperations)this.jdbcTemplate);
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("userId", (Object)userId);
        parameters.addValue("sourceIds", Arrays.asList(sourceIds));
        return namedParameterJdbcTemplate.query("SELECT sourceId,`sourceType`,`comment`,`total`,`todayTotal` FROM `t_user_crawler`  WHERE `userId` = :userId and sourceId in(:sourceIds)", (SqlParameterSource)parameters, (RowMapper)new SiteStatisticMapper());
    }

    public boolean saveSiteConfig(SiteConfig conf, long userId) {
        int num = this.jdbcTemplate.update("REPLACE INTO `t_user_crawler_config` (`userId`, `wangzhanVisible`, `weiboVisible`, `weixinVisible`, `wangzhanSourcesIds`, `weiboSourcesIds`, `weixinSourcesIds`) VALUES (?, ?, ?, ?, ?, ?, ?)", new Object[]{userId, conf.getWangzhanVisible(), conf.getWeiboVisible(), conf.getWeixinVisible(), conf.getWangzhanSourcesIds(), conf.getWeiboSourcesIds(), conf.getWeixinSourcesIds()});
        return true;
    }

    public List<CustomCloumnBean> getColumnsByCatId(String userIds, int catId) {
        return this.jdbcTemplate.query("SELECT `id`, `columnName` FROM `t_user_crawler_custom_config` WHERE `userId` in (" + userIds + ") and `sourceType`=?", new Object[]{catId}, (RowMapper)new RowMapper<CustomCloumnBean>(){

            public CustomCloumnBean mapRow(ResultSet rs, int rowNum) throws SQLException {
                CustomCloumnBean bean = new CustomCloumnBean();
                bean.setId(rs.getString("id"));
                bean.setName(rs.getString("columnName"));
                return bean;
            }
        });
    }

    public List<String> getSitesByColumns(String userIds, int catId, String column) {
        return this.jdbcTemplate.query("SELECT `sourceIds` FROM `t_user_crawler_custom_config` WHERE `userId` in (" + userIds + ") and `sourceType`=? and `columnName`=?", new Object[]{catId, column}, (RowMapper)new RowMapper<String>(){

            public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                return rs.getString("sourceIds");
            }
        });
    }

    public boolean saveColumn(Long userId, int catId, String column, String sourceIds) {
        int num = this.jdbcTemplate.update("INSERT INTO `t_user_crawler_custom_config` (`userId`, `columnName`, `sourceIds`, `sourceType`) VALUES (?,?,?,?)", new Object[]{userId, column, sourceIds, catId});
        return num >= 1;
    }

    public boolean existCloumn(String groupId, String cloumnId) {
        List list = this.jdbcTemplate.query("select id,columnName from `t_user_crawler_custom_config` where userId in (select userId from t_user where groupId = ?) and id = ?", new Object[]{groupId, cloumnId}, (RowMapper)new RowMapper<CustomCloumnBean>(){

            public CustomCloumnBean mapRow(ResultSet rs, int rowNum) throws SQLException {
                CustomCloumnBean bean = new CustomCloumnBean();
                bean.setId(rs.getString("id"));
                bean.setName(rs.getString("columnName"));
                return bean;
            }
        });
        return list.size() > 0;
    }

    public boolean updateColumn(Long userId, String column, String sourceIds, String cloumnId) {
        int num = this.jdbcTemplate.update("update `t_user_crawler_custom_config` set `columnName`=? ,`sourceIds`=? where `id`=?", new Object[]{column, sourceIds, cloumnId});
        return num >= 1;
    }

    public boolean deleteColumn(Long userId, String columnId) {
        int num = this.jdbcTemplate.update("delete from t_user_crawler_custom_config where `id`=?", new Object[]{columnId});
        return true;
    }
}

