/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.es.result;

import com.chinamcloud.bigdata.haiheservice.es.EsFeedbackQuery;
import com.chinamcloud.bigdata.haiheservice.es.bean.EsApsFacetField;
import com.chinamcloud.bigdata.haiheservice.es.result.EsFacetResult;
import com.chinamcloud.bigdata.haiheservice.es.result.EsResultProcessor;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.search.aggregations.metrics.sum.Sum;
import org.springframework.util.ObjectUtils;

public class EsHistogramResultProcessor
implements EsResultProcessor<EsFeedbackQuery, SearchResponse> {
    public EsFacetResult<List<EsApsFacetField>> processResult(EsFeedbackQuery query, SearchResponse response) {
        String name = query.getFacetField();
        EsFacetResult<List<EsApsFacetField>> facetResult = null;
        try {
            ArrayList<EsApsFacetField> list = new ArrayList<EsApsFacetField>();
            Aggregations aggregations = response.getAggregations();
            Histogram agg = (Histogram)aggregations.get("agg");
            EsApsFacetField apsFacetField = new EsApsFacetField();
            ArrayList<String> values = new ArrayList<String>();
            ArrayList<Long> counts = new ArrayList<Long>();
            ArrayList<Long> metrics = new ArrayList<Long>();
            for (Histogram.Bucket entry : agg.getBuckets()) {
                Object key = entry.getKey();
                String keyAsString = entry.getKeyAsString();
                long docCount = entry.getDocCount();
                if (ObjectUtils.isEmpty((Object)key)) continue;
                values.add(keyAsString);
                counts.add(docCount);
                Sum sum = (Sum)entry.getAggregations().get("revenue");
                double result = sum.getValue();
                metrics.add((long)result);
            }
            apsFacetField.setName(name);
            apsFacetField.setValues(values);
            apsFacetField.setCounts(counts);
            apsFacetField.setMetrics(metrics);
            list.add(apsFacetField);
            facetResult = new EsFacetResult(list, (Boolean)true);
        }
        catch (Exception e) {
            facetResult = new EsFacetResult<List<EsApsFacetField>>(e.getMessage(), (Boolean)false);
        }
        return facetResult;
    }
}

