/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.parser;

import com.alibaba.fastjson.JSONObject;
import com.chinamcloud.bigdata.haiheservice.bean.Quota;
import com.chinamcloud.bigdata.haiheservice.bean.User;
import com.chinamcloud.bigdata.haiheservice.util.JSONUtils;

public class UserInfoDataParser {
    public User parseRecords(String result) {
        JSONObject jsonObject = JSONUtils.getJSONObject(result);
        String code = String.valueOf(jsonObject.get((Object)"code"));
        if (code.equals("10000")) {
            JSONObject dataObject = JSONUtils.getJSONObject("data", jsonObject);
            JSONObject groupObject = JSONUtils.getJSONObject("group_info", dataObject);
            JSONObject userObject = JSONUtils.getJSONObject("user_info", dataObject);
            JSONObject quotaObject = JSONUtils.getJSONObject("service_info", dataObject);
            User user = new User();
            user.setGroupId(groupObject.getString("group_id"));
            user.setGroupCode(groupObject.getString("group_code"));
            user.setGroupName(groupObject.getString("group_name"));
            user.setGroupIsOpen(groupObject.getString("is_open"));
            user.setGroupAddTime(groupObject.getString("add_time"));
            user.setLoginName(userObject.getString("login_name"));
            user.setUserToken(userObject.getString("user_token"));
            user.setUserNick(userObject.getString("user_nick"));
            user.setUserMobile(null);
            user.setUserEmail(userObject.getString("user_email"));
            user.setUserType(userObject.getString("user_type"));
            user.setUserIsOpen(userObject.getString("is_open"));
            user.setUserAddTime(userObject.getString("add_time"));
            if (quotaObject != null) {
                user.setForwardQuato(this.parseQuota(quotaObject.getJSONObject("forward")));
                user.setAreaQuato(this.parseQuota(quotaObject.getJSONObject("area")));
                user.setKeywordQuato(this.parseQuota(quotaObject.getJSONObject("keyword")));
                user.setTopicQuato(this.parseQuota(quotaObject.getJSONObject("topic")));
            }
            return user;
        }
        return null;
    }

    private Quota parseQuota(JSONObject quotaObject) {
        if (quotaObject == null) {
            return null;
        }
        Quota quota = new Quota();
        quota.setItem_id(quotaObject.getString("item_id"));
        quota.setItem_code(quotaObject.getString("item_code"));
        quota.setItem_code(quotaObject.getString("forward"));
        quota.setQota(quotaObject.getString("qota"));
        quota.setPeriod_value(quotaObject.getString("period_value"));
        quota.setQota_type(quotaObject.getString("qota_type"));
        quota.setPeriod_value_type(quotaObject.getString("period_value_type"));
        quota.setMode(quotaObject.getString("mode"));
        quota.setPeriod_value(quotaObject.getString("period_value"));
        quota.setPeriod_value_time(quotaObject.getString("period_value_time"));
        quota.setTotal_qota(quotaObject.getString("total_qota"));
        quota.setUse_qota(quotaObject.getString("use_qota"));
        quota.setRest_qota(quotaObject.getString("rest_qota"));
        quota.setOther_qota(quotaObject.getString("other_qota"));
        quota.setOther_qota_use(quotaObject.getString("other_qota_use"));
        return quota;
    }
}

