/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.service;

import com.chinamcloud.bigdata.haiheservice.cache.CacheUtil;
import com.chinamcloud.bigdata.haiheservice.dao.AreaDao;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AreaService {
    private static Logger logger = LogManager.getLogger(AreaService.class);
    @Autowired
    private AreaDao areaDao;

    public List<Map> getProvince() {
        return this.areaDao.getProvince();
    }

    public List<Map> getCityByProvince(Map<String, String> params) {
        String code = params.get("code");
        if (StringUtils.isNotBlank((CharSequence)code)) {
            if (Integer.valueOf(code) % 100 != 0) {
                return null;
            }
            return this.areaDao.getCityByProvince(Integer.valueOf(code));
        }
        String name = params.get("name");
        Map<String, String> map = this.areaDao.getAreaByProvinceName(name);
        String mapCode = map.get("code");
        if (StringUtils.isBlank((CharSequence)mapCode)) {
            logger.info("Null by name query\uff01");
            return null;
        }
        return this.areaDao.getCityByProvince(Integer.valueOf(mapCode));
    }

    public List<Map> getCountyByCity(Map<String, String> params) {
        String code = params.get("code");
        if (StringUtils.isNotBlank((CharSequence)code)) {
            return this.areaDao.getCountyByCity(Integer.valueOf(code));
        }
        String name = params.get("name");
        Map<String, String> map = this.areaDao.getAreaByProvinceName(name);
        if (null == map) {
            return new ArrayList<Map>();
        }
        String mapCode = map.get("code");
        if (StringUtils.isBlank((CharSequence)mapCode)) {
            logger.info("Null by name query\uff01");
            return null;
        }
        return this.areaDao.getCountyByCity(Integer.valueOf(mapCode));
    }

    public Map<String, String> getPositional(Map<String, String> params) {
        Object object = CacheUtil.Ctable(params, "redisCacheManager", "getPositional");
        if (object != null) {
            return (Map)object;
        }
        Map<String, String> map = null;
        String code = params.get("code");
        if (StringUtils.isNotBlank((CharSequence)code)) {
            if (Integer.valueOf(code) % 100 != 0) {
                return null;
            }
            map = this.areaDao.getPositional("code", code);
        } else {
            String name = params.get("name");
            map = this.areaDao.getPositional("name", name);
        }
        if (map != null && !map.isEmpty()) {
            CacheUtil.Cput(params, "redisCacheManager", "getPositional", map);
        }
        return map;
    }
}

