/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.util;

import com.chinamcloud.bigdata.haiheservice.util.StringUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.time.FastDateFormat;

public class DateUtils {
    public static Date[] computeDatesBackward(Date endDate, int day, boolean fill24Hour) {
        if (endDate == null) {
            endDate = new Date();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(endDate);
        if (fill24Hour) {
            calendar.set(6, calendar.get(6) + 1);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
        }
        Date newEndDate = calendar.getTime();
        calendar.set(6, calendar.get(6) - day);
        Date newStartDate = calendar.getTime();
        return new Date[]{newStartDate, newEndDate};
    }

    public static Date[] computeDatesBackward(int day, boolean fill24Hour) {
        return DateUtils.computeDatesBackward(null, day, fill24Hour);
    }

    public static Date[] computeDatesBackward(int day) {
        return DateUtils.computeDatesBackward(null, day, true);
    }

    public static boolean isDateAfter(Date beforeDate, Date afterDate) {
        if (beforeDate != null && afterDate != null) {
            return !beforeDate.after(afterDate);
        }
        return true;
    }

    public static String[] computeDays2Now(Date date, int timeInterval) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String[] time = new String[2];
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        time[1] = dateFormat.format(calendar.getTime());
        calendar.add(5, timeInterval);
        time[0] = dateFormat.format(calendar.getTime());
        return time;
    }

    public static String[] compute7daysTime() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        int index = 7;
        String[] time = new String[index];
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(6, -index);
        for (int i = 0; i < index; ++i) {
            calendar.add(6, 1);
            time[i] = dateFormat.format(calendar.getTime()) + " 00:00:00";
        }
        return time;
    }

    public static String[] compute24HoursTime() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH");
        int index = 24;
        String[] time = new String[index];
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(6, -1);
        calendar.add(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        for (int i = 0; i < index; ++i) {
            calendar.add(11, 1);
            time[i] = dateFormat.format(calendar.getTime());
        }
        return time;
    }

    public static Date[] computeDay24HoursTime(int day) {
        int index = 24;
        Date[] time = new Date[index];
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(6, day);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        System.out.println(FastDateFormat.getInstance((String)"yyyy-MM-dd HH:ss:mm").format(calendar));
        for (int i = 0; i < index; ++i) {
            time[i] = calendar.getTime();
            calendar.add(11, 1);
        }
        return time;
    }

    public static Date computeTimePoint(Date time, int interval, String mode) {
        Calendar calendar = Calendar.getInstance();
        if (time == null) {
            time = new Date();
        }
        calendar.setTime(time);
        switch (mode) {
            case "day": {
                calendar.add(6, interval);
                break;
            }
            case "hour": {
                calendar.add(11, interval);
                break;
            }
        }
        return calendar.getTime();
    }

    public static Date minDate(Date date1, Date date2) {
        int value = date1.compareTo(date2);
        if (value <= 0) {
            return date1;
        }
        return date2;
    }

    public static Date string2date(String date) {
        if (StringUtils.isEmpty(date)) {
            return null;
        }
        try {
            return FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss").parse(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int computeTimeinterval(String fromDt, String toDt) {
        Date from = DateUtils.string2date(fromDt);
        Date to = DateUtils.string2date(toDt);
        if (from == null || to == null) {
            return -1;
        }
        return (int)(to.getTime() - from.getTime()) / 3600000;
    }

    public static void main(String[] args) {
        Date fromDt = new Date();
        Date toDt = DateUtils.computeTimePoint(fromDt, 1, "hour");
        System.out.println(FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss").format(fromDt));
        System.out.println(FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss").format(toDt));
    }

    public static Object getTime(Date date, String str, String dateType) {
        SimpleDateFormat sfd = new SimpleDateFormat(dateType);
        String time = sfd.format(date);
        time = time + " 00:00:01";
        Date needTime = null;
        if ("string".equalsIgnoreCase(str)) {
            return time;
        }
        if ("date".equalsIgnoreCase(str)) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                needTime = simpleDateFormat.parse(time);
            }
            catch (ParseException e) {
                e.printStackTrace();
                System.out.println("\u8f6c\u6362\u5f02\u5e38\uff01");
            }
        }
        return needTime;
    }
}

