/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.xz;

import com.chinamcloud.bigdata.haiheservice.bean.FacetSearchResult;
import com.chinamcloud.bigdata.haiheservice.xz.IAliDataParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.taobao.kelude.aps.feedback.model.ApsFacetField;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class FacetSearchDataParser<T>
implements IAliDataParser<T> {
    private static Logger logger = LogManager.getLogger(FacetSearchDataParser.class);

    @Override
    public T parserData(String data) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setDateFormat((DateFormat)new SimpleDateFormat("MMM dd, yyyy hh:mm:ss aaa", Locale.ENGLISH));
        try {
            FacetSearchResult result = (FacetSearchResult)mapper.readValue(data, FacetSearchResult.class);
            List<ApsFacetField> facetResult = result.getData();
            logger.info("facetResult2=" + facetResult.size());
            if (facetResult.size() != 0 && result.isSuccess()) {
                return this.parseRecords(facetResult);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected abstract T parseRecords(List<ApsFacetField> var1);
}

