/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.dao;

import com.chinamcloud.bigdata.haiheservice.bean.AlarmInfoBean;
import com.chinamcloud.bigdata.haiheservice.bean.AlarmWatchInfoBean;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class AlarmInfoDao {
    @Autowired
    private JdbcTemplate jdbcTemplate;

    public List<AlarmInfoBean> getAlarmInfoById(Long userId, Long taskId, Long fromDt, Long toDt) {
        StringBuffer sql = new StringBuffer("select ti.*,tr.title,tr.keyword,tr.docValue,tr.emotionValueUpper,tr.emotionValueLower,tr.mediaValue from t_alarm_info ti right join t_alarm_rule tr on ti.taskId=tr.taskId where ti.userId=? and `time` BETWEEN FROM_UNIXTIME(? ,'%Y-%m-%d %H:%i:%S') and FROM_UNIXTIME(? ,'%Y-%m-%d %H:%i:%S')");
        if (taskId != null) {
            sql.append(" and ti.taskId=" + taskId);
        }
        sql.append(" order by time desc");
        return this.jdbcTemplate.query(sql.toString(), new Object[]{userId, fromDt, toDt}, (RowMapper)new RowMapper<AlarmInfoBean>(){

            public AlarmInfoBean mapRow(ResultSet rs, int rowNum) throws SQLException {
                AlarmInfoBean bean = new AlarmInfoBean();
                AlarmWatchInfoBean alarmWatchInfoBean = new AlarmWatchInfoBean();
                bean.setAlarmWatchInfoBean(alarmWatchInfoBean);
                bean.setId(rs.getInt("id"));
                bean.setTaskId(rs.getLong("taskId"));
                bean.setUserId(rs.getLong("userId"));
                bean.setArticleValue(rs.getLong("articleValue"));
                bean.setEmotionValue(rs.getLong("emotionValue"));
                bean.setMediaValue(rs.getLong("mediaValue"));
                bean.setTime(rs.getTimestamp("time"));
                alarmWatchInfoBean.setTitle(rs.getString("title"));
                alarmWatchInfoBean.setDocValue(rs.getString("docValue"));
                alarmWatchInfoBean.setEmotionValueLower(rs.getString("emotionValueLower"));
                alarmWatchInfoBean.setEmotionValueUpper(rs.getString("emotionValueUpper"));
                alarmWatchInfoBean.setMediaValue(rs.getString("mediaValue"));
                alarmWatchInfoBean.setKeyword(rs.getString("keyword"));
                return bean;
            }
        });
    }

    public void insertAlarmInfo(final AlarmInfoBean alarmInfoBean) {
        String sql = "insert into t_alarm_info(userId,taskId,articleValue,emotionValue,mediaValue,`time`) values (?,?,?,?,?,?)";
        ArrayList<Object[]> list = new ArrayList<Object[]>(){
            {
                this.add(new Object[]{alarmInfoBean.getUserId(), alarmInfoBean.getTaskId(), alarmInfoBean.getArticleValue(), alarmInfoBean.getEmotionValue(), alarmInfoBean.getMediaValue(), alarmInfoBean.getTime()});
            }
        };
        this.jdbcTemplate.batchUpdate(sql, (List)list);
    }
}

