/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.dao;

import com.chinamcloud.bigdata.haiheservice.bean.ConfigBean;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class ConfigDao {
    @Resource
    private JdbcTemplate jdbcTemplate;

    public ConfigBean getConfig(String type) {
        return (ConfigBean)this.jdbcTemplate.query("select * from t_config where type=?", new Object[]{type}, (ResultSetExtractor)new ResultSetExtractor<ConfigBean>(){

            public ConfigBean extractData(ResultSet rs) throws SQLException, DataAccessException {
                if (rs.next()) {
                    ConfigBean configBean = new ConfigBean();
                    configBean.setType(rs.getString("type"));
                    configBean.setDetail(rs.getString("detail"));
                    configBean.setUpdateTime(rs.getTimestamp("updateTime"));
                    return configBean;
                }
                return null;
            }
        });
    }

    public Date getLastUpdate(String type) {
        return (Date)this.jdbcTemplate.query("select updateTime from t_config where type=?", new Object[]{type}, (ResultSetExtractor)new ResultSetExtractor<Date>(){

            public Date extractData(ResultSet rs) throws SQLException, DataAccessException {
                if (rs.next()) {
                    return rs.getTimestamp("updateTime");
                }
                return null;
            }
        });
    }

    public List<String> getAreaNames(String province, String city) {
        return this.jdbcTemplate.query("SELECT area.name from t_region_province province INNER JOIN t_region_city city ON province.`code` = city.provinceCode INNER JOIN t_region_area area ON city.code = area.cityCode WHERE province.`name`=? and city.`name`=?", new Object[]{province, city}, (RowMapper)new RowMapper<String>(){

            public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                String string = rs.getString("name");
                return string;
            }
        });
    }

    public List<String> getArea(String province, String city) {
        return this.jdbcTemplate.query("SELECT area.name from t_region_province province INNER JOIN t_region_city city ON province.`code` = city.provinceCode INNER JOIN t_region_area area ON city.code = area.cityCode WHERE province.`name`=? and area.`name`=?", new Object[]{province, city}, (RowMapper)new RowMapper<String>(){

            public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                String string = rs.getString("name");
                return string;
            }
        });
    }

    public List<String> getAlias() {
        return this.jdbcTemplate.query("SELECT name,alias from t_region_alias", (RowMapper)new RowMapper<String>(){

            public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                return rs.getString("name") + "&" + rs.getString("alias");
            }
        });
    }
}

