/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.es.controller;

import com.chinamcloud.bigdata.haiheservice.CodeResult;
import com.chinamcloud.bigdata.haiheservice.ParamsFeedBackQueryProcessor;
import com.chinamcloud.bigdata.haiheservice.afterprocessor.EmotionTendencyGroupAfterProcessor;
import com.chinamcloud.bigdata.haiheservice.afterprocessor.IAfterProcessor;
import com.chinamcloud.bigdata.haiheservice.bean.AlarmGradeBean;
import com.chinamcloud.bigdata.haiheservice.bean.FacetGroupResult;
import com.chinamcloud.bigdata.haiheservice.bean.FacetResult;
import com.chinamcloud.bigdata.haiheservice.bean.HotEvent;
import com.chinamcloud.bigdata.haiheservice.bean.HotNews;
import com.chinamcloud.bigdata.haiheservice.bean.HotTopic;
import com.chinamcloud.bigdata.haiheservice.bean.HotTopicTrend;
import com.chinamcloud.bigdata.haiheservice.bean.Page;
import com.chinamcloud.bigdata.haiheservice.bean.Trend;
import com.chinamcloud.bigdata.haiheservice.cache.CacheUtil;
import com.chinamcloud.bigdata.haiheservice.es.bean.EventStatisticResult;
import com.chinamcloud.bigdata.haiheservice.es.bean.HotEventStatistic;
import com.chinamcloud.bigdata.haiheservice.es.bean.HotTopicStatistic;
import com.chinamcloud.bigdata.haiheservice.es.service.EsDataService;
import com.chinamcloud.bigdata.haiheservice.i18n.MessageSource;
import com.chinamcloud.bigdata.haiheservice.pojo.HotParams;
import com.chinamcloud.bigdata.haiheservice.util.DateUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.search.SearchResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/es/basic"})
public class EsBasicController {
    @Autowired
    private EsDataService dataService;
    private static Logger logger = LogManager.getLogger(EsBasicController.class);
    SimpleDateFormat dateFormatByHour = new SimpleDateFormat("yyyy-MM-dd HH");
    @Autowired
    private JdbcTemplate jdbcTemplate;

    @RequestMapping(value={"/hotEvent"})
    public Object hotEvent(HttpServletRequest request) {
        Page<HotEvent> hotEvents;
        HotParams params = (HotParams)request.getAttribute("params");
        Boolean aBoolean = (Boolean)request.getAttribute("cache");
        if (params == null) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        try {
            Object object;
            if (aBoolean != null && aBoolean.booleanValue() && (object = CacheUtil.Ctable(params, "redisCacheManager", "queryHotEvent")) != null) {
                return (CodeResult)object;
            }
            hotEvents = this.dataService.queryHotEvent(params);
        }
        catch (ParamsFeedBackQueryProcessor.ConfigMappingNoDataException e) {
            return new CodeResult(CodeResult.Code.Success, Collections.EMPTY_LIST);
        }
        catch (Exception e) {
            return new CodeResult(CodeResult.Code.Failed, e.getMessage());
        }
        if (hotEvents != null) {
            CodeResult codeResult = new CodeResult(CodeResult.Code.Success, hotEvents);
            if (aBoolean != null && aBoolean.booleanValue()) {
                CacheUtil.Cput(params, "redisCacheManager", "queryHotEvent", (Object)codeResult);
            }
            return codeResult;
        }
        return new CodeResult(CodeResult.Code.Failed, MessageSource.getMsg("get_data_failed"));
    }

    @RequestMapping(value={"/hotNews"})
    public Object hotNews(HttpServletRequest request) {
        Page<HotNews> hotNews;
        HotParams params = (HotParams)request.getAttribute("params");
        Boolean aBoolean = (Boolean)request.getAttribute("cache");
        if (params == null) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        try {
            List<HotNews> records;
            Object object;
            if (aBoolean != null && aBoolean.booleanValue() && (object = CacheUtil.Ctable(params, "redisCacheManager#60*10", "hotNews")) != null) {
                return (CodeResult)object;
            }
            hotNews = params.getDuplicate() != false ? this.dataService.queryHotNewsCluster(params) : this.dataService.queryHotNewsSearch(params);
            IAfterProcessor<?> processor = params.getAfterProcessor();
            if (processor != null && (records = hotNews.getRecords()).size() > 0) {
                records.stream().forEach(x -> processor.process(x));
            }
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)e);
            return CodeResult.failedResultByMsgSource("params_error");
        }
        catch (ParamsFeedBackQueryProcessor.ConfigMappingNoDataException e) {
            logger.error((Object)e);
            return CodeResult.successResult(null, Collections.emptyList());
        }
        catch (Exception e) {
            logger.error((Object)e);
            return CodeResult.failedResultByMsgSource("server_error");
        }
        if (hotNews != null) {
            if (aBoolean != null && aBoolean.booleanValue()) {
                CacheUtil.Cput(params, "redisCacheManager#60*10", "hotNews", (Object)new CodeResult(CodeResult.Code.Success, hotNews));
            }
            return new CodeResult(CodeResult.Code.Success, hotNews);
        }
        return CodeResult.failedResultByMsgSource("get_data_failed");
    }

    @RequestMapping(value={"/alarmNews"})
    public Object alarmNews(HttpServletRequest request) {
        HotParams params = (HotParams)request.getAttribute("params");
        Boolean aBoolean = (Boolean)request.getAttribute("cache");
        if (params == null) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        ArrayList<FacetResult> hotNews = new ArrayList<FacetResult>();
        try {
            Object object;
            if (aBoolean != null && aBoolean.booleanValue() && (object = CacheUtil.Ctable(params, "redisCacheManager#60*10", "hotNews")) != null) {
                return (CodeResult)object;
            }
            params.setFacetField("cluster");
            List<FacetResult> hotNewsEmotion = this.dataService.facet(params);
            params.setEmotionLower(null);
            params.setEmotionUpper(null);
            List<FacetResult> hotNewsDoc = this.dataService.facet(params);
            params.setFacetField("parentSource");
            List<FacetResult> hotNewsMedia = this.dataService.facetRepetition(params);
            hotNewsDoc.stream().forEach(x -> {
                x.setArticleValue(x.getValue());
                x.setValue(null);
            });
            hotNewsEmotion.stream().forEach(x -> {
                x.setEmotionValue(x.getValue());
                x.setValue(null);
            });
            hotNewsMedia.stream().filter(x -> ((FacetGroupResult)x).getValues().get(0).getValue() >= (long)params.getMediaValue().intValue()).forEach(x -> {
                x.setMediaValue(((FacetGroupResult)x).getValues().get(0).getValue());
                x.setValue(null);
            });
            hotNews.addAll(hotNewsDoc);
            hotNews.addAll(hotNewsMedia);
            hotNews.addAll(hotNewsEmotion);
            IAfterProcessor<?> processor = params.getAfterProcessor();
            if (processor != null) {
                processor.process(hotNews);
            }
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)e);
            return CodeResult.failedResultByMsgSource("params_error");
        }
        catch (ParamsFeedBackQueryProcessor.ConfigMappingNoDataException e) {
            logger.error((Object)e);
            return CodeResult.successResult(null, Collections.emptyList());
        }
        catch (Exception e) {
            logger.error((Object)e);
            return CodeResult.failedResultByMsgSource("server_error");
        }
        if (hotNews != null) {
            if (aBoolean != null && aBoolean.booleanValue()) {
                CacheUtil.Cput(params, "redisCacheManager#60*10", "hotNews", (Object)new CodeResult(CodeResult.Code.Success, hotNews));
            }
            return new CodeResult(CodeResult.Code.Success, hotNews);
        }
        return CodeResult.failedResultByMsgSource("get_data_failed");
    }

    @RequestMapping(value={"/newsDetail"})
    public Object newsDetail(HttpServletRequest request) {
        HotNews hotNews;
        HotParams params = (HotParams)request.getAttribute("params");
        if (params == null) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        try {
            hotNews = this.dataService.queryNewsDetail(params);
        }
        catch (IllegalArgumentException e) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        catch (ParamsFeedBackQueryProcessor.ConfigMappingNoDataException e) {
            return CodeResult.successResult(null, Collections.emptyList());
        }
        catch (Exception e) {
            return CodeResult.failedResultByMsgSource("server_error");
        }
        if (hotNews != null) {
            return new CodeResult(CodeResult.Code.Success, hotNews);
        }
        return CodeResult.failedResultByMsgSource("get_data_failed");
    }

    @RequestMapping(value={"/relatedNews"})
    public Object relatedNews(HttpServletRequest request) {
        Page<HotNews> hotNews;
        HotParams params = (HotParams)request.getAttribute("params");
        if (params == null) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        try {
            hotNews = this.dataService.queryHotNewsSearch(params);
        }
        catch (NumberFormatException e) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        catch (ParamsFeedBackQueryProcessor.ConfigMappingNoDataException e) {
            return CodeResult.successResult(null, Collections.EMPTY_LIST);
        }
        catch (Exception e) {
            return CodeResult.failedResultByMsgSource("server_error");
        }
        if (hotNews != null) {
            return CodeResult.successResult(null, hotNews);
        }
        return CodeResult.failedResultByMsgSource("get_data_failed");
    }

    @RequestMapping(value={"/facet"})
    public Object facet(HttpServletRequest request) {
        HotParams params = (HotParams)request.getAttribute("params");
        Boolean aBoolean = (Boolean)request.getAttribute("cache");
        if (params == null) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        try {
            Object object;
            if (aBoolean != null && aBoolean.booleanValue() && (object = CacheUtil.Ctable(params, "redisCacheManager", "facet")) != null) {
                return (CodeResult)object;
            }
            EmotionTendencyGroupAfterProcessor afterProcessor = params.getAfterProcessor();
            String type = params.getType();
            if (StringUtils.isNotBlank((CharSequence)type)) {
                afterProcessor = new EmotionTendencyGroupAfterProcessor();
            }
            List<FacetResult> facet = this.dataService.facet(params);
            if (afterProcessor != null && StringUtils.isNotBlank((CharSequence)params.getFacetField())) {
                afterProcessor.process(facet);
            }
            if (facet != null) {
                List<FacetResult> result = Collections.singletonList(facet).get(0);
                if (aBoolean != null && aBoolean.booleanValue() && !facet.isEmpty()) {
                    CacheUtil.Cput(params, "redisCacheManager", "facet", (Object)new CodeResult(CodeResult.Code.Success, result));
                }
                return new CodeResult(CodeResult.Code.Success, result);
            }
            return new CodeResult(CodeResult.Code.Success, Collections.EMPTY_LIST);
        }
        catch (NumberFormatException e) {
            return new CodeResult(CodeResult.Code.Failed, MessageSource.getMsg("params_error"));
        }
        catch (ParamsFeedBackQueryProcessor.ConfigMappingNoDataException e) {
            return new CodeResult(CodeResult.Code.Success, Collections.EMPTY_LIST);
        }
        catch (Exception e) {
            return new CodeResult(CodeResult.Code.Failed, e.getMessage());
        }
    }

    @RequestMapping(value={"/alarmGrade"})
    private Object alarmGrade(HttpServletRequest request) {
        Integer min;
        List<FacetResult> hotNewsMedia;
        Integer doc;
        HotParams params = (HotParams)request.getAttribute("params");
        Boolean aBoolean = (Boolean)request.getAttribute("cache");
        if (params == null) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        Calendar calendar = Calendar.getInstance();
        Date toDt = calendar.getTime();
        calendar.add(10, -2);
        Date fromDt = calendar.getTime();
        if (params == null) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        params.setFromDt(fromDt);
        params.setToDt(toDt);
        logger.info("description=" + params.getDescription());
        Object result = null;
        ArrayList records = new ArrayList();
        try {
            Object object;
            if (aBoolean != null && aBoolean.booleanValue() && (object = CacheUtil.Ctable(params, "redisCacheManager#60*10", "alarmGrade")) != null) {
                return (CodeResult)object;
            }
            String facetField = params.getFacetField();
            params.setFacetField("cluster");
            params.setEmotionLower(null);
            params.setEmotionUpper(null);
            doc = this.dataService.statisticNews(params);
            params.setFacetField("parentSource");
            hotNewsMedia = this.dataService.facet(params);
            params.setMinField("emotionScore");
            params.setType("min");
            min = this.dataService.maximin(params);
            params.setMaxField("emotionScore");
            params.setType("max");
            Integer max = this.dataService.maximin(params);
            params.setFacetField(facetField);
            params.setMinField(null);
            params.setMaxField(null);
            params.setType(null);
        }
        catch (NumberFormatException e) {
            return new CodeResult(CodeResult.Code.Failed, MessageSource.getMsg("params_error"));
        }
        catch (ParamsFeedBackQueryProcessor.ConfigMappingNoDataException e) {
            return new CodeResult(CodeResult.Code.Success, Collections.EMPTY_LIST);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CodeResult(CodeResult.Code.Failed, e.getMessage());
        }
        AlarmGradeBean alarmGradeBean = new AlarmGradeBean();
        if (null != doc && doc > 0) {
            int grade = 0;
            if (doc >= 200) {
                grade = 4;
            } else if (doc >= 100) {
                grade = 3;
            } else if (doc >= 50) {
                grade = 2;
            } else if (doc >= 20) {
                grade = 1;
            }
            alarmGradeBean.setDocValue((long)doc);
            alarmGradeBean.setMinEmotionValue((long)min);
            if (min <= -99) {
                grade = grade >= 4 ? grade : 4;
            } else if (min <= -97) {
                grade = grade >= 3 ? grade : 3;
            } else if (min <= -95) {
                grade = grade >= 2 ? grade : 2;
            } else if (min <= -90) {
                grade = grade >= 1 ? grade : 1;
            }
            alarmGradeBean.setMediaValue(Long.valueOf(hotNewsMedia.size()));
            if (hotNewsMedia.size() >= 50) {
                grade = grade >= 4 ? grade : 4;
            } else if (hotNewsMedia.size() >= 30) {
                grade = grade >= 3 ? grade : 3;
            } else if (hotNewsMedia.size() >= 20) {
                grade = grade >= 2 ? grade : 2;
            } else if (hotNewsMedia.size() >= 10) {
                grade = grade >= 1 ? grade : 1;
            }
            switch (grade) {
                case 4: {
                    alarmGradeBean.setAlarmGrade("\u7ea2\u8272");
                    break;
                }
                case 3: {
                    alarmGradeBean.setAlarmGrade("\u6a59\u8272");
                    break;
                }
                case 2: {
                    alarmGradeBean.setAlarmGrade("\u9ec4\u8272");
                    break;
                }
                case 1: {
                    alarmGradeBean.setAlarmGrade("\u84dd\u8272");
                    break;
                }
                default: {
                    alarmGradeBean.setAlarmGrade("\u6b63\u5e38");
                    break;
                }
            }
        } else {
            alarmGradeBean.setAlarmGrade("\u6b63\u5e38");
            alarmGradeBean.setMediaValue(0L);
            alarmGradeBean.setDocValue(0L);
            alarmGradeBean.setMinEmotionValue(0L);
        }
        if (aBoolean != null && aBoolean.booleanValue()) {
            CacheUtil.Cput(params, "redisCacheManager#60*10", "alarmGrade", (Object)new CodeResult(CodeResult.Code.Success, alarmGradeBean));
        }
        return new CodeResult(CodeResult.Code.Success, alarmGradeBean);
    }

    @RequestMapping(value={"/facetWithCondition"})
    public Object facetWithCondition(HttpServletRequest request) {
        HotParams params = (HotParams)request.getAttribute("params");
        Boolean aBoolean = (Boolean)request.getAttribute("cache");
        if (params == null) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        try {
            Object object;
            if (aBoolean != null && aBoolean.booleanValue() && (object = CacheUtil.Ctable(params, "redisCacheManager", "facetWithCondition")) != null) {
                return (CodeResult)object;
            }
            List<FacetResult> result = this.dataService.facetWithCondition(params);
            IAfterProcessor<?> afterProcessor = params.getAfterProcessor();
            if (afterProcessor != null) {
                afterProcessor.process(result);
            }
            if (result != null) {
                if (aBoolean != null && aBoolean.booleanValue()) {
                    CacheUtil.Cput(params, "redisCacheManager", "facetWithCondition", (Object)new CodeResult(CodeResult.Code.Success, result));
                }
                return new CodeResult(CodeResult.Code.Success, result);
            }
            return new CodeResult(CodeResult.Code.Success, Collections.EMPTY_LIST);
        }
        catch (NumberFormatException e) {
            return new CodeResult(CodeResult.Code.Failed, MessageSource.getMsg("params_error"));
        }
        catch (ParamsFeedBackQueryProcessor.ConfigMappingNoDataException e) {
            return new CodeResult(CodeResult.Code.Success, Collections.EMPTY_LIST);
        }
        catch (Exception e) {
            return new CodeResult(CodeResult.Code.Failed, e.getMessage());
        }
    }

    @RequestMapping(value={"/newsDocIdByHotWords"})
    public Object newsDocIdByHotWords(HttpServletRequest request) {
        HotParams params = (HotParams)request.getAttribute("params");
        if (params == null) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        Page<HotNews> hotNews = null;
        try {
            hotNews = this.dataService.queryHotNewsSearch(params);
        }
        catch (NumberFormatException e) {
            return new CodeResult(CodeResult.Code.Failed, MessageSource.getMsg("params_error"));
        }
        catch (ParamsFeedBackQueryProcessor.ConfigMappingNoDataException e) {
            return new CodeResult(CodeResult.Code.Success, Collections.EMPTY_LIST);
        }
        catch (Exception e) {
            return new CodeResult(CodeResult.Code.Failed, MessageSource.getMsg("server_error"));
        }
        if (hotNews != null) {
            CodeResult codeResult = new CodeResult(CodeResult.Code.Success, hotNews.getRecords().get(0));
            return codeResult;
        }
        return new CodeResult(CodeResult.Code.Failed, MessageSource.getMsg("get_data_failed"));
    }

    @RequestMapping(value={"/sentimentTrend"})
    public Object sentimentTrend(HttpServletRequest request) {
        HotParams params = (HotParams)request.getAttribute("params");
        Boolean aBoolean = (Boolean)request.getAttribute("cache");
        if (params == null) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        try {
            Object object;
            if (aBoolean != null && aBoolean.booleanValue() && (object = CacheUtil.Ctable(params, "redisCacheManager#60*30", "sentimentTrend")) != null) {
                return (CodeResult)object;
            }
            List<FacetResult> facets = this.dataService.dateHistogram(params);
            TreeMap<Long, Long> result = new TreeMap<Long, Long>();
            for (FacetResult bean : facets) {
                result.put(this.dateFormatByHour.parse(bean.getName()).getTime(), bean.getValue());
            }
            CodeResult codeResult = new CodeResult(CodeResult.Code.Success);
            codeResult.setResult(result);
            if (aBoolean != null && aBoolean.booleanValue()) {
                CacheUtil.Cput(params, "redisCacheManager#60*30", "sentimentTrend", (Object)codeResult);
            }
            return codeResult;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CodeResult(CodeResult.Code.Failed, MessageSource.getMsg("get_data_failed"));
        }
    }

    @RequestMapping(value={"/eventStatistics"})
    public Object eventStatistics(HttpServletRequest request) {
        HotParams params = (HotParams)request.getAttribute("params");
        Boolean aBoolean = (Boolean)request.getAttribute("cache");
        if (params == null) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        try {
            Object object;
            EventStatisticResult bean = new EventStatisticResult();
            params.setHistogramInterval("year");
            if (aBoolean != null && aBoolean.booleanValue() && (object = CacheUtil.Ctable(params, "redisCacheManager#60*30", "eventStatistics")) != null) {
                return (CodeResult)object;
            }
            HotEventStatistic result = this.dataService.hotEventStatistic(params);
            List<Trend> doc_count = result.getDoc_count();
            List<Trend> emotion_value = result.getEmotion_value();
            List<Trend> hot_value = result.getHot_value();
            List<Trend> media_cover = result.getMedia_cover();
            long docTotal = doc_count.stream().mapToLong(x -> x.getValue()).sum();
            long hotTotal = hot_value.stream().mapToLong(x -> x.getValue()).sum();
            long emotionTotal = result.getDocTotalCount() > 0L ? result.getEmotionTotalCount() / result.getDocTotalCount() : 0L;
            long mediaCoverTotal = media_cover.stream().mapToLong(x -> x.getValue()).sum();
            bean.setDocTotal(docTotal);
            bean.setEmotionTotal(emotionTotal);
            bean.setHotTotal(hotTotal);
            bean.setMediaCoverTotal(mediaCoverTotal);
            params.setHistogramInterval("day");
            params.setFromDt(DateUtils.computeDatesBackward(3, true)[0]);
            params.setToDt(DateUtils.computeDatesBackward(2, true)[0]);
            result = this.dataService.hotEventStatistic(params);
            IAfterProcessor<?> processor = params.getAfterProcessor();
            if (processor != null) {
                processor.process(result);
            }
            bean.setTrend(result);
            CodeResult codeResult = new CodeResult(CodeResult.Code.Success);
            codeResult.setResult(bean);
            if (aBoolean != null && aBoolean.booleanValue()) {
                params.setHistogramInterval("year");
                params.setFromDt(null);
                params.setToDt(null);
                CacheUtil.Cput(params, "redisCacheManager#60*30", "eventStatistics", (Object)codeResult);
            }
            return codeResult;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CodeResult(CodeResult.Code.Failed, MessageSource.getMsg("get_data_failed"));
        }
    }

    @RequestMapping(value={"/eventStatisticsTotal"})
    public Object eventStatisticsTotal(HttpServletRequest request) {
        HotParams params = (HotParams)request.getAttribute("params");
        Boolean aBoolean = (Boolean)request.getAttribute("cache");
        if (params == null) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        try {
            Object object;
            EventStatisticResult bean = new EventStatisticResult();
            params.setInterval("year");
            if (aBoolean != null && aBoolean.booleanValue() && (object = CacheUtil.Ctable(params, "redisCacheManager", "eventStatisticsTotal")) != null) {
                return (CodeResult)object;
            }
            HotEventStatistic result = this.dataService.hotEventStatistic(params);
            List<Trend> doc_count = result.getDoc_count();
            List<Trend> emotion_value = result.getEmotion_value();
            List<Trend> hot_value = result.getHot_value();
            List<Trend> media_cover = result.getMedia_cover();
            long docTotal = doc_count.stream().mapToLong(x -> x.getValue()).sum();
            long hotTotal = hot_value.stream().mapToLong(x -> x.getValue()).sum();
            long emotionTotal = result.getDocTotalCount() > 0L ? result.getEmotionTotalCount() / result.getDocTotalCount() : 0L;
            long mediaCoverTotal = media_cover.stream().mapToLong(x -> x.getValue()).sum();
            bean.setDocTotal(docTotal);
            bean.setEmotionTotal(emotionTotal);
            bean.setHotTotal(hotTotal);
            bean.setMediaCoverTotal(mediaCoverTotal);
            CodeResult codeResult = new CodeResult(CodeResult.Code.Success);
            codeResult.setResult(bean);
            if (aBoolean != null && aBoolean.booleanValue()) {
                CacheUtil.Cput(params, "redisCacheManager", "eventStatisticsTotal", (Object)codeResult);
            }
            return codeResult;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CodeResult(CodeResult.Code.Failed, MessageSource.getMsg("get_data_failed"));
        }
    }

    @RequestMapping(value={"/eventStatisticsDiff"})
    public Object eventStatisticsDiff(HttpServletRequest request) {
        HotParams params = (HotParams)request.getAttribute("params");
        Boolean aBoolean = (Boolean)request.getAttribute("cache");
        if (params == null) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        try {
            Object object;
            EventStatisticResult bean = new EventStatisticResult();
            params.setInterval("day");
            params.setFromDt(DateUtils.computeDatesBackward(3, true)[0]);
            params.setToDt(DateUtils.computeDatesBackward(2, true)[0]);
            if (aBoolean != null && aBoolean.booleanValue() && (object = CacheUtil.Ctable(params, "redisCacheManager", "eventStatisticsDiff")) != null) {
                return (CodeResult)object;
            }
            HotEventStatistic result = this.dataService.hotEventStatistic(params);
            IAfterProcessor<?> processor = params.getAfterProcessor();
            if (processor != null) {
                processor.process(result);
            }
            bean.setTrend(result);
            CodeResult codeResult = new CodeResult(CodeResult.Code.Success);
            codeResult.setResult(bean);
            if (aBoolean != null && aBoolean.booleanValue()) {
                CacheUtil.Cput(params, "redisCacheManager", "eventStatisticsDiff", (Object)codeResult);
            }
            return codeResult;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CodeResult(CodeResult.Code.Failed, MessageSource.getMsg("get_data_failed"));
        }
    }

    @RequestMapping(value={"/eventTrend"})
    public Object eventTrend(HttpServletRequest request) {
        HotParams params = (HotParams)request.getAttribute("params");
        Boolean aBoolean = (Boolean)request.getAttribute("cache");
        if (params == null) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        try {
            Object object;
            if (aBoolean != null && aBoolean.booleanValue() && (object = CacheUtil.Ctable(params, "redisCacheManager", "eventTrend")) != null) {
                return (CodeResult)object;
            }
            HotEventStatistic result = this.dataService.hotEventStatistic(params);
            CodeResult codeResult = new CodeResult(CodeResult.Code.Success);
            codeResult.setResult(result);
            if (aBoolean != null && aBoolean.booleanValue()) {
                CacheUtil.Cput(params, "redisCacheManager", "eventTrend", (Object)codeResult);
            }
            return codeResult;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CodeResult(CodeResult.Code.Failed, MessageSource.getMsg("get_data_failed"));
        }
    }

    @RequestMapping(value={"/topicStatistics"})
    public Object topicStatistics(HttpServletRequest request) {
        HotParams params = (HotParams)request.getAttribute("params");
        Boolean aBoolean = (Boolean)request.getAttribute("cache");
        if (params == null) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        try {
            Object object;
            if (aBoolean != null && aBoolean.booleanValue() && (object = CacheUtil.Ctable(params, "redisCacheManager", "topicStatistics")) != null) {
                return (CodeResult)object;
            }
            List<HotTopicStatistic> result = this.dataService.hotTopicStatistic(params);
            IAfterProcessor<?> processor = params.getAfterProcessor();
            if (processor != null && result.size() > 0) {
                for (int i = 0; i < result.size(); ++i) {
                    HotTopicStatistic hotTopicStatistic = result.get(i);
                    processor.process(hotTopicStatistic);
                }
            }
            CodeResult codeResult = new CodeResult(CodeResult.Code.Success);
            codeResult.setResult(result);
            if (aBoolean != null && aBoolean.booleanValue() && !result.isEmpty()) {
                CacheUtil.Cput(params, "redisCacheManager", "topicStatistics", (Object)codeResult);
            }
            return codeResult;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CodeResult(CodeResult.Code.Failed, MessageSource.getMsg("get_data_failed"));
        }
    }

    @RequestMapping(value={"/topic"})
    public Object topicStatisticsTotal(HttpServletRequest request) {
        HotParams params = (HotParams)request.getAttribute("params");
        Boolean aBoolean = (Boolean)request.getAttribute("cache");
        if (params == null) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        try {
            Object object;
            if (aBoolean != null && aBoolean.booleanValue() && (object = CacheUtil.Ctable(params, "redisCacheManager", "topicStatisticsTotal")) != null) {
                return (CodeResult)object;
            }
            List<HotTopicStatistic> result = this.dataService.hotTopicStatistic(params);
            IAfterProcessor<?> processor = params.getAfterProcessor();
            if (processor != null && result.size() > 0) {
                for (int i = 0; i < result.size(); ++i) {
                    HotTopicStatistic hotTopicStatistic = result.get(i);
                    processor.process(hotTopicStatistic);
                }
            }
            CodeResult codeResult = new CodeResult(CodeResult.Code.Success);
            codeResult.setResult(result);
            if (aBoolean != null && aBoolean.booleanValue()) {
                CacheUtil.Cput(params, "redisCacheManager", "topicStatisticsTotal", (Object)codeResult);
            }
            return codeResult;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CodeResult(CodeResult.Code.Failed, MessageSource.getMsg("get_data_failed"));
        }
    }

    @RequestMapping(value={"/hotTopic"})
    public Object hotTopic(HttpServletRequest request) {
        HotParams params = (HotParams)request.getAttribute("params");
        Boolean aBoolean = (Boolean)request.getAttribute("cache");
        if (params == null) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        try {
            Object object;
            if (aBoolean != null && aBoolean.booleanValue() && (object = CacheUtil.Ctable(params, "redisCacheManager#60*30", "hotTopic")) != null) {
                return (CodeResult)object;
            }
            Page<HotTopic> result = this.dataService.hotTopic(params);
            CodeResult codeResult = new CodeResult(CodeResult.Code.Success);
            codeResult.setResult(result);
            if (aBoolean != null && aBoolean.booleanValue() && !result.getRecords().isEmpty()) {
                CacheUtil.Cput(params, "redisCacheManager#60*30", "hotTopic", (Object)codeResult);
            }
            return codeResult;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CodeResult(CodeResult.Code.Failed, MessageSource.getMsg("get_data_failed"));
        }
    }

    @RequestMapping(value={"/topicTrend"})
    public Object topicEvent(HttpServletRequest request) {
        HotParams params = (HotParams)request.getAttribute("params");
        if (params == null) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        try {
            HotTopicTrend result = this.dataService.hotTopicTrend(params);
            CodeResult codeResult = new CodeResult(CodeResult.Code.Success);
            codeResult.setResult(result);
            return codeResult;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CodeResult(CodeResult.Code.Failed, MessageSource.getMsg("get_data_failed"));
        }
    }

    @RequestMapping(value={"/termBucketAgg"})
    public Object bucketsAgg(HttpServletRequest request) {
        HotParams params = (HotParams)request.getAttribute("params");
        Boolean aBoolean = (Boolean)request.getAttribute("cache");
        List aggBucket = (List)request.getAttribute("termBucket");
        try {
            Object object;
            if (aBoolean != null && aBoolean.booleanValue() && (object = CacheUtil.Ctable(params, "redisCacheManager#60*30", "bucketsAgg")) != null) {
                return (CodeResult)object;
            }
            List<FacetResult> result = this.dataService.termBucketFacet(params, aggBucket);
            IAfterProcessor<?> afterProcessor = params.getAfterProcessor();
            if (afterProcessor != null) {
                afterProcessor.process(result);
            }
            CodeResult codeResult = new CodeResult(CodeResult.Code.Success, result);
            if (result != null) {
                if (aBoolean != null && aBoolean.booleanValue()) {
                    CacheUtil.Cput(params, "redisCacheManager#60*30", "bucketsAgg", (Object)codeResult);
                }
                return codeResult;
            }
            return new CodeResult(CodeResult.Code.Success, Collections.EMPTY_LIST);
        }
        catch (NumberFormatException e) {
            return new CodeResult(CodeResult.Code.Failed, MessageSource.getMsg("params_error"));
        }
        catch (ParamsFeedBackQueryProcessor.ConfigMappingNoDataException e) {
            return new CodeResult(CodeResult.Code.Success, Collections.EMPTY_LIST);
        }
        catch (Exception e) {
            return new CodeResult(CodeResult.Code.Failed, e.getMessage());
        }
    }

    @RequestMapping(value={"/exportNews"})
    public Object exportNews(HttpServletRequest request) {
        List<HotNews> hotNews;
        HotParams params = (HotParams)request.getAttribute("params");
        if (params == null) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        try {
            hotNews = this.dataService.exportNews(params);
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)e);
            return CodeResult.failedResultByMsgSource("params_error");
        }
        catch (ParamsFeedBackQueryProcessor.ConfigMappingNoDataException e) {
            logger.error((Object)e);
            return CodeResult.successResult(null, Collections.emptyList());
        }
        catch (Exception e) {
            logger.error((Object)e);
            return CodeResult.failedResultByMsgSource("server_error");
        }
        if (hotNews != null) {
            return new CodeResult(CodeResult.Code.Success, hotNews);
        }
        return CodeResult.failedResultByMsgSource("get_data_failed");
    }

    @RequestMapping(value={"/statisticNews"})
    public Object statisticNews(HttpServletRequest request) {
        HotParams params = (HotParams)request.getAttribute("params");
        if (params == null) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        int count = 0;
        try {
            count = this.dataService.statisticNews(params);
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)e);
            return CodeResult.failedResultByMsgSource("params_error");
        }
        catch (ParamsFeedBackQueryProcessor.ConfigMappingNoDataException e) {
            logger.error((Object)e);
            return CodeResult.successResult(null, Collections.emptyList());
        }
        catch (Exception e) {
            logger.error((Object)e);
            return CodeResult.failedResultByMsgSource("server_error");
        }
        map.put("newsValue", count);
        return new CodeResult(CodeResult.Code.Success, map);
    }

    @RequestMapping(value={"/getSiteList"})
    public Object getSiteList(HttpServletRequest request) {
        String siteName = request.getParameter("siteName");
        System.out.println("step1:" + siteName);
        SearchResponse result = null;
        if (siteName != null) {
            result = this.dataService.querySitesList(siteName);
        }
        return result.toString();
    }

    @RequestMapping(value={"/addSubscribeSite"})
    public Object addSubscribeSite(HttpServletRequest request) {
        try {
            String userId = request.getParameter("userId");
            String sourceId = request.getParameter("sourceId");
            String sourceType = request.getParameter("sourceType");
            String siteName = request.getParameter("siteName");
            if (userId != null && sourceId != null && sourceType != null && siteName != null) {
                this.jdbcTemplate.update("INSERT INTO  `t_user_crawler` (`userId`,`sourceId`,`sourceType`,`comment`) VALUES(?,?,?,?)", new Object[]{userId, sourceId, sourceType, siteName});
                return new CodeResult(CodeResult.Code.Success);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            return CodeResult.failedResultByMsgSource("server_error");
        }
        return new CodeResult(CodeResult.Code.Failed);
    }

    @RequestMapping(value={"/addPushConfig"}, method={RequestMethod.POST})
    public Object addPushConfig(@RequestParam String userId, String sourceIds, String topicIds, String template, String pushUrl) {
        try {
            System.out.println("step1:" + userId);
            System.out.println("step1:" + sourceIds);
            System.out.println("step1:" + topicIds);
            System.out.println("step1:" + template);
            System.out.println("step1:" + pushUrl);
            if (userId != null && sourceIds != null && topicIds != null && template != null && pushUrl != null) {
                this.jdbcTemplate.update("INSERT INTO  `t_user_crawler_push_config` (`userId`,`sourceIds`,`topicIds`,`template`,`pushUrl`) VALUES(?,?,?,?,?)", new Object[]{userId, sourceIds, topicIds, template, pushUrl});
                return new CodeResult(CodeResult.Code.Success);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            return CodeResult.failedResultByMsgSource("server_error");
        }
        return new CodeResult(CodeResult.Code.Failed);
    }
}

