/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.es.dao;

import com.chinamcloud.bigdata.haiheservice.es.EsFeedbackQuery;
import com.chinamcloud.bigdata.haiheservice.es.EsFeedbackQueryBuilderManager;
import com.chinamcloud.bigdata.haiheservice.es.ParamsEsFeedBackQueryProcessor;
import com.chinamcloud.bigdata.haiheservice.es.pojo.EsBuildQuery;
import com.chinamcloud.bigdata.haiheservice.es.pojo.EsFactAggWithMaxMin;
import com.chinamcloud.bigdata.haiheservice.es.pojo.EsQueryParams;
import com.chinamcloud.bigdata.haiheservice.es.result.EsFacetMaxMinResultProcessor;
import com.chinamcloud.bigdata.haiheservice.es.result.EsPagedResult;
import com.chinamcloud.bigdata.haiheservice.es.result.EsSearchResult;
import com.chinamcloud.bigdata.haiheservice.pojo.HotParams;
import java.util.Collection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.springframework.stereotype.Component;

@Component
public class EsBaseDao {
    private static Logger logger = LogManager.getLogger(EsBaseDao.class);

    public GetResponse searchDocument(EsQueryParams params) {
        TransportClient client = params.getClient();
        String typeName = params.getTypeName();
        String indexName = params.getIndexName();
        logger.info("indexName: " + indexName + "   :::   typeName: " + typeName);
        String id = params.getId();
        GetResponse response = (GetResponse)client.prepareGet(indexName, typeName, String.valueOf(id)).get();
        return response;
    }

    public SearchResponse faceter(EsQueryParams params) {
        TransportClient client = params.getClient();
        String typeName = params.getTypeName();
        String indexName = params.getIndexName();
        logger.info("indexName: " + indexName + "   :::   typeName: " + typeName);
        QueryBuilder query = params.getQuery();
        AggregationBuilder agg = params.getAgg();
        SearchRequestBuilder builder = client.prepareSearch(new String[]{indexName}).setTypes(new String[]{typeName}).setQuery(query).addAggregation(agg);
        SearchResponse response = (SearchResponse)builder.execute().actionGet();
        return response;
    }

    public static void main(String[] args) throws Exception {
        HotParams hotParams = new HotParams();
        hotParams.setFacetField("parentSource");
        hotParams.setDescription("16\u652f\u961f\u4f0d");
        hotParams.setMinField("emotionScore");
        EsFeedbackQuery query = EsFeedbackQueryBuilderManager.processWithGlobalProceesor(new ParamsEsFeedBackQueryProcessor(hotParams), x -> {
            x.setFacetField(hotParams.getFacetField());
            x.setFacetMincount(1);
        });
        query.setType("min");
        EsQueryParams params = new EsQueryParams();
        params.setQuery(EsBuildQuery.getQuery(query));
        params.setAgg(new EsFactAggWithMaxMin().buildAgg(query));
        TransportClient client = params.getClient();
        String typeName = params.getTypeName();
        String indexName = params.getIndexName();
        logger.info("indexName: " + indexName + "   :::   typeName: " + typeName);
        QueryBuilder query1 = params.getQuery();
        AggregationBuilder agg = params.getAgg();
        SearchRequestBuilder builder = client.prepareSearch(new String[]{indexName}).setTypes(new String[]{typeName}).setQuery(query1).addAggregation(agg);
        System.out.println(builder.toString());
        SearchResponse response = (SearchResponse)builder.execute().actionGet();
        EsFacetMaxMinResultProcessor processor = new EsFacetMaxMinResultProcessor();
        EsPagedResult<EsSearchResult> esSearchResultEsPagedResult = processor.processResult(query, response);
        System.out.println(esSearchResultEsPagedResult.getTotalCount());
    }

    public SearchResponse searcher(EsQueryParams params) {
        TransportClient client = params.getClient();
        String typeName = params.getTypeName();
        String indexName = params.getIndexName();
        logger.info("indexName: " + indexName + "   :::   typeName: " + typeName);
        QueryBuilder query = params.getQuery();
        int[] pos = params.getPos();
        Collection<FieldSortBuilder> sort = params.getSort();
        SearchRequestBuilder requestBuilder = client.prepareSearch(new String[]{indexName}).setTypes(new String[]{typeName}).setQuery(query).setFrom(pos[0]).setSize(pos[1]);
        if (sort != null && sort.size() > 0) {
            sort.forEach(x -> requestBuilder.addSort((SortBuilder)x));
        }
        SearchResponse response = (SearchResponse)requestBuilder.execute().actionGet();
        return response;
    }
}

