/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.es.pojo;

import com.chinamcloud.bigdata.haiheservice.es.EsFeedbackQuery;
import com.chinamcloud.bigdata.haiheservice.util.DateUtils;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MatchPhraseQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;

public class EsBuildQuery {
    private static Logger logger = LogManager.getLogger(EsBuildQuery.class);

    public static QueryBuilder getQuery(EsFeedbackQuery feedbackQuery) {
        BoolQueryBuilder query = QueryBuilders.boolQuery();
        EsBuildQuery.setDescription(query, feedbackQuery);
        EsBuildQuery.setContentNotContains(query, feedbackQuery);
        EsBuildQuery.setExcludeSpiderTopicids(query, feedbackQuery);
        EsBuildQuery.setFilterBuilder(query, feedbackQuery);
        return query;
    }

    protected static void setFilterBuilder(BoolQueryBuilder query, EsFeedbackQuery feedbackQuery) {
        BoolQueryBuilder filter = QueryBuilders.boolQuery();
        EsBuildQuery.setProductIds(filter, feedbackQuery);
        EsBuildQuery.setId(filter, feedbackQuery);
        EsBuildQuery.setCountry(filter, feedbackQuery);
        EsBuildQuery.setSpiderTopicId(filter, feedbackQuery);
        EsBuildQuery.setSourceId(filter, feedbackQuery);
        EsBuildQuery.setMonitorTopicId(filter, feedbackQuery);
        EsBuildQuery.setCrawlerKeyword(filter, feedbackQuery);
        EsBuildQuery.setSource(filter, feedbackQuery);
        EsBuildQuery.setClusterId(filter, feedbackQuery);
        EsBuildQuery.setCluster(filter, feedbackQuery);
        EsBuildQuery.setPubtime(filter, feedbackQuery);
        EsBuildQuery.setCrawlertime(filter, feedbackQuery);
        EsBuildQuery.setContentShouldContains(filter, feedbackQuery);
        EsBuildQuery.setSubject(filter, feedbackQuery);
        EsBuildQuery.setTbNickname(filter, feedbackQuery);
        EsBuildQuery.setEmotionTendency(filter, feedbackQuery);
        EsBuildQuery.setEmotionScore(filter, feedbackQuery);
        query.filter((QueryBuilder)filter);
    }

    protected static void setDescription(BoolQueryBuilder boolQuery, EsFeedbackQuery feedbackQuery) {
        String subject = feedbackQuery.getDescription();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (!StringUtils.isEmpty((CharSequence)subject)) {
            String[] groups;
            for (String group : groups = subject.split("OR")) {
                String[] keywords;
                BoolQueryBuilder boolmatch = QueryBuilders.boolQuery();
                for (String keyword : keywords = group.split("AND")) {
                    MatchPhraseQueryBuilder tmp = QueryBuilders.matchPhraseQuery((String)"description", (Object)keyword.trim()).analyzer("ik_smart");
                    boolmatch.must((QueryBuilder)tmp);
                }
                boolQueryBuilder.should((QueryBuilder)boolmatch);
            }
            boolQuery.must((QueryBuilder)boolQueryBuilder);
        }
    }

    protected static void setContentNotContains(BoolQueryBuilder boolQuery, EsFeedbackQuery feedbackQuery) {
        List<String> contentNotContains = feedbackQuery.getContentNotContains();
        if (contentNotContains != null) {
            boolQuery.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)"description", contentNotContains));
        }
        if (feedbackQuery.isClusterKeywod()) {
            boolQuery.mustNot((QueryBuilder)QueryBuilders.termQuery((String)"cluster.keyword", (String)""));
            boolQuery.mustNot((QueryBuilder)QueryBuilders.termQuery((String)"cluster.keyword", (String)" "));
        }
        if (feedbackQuery.isParentSource()) {
            boolQuery.mustNot((QueryBuilder)QueryBuilders.termQuery((String)"parentSource", (String)"\u5fae\u535a"));
        }
    }

    protected static void setExcludeSpiderTopicids(BoolQueryBuilder boolQuery, EsFeedbackQuery feedbackQuery) {
        List<Integer> excludeSpiderTopicIds = feedbackQuery.getExcludeSpiderTopicIds();
        if (excludeSpiderTopicIds != null) {
            boolQuery.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)"spiderTopicId", excludeSpiderTopicIds));
        }
    }

    protected static void setContentShouldContains(BoolQueryBuilder boolQuery, EsFeedbackQuery feedbackQuery) {
        String contentShouldContain = feedbackQuery.getContentShouldContain();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (contentShouldContain != null) {
            boolQueryBuilder.should((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"description", (Object)contentShouldContain));
            boolQueryBuilder.should((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"subject", (Object)contentShouldContain));
            boolQueryBuilder.should((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"cluster", (Object)contentShouldContain));
            boolQuery.must((QueryBuilder)boolQueryBuilder);
        }
    }

    protected static void setSubject(BoolQueryBuilder boolQuery, EsFeedbackQuery feedbackQuery) {
        String subject = feedbackQuery.getSubject();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (subject != null) {
            boolQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"subject.keyword", (String)subject));
            boolQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"cluster.keyword", (String)subject));
            boolQuery.must((QueryBuilder)boolQueryBuilder);
        }
    }

    protected static void setProductId(BoolQueryBuilder boolQuery, EsFeedbackQuery feedbackQuery) {
        Integer productId = feedbackQuery.getProductId();
        if (productId != null) {
            boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"productId", (Object)productId));
        }
    }

    protected static void setProductIds(BoolQueryBuilder boolQuery, EsFeedbackQuery feedbackQuery) {
        List<Integer> productIds = feedbackQuery.getProductIds();
        if (productIds != null && productIds.size() > 0) {
            boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)"productId", productIds));
        }
    }

    protected static void setId(BoolQueryBuilder boolQuery, EsFeedbackQuery feedbackQuery) {
        String id = feedbackQuery.getId();
        if (id != null) {
            boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"id", (String)id));
        }
    }

    protected static void setCountry(BoolQueryBuilder boolQuery, EsFeedbackQuery feedbackQuery) {
        String country = feedbackQuery.getCountry();
        if (StringUtils.isNotBlank((CharSequence)country)) {
            boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"country", (String)country));
        }
    }

    protected static void setSpiderTopicId(BoolQueryBuilder boolQuery, EsFeedbackQuery feedbackQuery) {
        List<Integer> spiderTopicIds = feedbackQuery.getSpiderTopicIds();
        if (spiderTopicIds != null && spiderTopicIds.size() > 0) {
            boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)"spiderTopicId", spiderTopicIds));
        }
    }

    protected static void setSource(BoolQueryBuilder boolQuery, EsFeedbackQuery feedbackQuery) {
        String source;
        List<String> sources = feedbackQuery.getSources();
        if (sources != null && sources.size() > 0 && !(source = sources.get(0)).equals("all")) {
            boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)"source", sources));
        }
    }

    protected static void setSourceId(BoolQueryBuilder boolQuery, EsFeedbackQuery feedbackQuery) {
        List<Integer> sourceIds = feedbackQuery.getSourceIds();
        if (sourceIds != null && sourceIds.size() > 0) {
            boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)"sourceId", sourceIds));
        }
    }

    protected static void setMonitorTopicId(BoolQueryBuilder boolQuery, EsFeedbackQuery feedbackQuery) {
        Integer monitorTopicId = feedbackQuery.getMonitorTopicId();
        if (monitorTopicId != null) {
            boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"monitorTopicId", (Object)monitorTopicId));
        }
    }

    protected static void setCrawlerKeyword(BoolQueryBuilder boolQuery, EsFeedbackQuery feedbackQuery) {
        List<String> crawlerKeywords = feedbackQuery.getCrawlerKeywords();
        if (crawlerKeywords != null) {
            boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)"crawlerKeywords", crawlerKeywords));
        }
    }

    protected static void setClusterId(BoolQueryBuilder boolQuery, EsFeedbackQuery feedbackQuery) {
        Long clusterId = feedbackQuery.getClusterId();
        if (clusterId != null) {
            boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"clusterId", (Object)clusterId));
        }
    }

    protected static void setCluster(BoolQueryBuilder boolQuery, EsFeedbackQuery feedbackQuery) {
        String cluster = feedbackQuery.getCluster();
        if (cluster != null) {
            boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"cluster.keyword", (String)cluster));
        }
    }

    protected static void setPubtime(BoolQueryBuilder boolQuery, EsFeedbackQuery feedbackQuery) {
        Date from = DateUtils.string2date(feedbackQuery.getPubTimeBegin());
        Date to = DateUtils.string2date(feedbackQuery.getPubTimeEnd());
        if (from != null && to != null) {
            boolQuery.must((QueryBuilder)QueryBuilders.rangeQuery((String)"pubTime").from((Object)from.getTime()).to((Object)to.getTime()));
        }
    }

    protected static void setCrawlertime(BoolQueryBuilder boolQuery, EsFeedbackQuery feedbackQuery) {
        Date from = DateUtils.string2date(feedbackQuery.getCreatedAtBegin());
        Date to = DateUtils.string2date(feedbackQuery.getCreatedAtEnd());
        if (from != null && to != null) {
            boolQuery.must((QueryBuilder)QueryBuilders.rangeQuery((String)"createdAt").from((Object)from.getTime()).to((Object)to.getTime()));
        }
    }

    protected static void setTbNickname(BoolQueryBuilder boolQuery, EsFeedbackQuery feedbackQuery) {
        List<String> tbNicknames = feedbackQuery.getTbNicknames();
        if (tbNicknames != null && !tbNicknames.isEmpty()) {
            boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)"tbNickname", (String[])tbNicknames.toArray(new String[tbNicknames.size()])));
        }
    }

    protected static void setEmotionTendency(BoolQueryBuilder boolQuery, EsFeedbackQuery feedbackQuery) {
        Integer emotionTendency = feedbackQuery.getEmotionTendency();
        if (emotionTendency != null) {
            boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"emotionTendency", (Object)emotionTendency));
        }
    }

    protected static void setEmotionScore(BoolQueryBuilder boolQuery, EsFeedbackQuery feedbackQuery) {
        Integer emotionScoreUpper = feedbackQuery.getEmotionScoreUpper();
        Integer emotionScoreLower = feedbackQuery.getEmotionScoreLower();
        if (emotionScoreUpper != null || emotionScoreLower != null) {
            RangeQueryBuilder rangeQuery = QueryBuilders.rangeQuery((String)"emotionScore");
            if (emotionScoreUpper != null) {
                rangeQuery.lte((Object)emotionScoreUpper);
            }
            if (emotionScoreLower != null) {
                rangeQuery.gte((Object)emotionScoreLower);
            }
            boolQuery.filter((QueryBuilder)rangeQuery);
        }
    }

    protected static void setMaxField(BoolQueryBuilder boolQuery, EsFeedbackQuery feedbackQuery) {
        String maxField = feedbackQuery.getMaxField();
    }

    protected static void setMinField(BoolQueryBuilder boolQuery, EsFeedbackQuery feedbackQuery) {
    }
}

