/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.parser;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.chinamcloud.bigdata.haiheservice.bean.HotWords;
import com.chinamcloud.bigdata.haiheservice.util.JSONUtils;
import com.chinamcloud.bigdata.haiheservice.xz.IAliDataParser;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HotWordsDataParser
implements IAliDataParser<List<HotWords>> {
    private static Logger logger = LogManager.getLogger(HotWordsDataParser.class);

    @Override
    public List<HotWords> parserData(String data) {
        JSONObject jsonObject = JSONUtils.getJSONObject(data);
        JSONObject dataObject = JSONUtils.getJSONObject("data", jsonObject);
        JSONObject resultObject = JSONUtils.getJSONObject("result", dataObject);
        JSONArray listDataArray = JSONUtils.getJSONArray("listData", resultObject);
        if (listDataArray != null) {
            int length = listDataArray.size();
            ArrayList<HotWords> words = new ArrayList<HotWords>();
            try {
                for (int i = 0; i < length; ++i) {
                    JSONObject object = listDataArray.getJSONObject(i);
                    if (object == null) continue;
                    String name = object.getString("name");
                    int count = Integer.parseInt(object.getString("count"));
                    HotWords word = new HotWords();
                    word.setName(name);
                    word.setCount(count);
                    words.add(word);
                }
                return words;
            }
            catch (Exception e) {
                e.printStackTrace();
                words = null;
                logger.error("param listData failed", (Throwable)e);
            }
        }
        return null;
    }
}

