/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.parser;

import com.alibaba.fastjson.JSONObject;
import com.chinamcloud.bigdata.haiheservice.bean.AliWeiboAnalysisResult;
import com.chinamcloud.bigdata.haiheservice.parser.WeiboSubmitParser;
import com.chinamcloud.bigdata.haiheservice.util.JSONUtils;
import com.chinamcloud.bigdata.haiheservice.xz.IAliDataParser;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WeiboResultParser
implements IAliDataParser<AliWeiboAnalysisResult> {
    private static Logger logger = LogManager.getLogger(WeiboSubmitParser.class);

    @Override
    public AliWeiboAnalysisResult parserData(String data) {
        String graphData;
        String updatedAt;
        String createdAt;
        String pubTime;
        String detailReport;
        String simpleReport;
        Long totalFollows;
        JSONObject dataJson;
        JSONObject uInfo;
        String content;
        String screenName;
        String weiboUrl;
        logger.info("data=" + data);
        JSONObject jsonObject = JSONUtils.getJSONObject(data);
        JSONObject json = JSONUtils.getJSONObject("data", jsonObject);
        AliWeiboAnalysisResult result = new AliWeiboAnalysisResult();
        if (json == null) {
            result.setSuccess(false);
            result.setMessage("\u6570\u636e\u4e3a\u7a7a\uff01");
            return null;
        }
        Boolean isSuccess = json.getBoolean("success");
        JSONObject resultJson = json.getJSONObject("result");
        if (!isSuccess.booleanValue() || resultJson == null || resultJson.isEmpty()) {
            JSONObject messages = resultJson.getJSONObject("messages");
            if (messages != null && !messages.isEmpty()) {
                result.setMessage("\u8bf7\u6c42\u5931\u8d25:" + (messages != null && !messages.isEmpty() ? messages.toJSONString() : ""));
            }
            result.setSuccess(false);
            return result;
        }
        JSONObject progressInfoJson = resultJson.getJSONObject("progressInfo");
        String status = progressInfoJson.getString("status");
        if ("401".equals(status) || "402".equals(status) && "403".equals(status)) {
            result.setSuccess(false);
            return result;
        }
        if (!"200".equals(status)) {
            return null;
        }
        result.setSuccess(true);
        String analysisId = resultJson.getString("id");
        if (analysisId != null) {
            // empty if block
        }
        if ((weiboUrl = resultJson.getString("weiboUrl")) != null && !weiboUrl.isEmpty()) {
            result.setWeiboUrl(weiboUrl);
        }
        int sIdx = weiboUrl.indexOf(".com/") + 5;
        int eIdx = weiboUrl.indexOf("/", sIdx);
        String weiboId = weiboUrl.substring(sIdx, eIdx);
        long weiboIdVal = 0L;
        if (weiboId != null) {
            try {
                weiboIdVal = Long.parseLong(weiboId);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        result.setWeiboId(weiboIdVal);
        String uid = resultJson.getString("uid");
        if (uid != null && !uid.isEmpty()) {
            result.setUid(uid);
        }
        if ((screenName = resultJson.getString("screenName")) != null && !screenName.isEmpty()) {
            result.setScreenName(screenName);
        }
        if ((content = resultJson.getString("content")) != null && !content.isEmpty()) {
            result.setContent(content);
        }
        if ((uInfo = resultJson.getJSONObject("uInfo")) == null || uInfo.isEmpty()) {
            uInfo = resultJson.getJSONObject("uinfo");
        }
        if (uInfo != null && !uInfo.isEmpty()) {
            resultJson.getJSONObject("uInfo");
            result.setuInfo(uInfo);
        }
        JSONObject wInfo = resultJson.getJSONObject("wInfo");
        if (uInfo == null || uInfo.isEmpty()) {
            uInfo = resultJson.getJSONObject("winfo");
        }
        if (wInfo != null && !wInfo.isEmpty()) {
            result.setwInfo(wInfo);
        }
        if ((dataJson = resultJson.getJSONObject("data")) != null && !dataJson.isEmpty()) {
            result.setData(dataJson);
        }
        if ((totalFollows = resultJson.getLong("totalFollows")) != null) {
            result.setTotalFollows(totalFollows);
        }
        if ((simpleReport = resultJson.getString("simpleReport")) != null && !simpleReport.isEmpty()) {
            result.setSimpleReport(simpleReport);
        }
        if ((detailReport = resultJson.getString("detailReport")) != null && !detailReport.isEmpty()) {
            result.setDetailReport(detailReport);
        }
        if (!StringUtils.isEmpty((CharSequence)(pubTime = resultJson.getString("pubTime")))) {
            result.setPubTime(pubTime);
        }
        if (!StringUtils.isEmpty((CharSequence)(createdAt = resultJson.getString("createdAt")))) {
            result.setCreatedAt(createdAt);
        }
        if (!StringUtils.isEmpty((CharSequence)(updatedAt = resultJson.getString("updatedAt")))) {
            result.setUpdatedAt(updatedAt);
        }
        if (!StringUtils.isEmpty((CharSequence)(graphData = resultJson.getString("graphData")))) {
            result.setGraphData(graphData);
        }
        return result;
    }
}

