/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JSONUtils {
    private static Logger logger = LogManager.getLogger(JSONUtils.class);

    public static JSONObject getJSONObject(String str) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return null;
        }
        try {
            return JSON.parseObject((String)str);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("getJSONObject(String str)", (Throwable)e);
            return null;
        }
    }

    public static JSONArray parseJSONArray(String str) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return null;
        }
        try {
            return JSON.parseArray((String)str);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("parseJSONArray(String str)", (Throwable)e);
            return null;
        }
    }

    public static JSONObject getJSONObject(String key, JSONObject object) {
        if (StringUtils.isEmpty((CharSequence)key) || object == null) {
            return null;
        }
        try {
            return object.getJSONObject(key);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("getJSONObject(String key,JSONObject object)", (Throwable)e);
            return null;
        }
    }

    public static JSONArray getJSONArray(String key, JSONObject object) {
        if (StringUtils.isEmpty((CharSequence)key) || object == null) {
            return null;
        }
        try {
            return object.getJSONArray(key);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("getJSONArray(String key,JSONObject object)", (Throwable)e);
            return null;
        }
    }
}

