/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.afterprocessor;

import com.chinamcloud.bigdata.haiheservice.afterprocessor.IAfterProcessor;
import com.chinamcloud.bigdata.haiheservice.bean.FacetResult;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class AlarmNewsAfterProcessor
implements IAfterProcessor<List<FacetResult>> {
    @Override
    public void process(List<FacetResult> facets) {
        HashMap<String, FacetResult> map = new HashMap<String, FacetResult>();
        for (FacetResult facetResult : facets) {
            FacetResult result = (FacetResult)map.get(facetResult.getName());
            if (null == result) {
                result = new FacetResult();
                map.put(facetResult.getName(), result);
            }
            result.setName(facetResult.getName());
            if (null != facetResult.getMediaValue()) {
                result.setMediaValue(facetResult.getMediaValue());
            }
            if (null != facetResult.getEmotionValue()) {
                result.setEmotionValue(facetResult.getEmotionValue());
            }
            if (null == facetResult.getArticleValue()) continue;
            result.setArticleValue(facetResult.getArticleValue());
        }
        facets.clear();
        for (Map.Entry entry : map.entrySet()) {
            FacetResult facetResult = new FacetResult();
            facetResult.setName((String)entry.getKey());
            facetResult.setArticleValue(((FacetResult)entry.getValue()).getArticleValue());
            facetResult.setEmotionValue(((FacetResult)entry.getValue()).getEmotionValue());
            facetResult.setMediaValue(((FacetResult)entry.getValue()).getMediaValue());
            facets.add(facetResult);
        }
    }
}

