/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.controller;

import com.chinamcloud.bigdata.haiheservice.CodeResult;
import com.chinamcloud.bigdata.haiheservice.afterprocessor.AlarmNewsAfterProcessor;
import com.chinamcloud.bigdata.haiheservice.afterprocessor.CitySentimentSortAfterProcessor;
import com.chinamcloud.bigdata.haiheservice.afterprocessor.CountySentimentSourceAfterProcessor;
import com.chinamcloud.bigdata.haiheservice.afterprocessor.EmotionTendencyAfterProcessor;
import com.chinamcloud.bigdata.haiheservice.afterprocessor.NewsEmotionTendencyAfterProcessor;
import com.chinamcloud.bigdata.haiheservice.afterprocessor.SensitiveWordAfterProcessor;
import com.chinamcloud.bigdata.haiheservice.bean.AlarmInfoBean;
import com.chinamcloud.bigdata.haiheservice.bean.AlarmWatchInfoBean;
import com.chinamcloud.bigdata.haiheservice.bean.User;
import com.chinamcloud.bigdata.haiheservice.controller.GlobalHotController;
import com.chinamcloud.bigdata.haiheservice.controller.TopicHotController;
import com.chinamcloud.bigdata.haiheservice.es.pojo.TermAggBucket;
import com.chinamcloud.bigdata.haiheservice.i18n.MessageSource;
import com.chinamcloud.bigdata.haiheservice.pojo.AlarmNewsParams;
import com.chinamcloud.bigdata.haiheservice.pojo.HotParams;
import com.chinamcloud.bigdata.haiheservice.service.AlarmConfigService;
import com.chinamcloud.bigdata.haiheservice.service.AlarmInfoService;
import com.chinamcloud.bigdata.haiheservice.service.AreaService;
import com.chinamcloud.bigdata.haiheservice.util.TopicKeywordUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/alarm"})
public class AlarmDetailController {
    private static Logger logger = LogManager.getLogger(TopicHotController.class);
    @Autowired
    private AlarmConfigService alarmConfigService;
    @Autowired
    private AlarmInfoService alarmInfoService;
    @Autowired
    private AreaService areaService;

    @RequestMapping(value={"/getNewsStatistic"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object getNewsStatistic(@Valid @RequestBody AlarmNewsParams params, BindingResult result, HttpServletRequest request) {
        User user = (User)request.getAttribute("user");
        String taskId = params.getTaskId();
        AlarmWatchInfoBean task = null;
        if (taskId != null && !"".equals(taskId) && !"all".equalsIgnoreCase(taskId)) {
            try {
                task = this.alarmConfigService.getWatchInfo(user.getId(), Long.valueOf(taskId));
            }
            catch (Exception e) {
                e.printStackTrace();
                return CodeResult.failedResultByMsgSource("params_error");
            }
            if (task == null) {
                return CodeResult.failedResultByMsgSource("task_not_exist");
            }
            String description = TopicKeywordUtils.buildQueryByStr(task.getKeyword());
            logger.info("description=" + description);
            params.setDescription(description);
        } else if (taskId == null || "all".equalsIgnoreCase(taskId) || "".equalsIgnoreCase(taskId)) {
            List<AlarmWatchInfoBean> watchTask = this.alarmConfigService.getWatchTask(user.getId());
            StringBuffer description = new StringBuffer();
            for (AlarmWatchInfoBean alarmWatchInfoBean : watchTask) {
                description.append(TopicKeywordUtils.buildQueryByStr(alarmWatchInfoBean.getKeyword()) + " OR ");
            }
            if (description.length() == 0) {
                return new CodeResult(CodeResult.Code.Success, Collections.EMPTY_LIST);
            }
            logger.info("description=" + description);
            params.setDescription(description.toString());
        }
        params.setAfterProcessor(new NewsEmotionTendencyAfterProcessor());
        params.setFacetField("emotion_tendency");
        params.setEsIndex("2");
        ModelAndView view = new ModelAndView("/es/basic/facet.do");
        view.addObject("params", (Object)params);
        view.addObject("cache", (Object)true);
        return view;
    }

    @RequestMapping(value={"/news"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object hotNews(@RequestBody @Valid AlarmNewsParams params, BindingResult result, HttpServletRequest request) {
        Long taskId;
        if (result.hasErrors()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        try {
            taskId = Long.valueOf(params.getTaskId());
        }
        catch (Exception e) {
            e.printStackTrace();
            return CodeResult.failedResultByMsgSource("params_error");
        }
        User user = (User)request.getAttribute("user");
        AlarmWatchInfoBean task = this.alarmConfigService.getWatchInfo(user.getId(), taskId);
        if (task == null) {
            return CodeResult.failedResultByMsgSource("task_not_exist");
        }
        String description = TopicKeywordUtils.buildQueryByStr(task.getKeyword());
        params.setDescription(description);
        params.setEsIndex("2");
        logger.info("description=" + description);
        String[] words = description.replace("AND", " ").replace("OR", " ").split(" ");
        params.setAfterProcessor(new SensitiveWordAfterProcessor(new HashSet<String>(Arrays.asList(words))));
        ModelAndView modelAndView = new ModelAndView("/es/basic/hotNews.do");
        modelAndView.addObject("params", (Object)params);
        modelAndView.addObject("cache", (Object)true);
        return modelAndView;
    }

    @RequestMapping(value={"/getSenSourceFacet2"}, method={RequestMethod.POST})
    public Object getSenSourceFacet2(@Valid @RequestBody AlarmNewsParams params, BindingResult result, HttpServletRequest request) {
        Long taskId;
        if (result.hasErrors()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        try {
            taskId = Long.valueOf(params.getTaskId());
        }
        catch (Exception e) {
            e.printStackTrace();
            return CodeResult.failedResultByMsgSource("params_error");
        }
        User user = (User)request.getAttribute("user");
        AlarmWatchInfoBean task = this.alarmConfigService.getWatchInfo(user.getId(), taskId);
        if (task == null) {
            return CodeResult.failedResultByMsgSource("task_not_exist");
        }
        String description = TopicKeywordUtils.buildQueryByStr(task.getKeyword());
        params.setDescription(description);
        logger.info("description=" + description);
        params.setFacetField("tb_nickname");
        ModelAndView view = new ModelAndView("/es/basic/facetWithCondition.do");
        view.addObject("params", (Object)params);
        view.addObject("cache", (Object)true);
        return view;
    }

    @RequestMapping(value={"/getSenSourceFacet"}, method={RequestMethod.POST})
    public Object getSenSourceFacet(@Valid @RequestBody AlarmNewsParams params, BindingResult result, HttpServletRequest request) {
        Long taskId;
        if (result.hasErrors()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        try {
            taskId = Long.valueOf(params.getTaskId());
        }
        catch (Exception e) {
            e.printStackTrace();
            return CodeResult.failedResultByMsgSource("params_error");
        }
        User user = (User)request.getAttribute("user");
        AlarmWatchInfoBean task = this.alarmConfigService.getWatchInfo(user.getId(), taskId);
        if (task == null) {
            return CodeResult.failedResultByMsgSource("task_not_exist");
        }
        String description = TopicKeywordUtils.buildQueryByStr(task.getKeyword());
        params.setDescription(description);
        logger.info("description=" + description);
        params.setFacetField("tb_nickname");
        params.setFacetLimit(500);
        ModelAndView view = new ModelAndView("/es/basic/facet.do");
        view.addObject("params", (Object)params);
        return view;
    }

    @RequestMapping(value={"/getAlarmGrade"}, method={RequestMethod.POST})
    public Object getAlarmGrade(@Valid @RequestBody AlarmNewsParams params, BindingResult result, HttpServletRequest request) {
        Long taskId;
        if (result.hasErrors()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        try {
            taskId = Long.valueOf(params.getTaskId());
        }
        catch (Exception e) {
            e.printStackTrace();
            return CodeResult.failedResultByMsgSource("params_error");
        }
        User user = (User)request.getAttribute("user");
        AlarmWatchInfoBean task = this.alarmConfigService.getWatchInfo(user.getId(), taskId);
        if (task == null) {
            return CodeResult.failedResultByMsgSource("task_not_exist");
        }
        String description = TopicKeywordUtils.buildQueryByStr(task.getKeyword());
        params.setDescription(description);
        params.setEsIndex("2");
        logger.info("description=" + description);
        ModelAndView view = new ModelAndView("/es/basic/alarmGrade.do");
        view.addObject("params", (Object)params);
        view.addObject("cache", (Object)true);
        return view;
    }

    @RequestMapping(value={"/statistic"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object statistic(@Valid @RequestBody AlarmNewsParams params, BindingResult bindResult, HttpServletRequest request) {
        String taskId = params.getTaskId();
        User user = (User)request.getAttribute("user");
        AlarmWatchInfoBean task = null;
        if (taskId != null && !"".equals(taskId) && !"all".equalsIgnoreCase(taskId)) {
            try {
                task = this.alarmConfigService.getWatchInfo(user.getId(), Long.valueOf(taskId));
            }
            catch (Exception e) {
                e.printStackTrace();
                return CodeResult.failedResultByMsgSource("params_error");
            }
            if (task == null) {
                return CodeResult.failedResultByMsgSource("task_not_exist");
            }
            String description = TopicKeywordUtils.buildQueryByStr(task.getKeyword());
            params.setDescription(description);
        } else if (taskId == null || "all".equalsIgnoreCase(taskId) || "".equalsIgnoreCase(taskId)) {
            List<AlarmWatchInfoBean> watchTask = this.alarmConfigService.getWatchTask(user.getId());
            StringBuffer description = new StringBuffer();
            for (AlarmWatchInfoBean alarmWatchInfoBean : watchTask) {
                description.append(TopicKeywordUtils.buildQueryByStr(alarmWatchInfoBean.getKeyword()) + " OR ");
            }
            if (description.length() == 0) {
                return new CodeResult(CodeResult.Code.Success, Collections.EMPTY_LIST);
            }
            params.setDescription(description.toString());
        }
        params.setExcludeSpiderTopicIds(GlobalHotController.excludeSpiderTopicIds);
        params.setProduceIds(GlobalHotController.productIds);
        params.setSize(0);
        params.setEsIndex("2");
        ModelAndView view = new ModelAndView("/es/basic/statisticNews.do");
        view.addObject("params", (Object)params);
        return view;
    }

    @RequestMapping(value={"/getEmotionTendency"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object getEmotionTendency(@Valid @RequestBody AlarmNewsParams params, BindingResult bindResult, HttpServletRequest request) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String taskId = params.getTaskId();
        User user = (User)request.getAttribute("user");
        AlarmWatchInfoBean task = null;
        if (taskId != null && !"".equals(taskId) && !"all".equalsIgnoreCase(taskId)) {
            try {
                task = this.alarmConfigService.getWatchInfo(user.getId(), Long.valueOf(taskId));
            }
            catch (Exception e) {
                e.printStackTrace();
                return CodeResult.failedResultByMsgSource("params_error");
            }
            if (task == null) {
                return CodeResult.failedResultByMsgSource("task_not_exist");
            }
            String description = TopicKeywordUtils.buildQueryByStr(task.getKeyword());
            params.setDescription(description);
        } else if (taskId == null || "all".equalsIgnoreCase(taskId) || "".equalsIgnoreCase(taskId)) {
            List<AlarmWatchInfoBean> watchTask = this.alarmConfigService.getWatchTask(user.getId());
            StringBuffer description = new StringBuffer();
            for (AlarmWatchInfoBean alarmWatchInfoBean : watchTask) {
                description.append(TopicKeywordUtils.buildQueryByStr(alarmWatchInfoBean.getKeyword()) + " OR ");
            }
            if (description.length() == 0) {
                return new CodeResult(CodeResult.Code.Success, Collections.EMPTY_LIST);
            }
            params.setDescription(description.toString());
        }
        String toDtStr = params.getToDtStr();
        String fromDtStr = params.getFromDtStr();
        if (StringUtils.isNotBlank((CharSequence)toDtStr) && StringUtils.isNotBlank((CharSequence)toDtStr)) {
            try {
                params.setFromDt(dateFormat.parse(toDtStr));
                params.setToDt(dateFormat.parse(fromDtStr));
            }
            catch (ParseException e) {
                e.printStackTrace();
                return CodeResult.failedResultByMsgSource("params_error");
            }
        }
        params.setAfterProcessor(new EmotionTendencyAfterProcessor());
        params.setFacetField("emotion_tendency");
        ModelAndView view = new ModelAndView("/es/basic/facet.do");
        view.addObject("params", (Object)params);
        view.addObject("cache", (Object)true);
        return view;
    }

    @RequestMapping(value={"/getSentimentSourceFacet"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object getSentimentSourceFacet(@Valid @RequestBody AlarmNewsParams params, BindingResult bindResult, HttpServletRequest request) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String taskId = params.getTaskId();
        User user = (User)request.getAttribute("user");
        AlarmWatchInfoBean task = null;
        if (taskId != null && !"".equals(taskId) && !"all".equalsIgnoreCase(taskId)) {
            try {
                task = this.alarmConfigService.getWatchInfo(user.getId(), Long.valueOf(taskId));
            }
            catch (Exception e) {
                e.printStackTrace();
                return CodeResult.failedResultByMsgSource("params_error");
            }
            if (task == null) {
                return CodeResult.failedResultByMsgSource("task_not_exist");
            }
            String description = TopicKeywordUtils.buildQueryByStr(task.getKeyword());
            params.setDescription(description);
        } else if (taskId == null || "all".equalsIgnoreCase(taskId) || "".equalsIgnoreCase(taskId)) {
            List<AlarmWatchInfoBean> watchTask = this.alarmConfigService.getWatchTask(user.getId());
            StringBuffer description = new StringBuffer();
            for (AlarmWatchInfoBean alarmWatchInfoBean : watchTask) {
                description.append(TopicKeywordUtils.buildQueryByStr(alarmWatchInfoBean.getKeyword()) + " OR ");
            }
            if (description.length() == 0) {
                return new CodeResult(CodeResult.Code.Success, Collections.EMPTY_LIST);
            }
            params.setDescription(description.toString());
        }
        if ("source".equals(params.getFacetField())) {
            params.setAfterProcessor(new CountySentimentSourceAfterProcessor((Map<String, String>)new HashMap<String, String>(){
                {
                    this.put("News", "\u65b0\u95fb");
                    this.put("WeiboV", "\u5fae\u535a");
                    this.put("Weibo", "\u5fae\u535a");
                    this.put("Government", "\u653f\u5e9c");
                    this.put("LunTan", "\u8bba\u575b");
                    this.put("WeiXin", "\u5fae\u4fe1");
                    this.put("TieBa", "\u8d34\u5427");
                }
            }));
        }
        String toDtStr = params.getToDtStr();
        String fromDtStr = params.getFromDtStr();
        if (StringUtils.isNotBlank((CharSequence)toDtStr) && StringUtils.isNotBlank((CharSequence)toDtStr)) {
            try {
                params.setFromDt(dateFormat.parse(toDtStr));
                params.setToDt(dateFormat.parse(fromDtStr));
            }
            catch (ParseException e) {
                e.printStackTrace();
                return CodeResult.failedResultByMsgSource("params_error");
            }
        }
        params.setEsIndex("2");
        ModelAndView view = new ModelAndView("/es/basic/facet.do");
        view.addObject("params", (Object)params);
        view.addObject("cache", (Object)true);
        return view;
    }

    @RequestMapping(value={"/getCitySentimentValue"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object getCitySentimentValue(@RequestBody Map<String, Object> params, HttpServletRequest request) {
        HotParams hotParams;
        ArrayList regionNames;
        ArrayList tmpRegionNames = (ArrayList)params.get("regionNames");
        if (null == tmpRegionNames || tmpRegionNames.isEmpty()) {
            List<Map> countyByCity;
            tmpRegionNames = new ArrayList();
            final Object province = params.get("Province");
            if (null != province) {
                List<Map> cityByProvince = this.areaService.getCityByProvince((Map<String, String>)new HashMap<String, String>(){
                    {
                        this.put("name", province.toString());
                    }
                });
                if (cityByProvince == null || cityByProvince.isEmpty()) {
                    countyByCity = this.areaService.getCountyByCity((Map<String, String>)new HashMap<String, String>(){
                        {
                            this.put("name", province.toString());
                        }
                    });
                    if (countyByCity == null) {
                        logger.error("params error!");
                        return new CodeResult(CodeResult.Code.Failed, MessageSource.getMsg("params_error"));
                    }
                    ArrayList finalTmpRegionNames = tmpRegionNames;
                    countyByCity.stream().forEach(x -> finalTmpRegionNames.add(x.get("name").toString()));
                } else {
                    ArrayList finalTmpRegionNames1 = tmpRegionNames;
                    cityByProvince.stream().forEach(x -> finalTmpRegionNames1.add(x.get("name").toString()));
                }
            } else {
                final Object city = params.get("city");
                if (null != city) {
                    countyByCity = this.areaService.getCountyByCity((Map<String, String>)new HashMap<String, String>(){
                        {
                            this.put("name", city.toString());
                        }
                    });
                    if (countyByCity == null) {
                        logger.error("");
                        return new CodeResult(CodeResult.Code.Failed, MessageSource.getMsg("get_data_failed"));
                    }
                    ArrayList finalTmpRegionNames2 = tmpRegionNames;
                    countyByCity.stream().forEach(x -> finalTmpRegionNames2.add(x.get("name").toString()));
                }
            }
        }
        Object taskId = params.get("taskId");
        User user = (User)request.getAttribute("user");
        ModelAndView view = null;
        if (tmpRegionNames != null) {
            regionNames = tmpRegionNames;
            if (regionNames.isEmpty()) {
                return CodeResult.successResult(null, Collections.emptyList());
            }
            hotParams = new HotParams();
            CitySentimentSortAfterProcessor afterProcessor = new CitySentimentSortAfterProcessor();
            hotParams.setAfterProcessor(afterProcessor);
            Object fromDt = params.get("fromDt");
            Object toDt = params.get("toDt");
            try {
                Date from = new Date(Long.valueOf(fromDt.toString()));
                Date to = new Date(Long.valueOf(toDt.toString()));
                hotParams.setFromDt(from);
                hotParams.setToDt(to);
                hotParams.setCachetoDt(to);
                hotParams.setCacheFromDt(from);
            }
            catch (Exception e) {
                e.printStackTrace();
                return new CodeResult(CodeResult.Code.Failed, MessageSource.getMsg("params_error"));
            }
            if (taskId != null && !"".equals(taskId) && !"all".equalsIgnoreCase(taskId.toString())) {
                AlarmWatchInfoBean task = null;
                try {
                    task = this.alarmConfigService.getWatchInfo(user.getId(), Long.valueOf(taskId.toString()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return CodeResult.failedResultByMsgSource("params_error");
                }
                if (task == null) {
                    return CodeResult.failedResultByMsgSource("task_not_exist");
                }
                String keyword = task.getKeyword();
                ArrayList<String> words = new ArrayList<String>();
                for (String regionName : regionNames) {
                    if (StringUtils.isNotBlank((CharSequence)keyword)) {
                        for (String s : keyword.split(",")) {
                            for (String str : s.split(" ")) {
                                words.add(regionName + " " + str);
                            }
                        }
                        continue;
                    }
                    words.add(regionName);
                }
                hotParams.setDescription(TopicKeywordUtils.buildQueryByStr(words));
            } else if (taskId == null || "all".equalsIgnoreCase(taskId.toString()) || "".equalsIgnoreCase(taskId.toString())) {
                List<AlarmWatchInfoBean> watchTask = this.alarmConfigService.getWatchTask(user.getId());
                StringBuffer description = new StringBuffer();
                for (AlarmWatchInfoBean alarmWatchInfoBean : watchTask) {
                    String keyword = alarmWatchInfoBean.getKeyword();
                    ArrayList<String> words = new ArrayList<String>();
                    for (String regionName : regionNames) {
                        if (StringUtils.isNotBlank((CharSequence)keyword)) {
                            for (String s : keyword.split(",")) {
                                for (String str : s.split(" ")) {
                                    words.add(regionName + " " + str);
                                }
                            }
                            continue;
                        }
                        words.add(regionName);
                    }
                    description.append(TopicKeywordUtils.buildQueryByStr(words) + " OR ");
                }
                if (description.length() == 0) {
                    return new CodeResult(CodeResult.Code.Success, Collections.EMPTY_LIST);
                }
                hotParams.setDescription(description.toString());
            }
        } else {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        hotParams.setEsIndex("2");
        view = new ModelAndView("/es/basic/termBucketAgg.do");
        view.addObject("params", (Object)hotParams);
        view.addObject("termBucket", regionNames.stream().map(x -> new TermAggBucket(Arrays.asList(x), "description", (String)x)).collect(Collectors.toList()));
        view.addObject("cache", (Object)true);
        return view;
    }

    @RequestMapping(value={"/getSentimentFacet"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object getSentimentFacet(@Valid @RequestBody AlarmNewsParams params, BindingResult bindResult, HttpServletRequest request) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String taskId = params.getTaskId();
        User user = (User)request.getAttribute("user");
        AlarmWatchInfoBean task = null;
        if (taskId != null && !"".equals(taskId) && !"all".equalsIgnoreCase(taskId)) {
            try {
                task = this.alarmConfigService.getWatchInfo(user.getId(), Long.valueOf(taskId));
            }
            catch (Exception e) {
                e.printStackTrace();
                return CodeResult.failedResultByMsgSource("params_error");
            }
            if (task == null) {
                return CodeResult.failedResultByMsgSource("task_not_exist");
            }
            String description = TopicKeywordUtils.buildQueryByStr(task.getKeyword());
            params.setDescription(description);
        } else if (taskId == null || "all".equalsIgnoreCase(taskId) || "".equalsIgnoreCase(taskId)) {
            List<AlarmWatchInfoBean> watchTask = this.alarmConfigService.getWatchTask(user.getId());
            StringBuffer description = new StringBuffer();
            for (AlarmWatchInfoBean alarmWatchInfoBean : watchTask) {
                description.append(TopicKeywordUtils.buildQueryByStr(alarmWatchInfoBean.getKeyword()) + " OR ");
            }
            if (description.length() == 0) {
                return new CodeResult(CodeResult.Code.Success, Collections.EMPTY_LIST);
            }
            params.setDescription(description.toString());
        }
        String toDtStr = params.getToDtStr();
        String fromDtStr = params.getFromDtStr();
        if (StringUtils.isNotBlank((CharSequence)toDtStr) && StringUtils.isNotBlank((CharSequence)toDtStr)) {
            try {
                params.setFromDt(dateFormat.parse(toDtStr));
                params.setToDt(dateFormat.parse(fromDtStr));
            }
            catch (ParseException e) {
                e.printStackTrace();
                return CodeResult.failedResultByMsgSource("params_error");
            }
        }
        params.setEsIndex("2");
        ModelAndView view = new ModelAndView("/es/basic/facet.do");
        view.addObject("params", (Object)params);
        return view;
    }

    @RequestMapping(value={"/getAlarmNews"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object getAlarmNews(@Valid @RequestBody AlarmNewsParams params, HttpServletRequest request) {
        User user = (User)request.getAttribute("user");
        String taskId = params.getTaskId();
        AlarmWatchInfoBean task = null;
        if (taskId != null && !"".equals(taskId) && !"all".equalsIgnoreCase(taskId)) {
            try {
                task = this.alarmConfigService.getWatchInfo(user.getId(), Long.valueOf(taskId));
            }
            catch (Exception e) {
                e.printStackTrace();
                return CodeResult.failedResultByMsgSource("params_error");
            }
            if (task == null) {
                return CodeResult.failedResultByMsgSource("task_not_exist");
            }
            String description = TopicKeywordUtils.buildQueryByStr(task.getKeyword());
            params.setEmotionLower(Integer.valueOf(task.getEmotionValueLower()));
            params.setEmotionUpper(Integer.valueOf(task.getEmotionValueUpper()));
            params.setMediaValue(Integer.valueOf(task.getMediaValue()));
            logger.info("description=" + description);
            params.setDescription(description);
        } else if (taskId == null || "all".equalsIgnoreCase(taskId) || "".equalsIgnoreCase(taskId)) {
            return CodeResult.failedResultByMsgSource("task_not_exist");
        }
        ModelAndView modelAndView = new ModelAndView("/es/basic/alarmNews.do");
        params.setAfterProcessor(new AlarmNewsAfterProcessor());
        modelAndView.addObject("params", (Object)params);
        return modelAndView;
    }

    @RequestMapping(value={"/getAlarmInfo"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object getAlarmInfo(@RequestBody Map<String, String> params, HttpServletRequest request) {
        List<AlarmInfoBean> alarmInfoById;
        User user = (User)request.getAttribute("user");
        try {
            Long taskId = null == params.get("taskId") ? null : Long.valueOf(params.get("taskId"));
            Long fromDt = Long.valueOf(params.get("fromDt")) / 1000L;
            Long toDt = Long.valueOf(params.get("toDt")) / 1000L;
            alarmInfoById = this.alarmInfoService.getAlarmInfoById(user.getId(), taskId, fromDt, toDt);
        }
        catch (Exception e) {
            e.printStackTrace();
            return CodeResult.failedResultByMsgSource("params_error");
        }
        return new CodeResult(CodeResult.Code.Success, alarmInfoById);
    }
}

