/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.controller;

import com.chinamcloud.bigdata.haiheservice.CodeResult;
import com.chinamcloud.bigdata.haiheservice.bean.HotTopic;
import com.chinamcloud.bigdata.haiheservice.bean.Page;
import com.chinamcloud.bigdata.haiheservice.es.service.EsDataService;
import com.chinamcloud.bigdata.haiheservice.pojo.HotParams;
import com.chinamcloud.bigdata.haiheservice.service.CalcTopicHotService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/calc"})
public class CalcTopicHotController {
    @Autowired
    private CalcTopicHotService calcTopicHotService;
    @Autowired
    private EsDataService esDataService;
    private static Logger logger = LogManager.getLogger(CalcTopicHotController.class);
    private static final int productId = 53691;
    private static final List<Integer> spiderTopicIds = new ArrayList<Integer>();

    @RequestMapping(value={"/calcTopicHotValue"}, method={RequestMethod.POST}, consumes={"application/json"})
    public Object calculateTopicHot(@RequestBody Map<String, String> map) {
        String formula = map.get("formula");
        if (StringUtils.isEmpty((CharSequence)formula)) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        List<HotTopic> records = null;
        HotParams params = new HotParams();
        params.setProduceIds(Arrays.asList(53691));
        params.setSpiderTopicIds(spiderTopicIds);
        params.setDay("1");
        params.setPage(1);
        params.setSize(50);
        try {
            Page<HotTopic> hotTopic = this.esDataService.hotTopic(params);
            records = hotTopic.getRecords();
            if (records.size() == 0) {
                return Collections.emptyList();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return CodeResult.failedResultByMsgSource("params_error");
        }
        if (!this.calcTopicHotService.calcTopicHotValue(formula, records)) {
            return CodeResult.failedResultByMsgSource("formula_error");
        }
        return CodeResult.successResult(null, records);
    }

    static {
        spiderTopicIds.add(28932);
    }
}

