/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.controller;

import com.chinamcloud.bigdata.haiheservice.bean.EmailBean;
import com.chinamcloud.bigdata.haiheservice.es.service.EsDataService;
import com.chinamcloud.bigdata.haiheservice.pojo.HotParams;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class HealthController {
    @Autowired
    EsDataService esDataService;
    @Autowired
    JdbcTemplate jdbcTemplate;

    @RequestMapping(value={"/Health/CheckStatus"}, method={RequestMethod.GET})
    public Object saveContactor(@Valid @RequestBody EmailBean bean, BindingResult bindingResult) {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(200, "system is running normally ");
        try {
            boolean flag = true;
            if (!this.isCheckEs()) {
                flag = false;
                result.put(500, "Elasticsearch has error");
            }
            if (!this.isCheckMysql()) {
                flag = false;
                result.put(500, "Rds has error");
            }
            if (!flag) {
                result.remove(200);
            }
        }
        catch (Exception e) {
            result.remove(200);
            result.put(500, "server has error");
        }
        return result;
    }

    private boolean isCheckMysql() {
        try {
            Map queryForMap = this.jdbcTemplate.queryForMap("select count(*) as count from t_region_area");
            System.out.println(queryForMap);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private boolean isCheckEs() {
        HotParams params = new HotParams();
        params.setSortFields(Arrays.asList("pubTime desc"));
        try {
            this.esDataService.queryHotNewsSearch(params);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

