/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class AreaDao {
    @Autowired
    private JdbcTemplate template;

    public List<Map> getProvince() {
        return this.template.query("select AREA_CODE code,AREA_NAME name from t_area where AREA_CODE%10000=0", (RowMapper)new RowMapper<Map>(){

            public Map mapRow(ResultSet rs, int rowNum) throws SQLException {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("name", rs.getString("name"));
                map.put("code", rs.getString("code"));
                return map;
            }
        });
    }

    public List<Map> getCityByProvince(Integer code) {
        return this.template.query("select AREA_CODE code,AREA_NAME name from t_area where AREA_CODE%100=0 and AREA_CODE%10000!=0 and floor(AREA_CODE/10000)*10000=?", new Object[]{code}, (RowMapper)new RowMapper<Map>(){

            public Map mapRow(ResultSet rs, int rowNum) throws SQLException {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("name", rs.getString("name"));
                map.put("code", rs.getString("code"));
                return map;
            }
        });
    }

    public Map<String, String> getAreaByProvinceName(String name) {
        List listMap = this.template.query("select AREA_CODE code,AREA_NAME name from t_area where AREA_NAME like '%" + name + "%'", (RowMapper)new RowMapper<Map>(){

            public Map mapRow(ResultSet rs, int rowNum) throws SQLException {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("name", rs.getString("name"));
                map.put("code", rs.getString("code"));
                return map;
            }
        });
        return listMap.size() > 0 ? (Map)listMap.get(0) : null;
    }

    public List<Map> getCountyByCity(Integer code) {
        String sql = "";
        if (code % 10000 == 0) {
            sql = "select AREA_CODE code,AREA_NAME name from t_area where AREA_CODE%100!=0 and AREA_CODE%10000!=0 and floor(AREA_CODE/10000)*10000=?";
        }
        if (code % 10000 != 0) {
            sql = "select AREA_CODE code,AREA_NAME name from t_area where AREA_CODE%100!=0 and AREA_CODE%10000!=0 and floor(AREA_CODE/100)*100=?";
        }
        return this.template.query(sql, new Object[]{code}, (RowMapper)new RowMapper<Map>(){

            public Map mapRow(ResultSet rs, int rowNum) throws SQLException {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("name", rs.getString("name"));
                map.put("code", rs.getString("code"));
                return map;
            }
        });
    }

    public Map<String, String> getPositional(String type, String value) {
        String sql = "";
        sql = "name".equals(type) ? "select AREA_CODE code,AREA_NAME name,AREA_GEOJSON geoJson from t_area where AREA_NAME like '%" + value + "%'" : "select AREA_CODE code,AREA_NAME name,AREA_GEOJSON geoJson from t_area where AREA_CODE = " + value;
        List listMap = this.template.query(sql, (RowMapper)new RowMapper<Map>(){

            public Map mapRow(ResultSet rs, int rowNum) throws SQLException {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("name", rs.getString("name"));
                map.put("code", rs.getString("code"));
                map.put("geoJson", rs.getString("geoJson"));
                return map;
            }
        });
        return listMap.size() > 0 ? (Map)listMap.get(0) : null;
    }
}

