/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.dao;

import com.chinamcloud.bigdata.haiheservice.bean.HotWords;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class HotWordsDao {
    @Autowired
    private JdbcTemplate jdbcTemplate;
    private static Logger logger = LogManager.getLogger(HotWordsDao.class);

    public List<HotWords> getHotWords() {
        return this.jdbcTemplate.query("SELECT * from t_hotwords ", (RowMapper)new RowMapper<HotWords>(){

            public HotWords mapRow(ResultSet rs, int rowNum) throws SQLException {
                HotWords bean = new HotWords();
                bean.setName(rs.getString("name"));
                bean.setCount(rs.getInt("count"));
                bean.setType(rs.getInt("type"));
                bean.setUserId(rs.getInt("userId"));
                bean.setMedia_cat(rs.getInt("media_cat"));
                return bean;
            }
        });
    }

    public List<HotWords> getHotWords(Long userId) {
        return this.jdbcTemplate.query("SELECT * from t_hotwords where userId = ? ", new Object[]{userId}, (RowMapper)new RowMapper<HotWords>(){

            public HotWords mapRow(ResultSet rs, int rowNum) throws SQLException {
                HotWords bean = new HotWords();
                bean.setName(rs.getString("name"));
                bean.setCount(rs.getInt("count"));
                bean.setType(rs.getInt("type"));
                bean.setUserId(rs.getInt("userId"));
                bean.setMedia_cat(rs.getInt("media_cat"));
                return bean;
            }
        });
    }

    public List<HotWords> getHotWordsByType(int type) {
        return this.jdbcTemplate.query("SELECT * from t_hotwords WHERE type = ?", new Object[]{type}, (RowMapper)new RowMapper<HotWords>(){

            public HotWords mapRow(ResultSet rs, int rowNum) throws SQLException {
                HotWords bean = new HotWords();
                bean.setName(rs.getString("name"));
                bean.setCount(rs.getInt("count"));
                bean.setType(rs.getInt("type"));
                bean.setUserId(rs.getInt("userId"));
                return bean;
            }
        });
    }
}

