/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.dao;

import com.chinamcloud.bigdata.haiheservice.bean.HotTopic;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class PredictEventDao {
    @Autowired
    private JdbcTemplate jdbcTemplate;

    public void savePredictEvent(final List<HotTopic> hotTopics) {
        this.jdbcTemplate.update("DELETE FROM `t_topic_predict`");
        this.jdbcTemplate.batchUpdate("INSERT INTO `t_topic_predict`(`title`, `clusterId`, `cluster`, `docValue`, `hotValue`, `emotionScore`, `mediaCover`, `description`, `pubTime`) VALUES(?,?,?,?,?,?,?,?,?)", new BatchPreparedStatementSetter(){

            public int getBatchSize() {
                return hotTopics.size();
            }

            public void setValues(PreparedStatement ps, int i) throws SQLException {
                HotTopic bean = (HotTopic)hotTopics.get(i);
                ps.setString(1, bean.getTitle());
                ps.setString(2, String.valueOf(bean.getClusterId()));
                ps.setString(3, bean.getCluster());
                ps.setLong(4, bean.getDocValue());
                ps.setLong(5, bean.getHotValue());
                ps.setLong(6, bean.getEmotionScore());
                ps.setLong(7, bean.getMediaCover());
                ps.setString(8, bean.getDescription());
                ps.setString(9, String.valueOf(bean.getPubTime()));
            }
        });
    }

    public List<HotTopic> selectPredictEvent() {
        return this.jdbcTemplate.query("SELECT * FROM `t_topic_predict`", (RowMapper)new RowMapper<HotTopic>(){

            public HotTopic mapRow(ResultSet rs, int rowNum) throws SQLException {
                HotTopic bean = new HotTopic();
                bean.setTitle(rs.getString("title"));
                bean.setClusterId(Long.valueOf(rs.getString("clusterId")));
                bean.setCluster(rs.getString("cluster"));
                bean.setDocValue(rs.getLong("docValue"));
                bean.setHotValue(rs.getLong("hotValue"));
                bean.setEmotionScore(rs.getLong("emotionScore"));
                bean.setMediaCover(rs.getLong("mediaCover"));
                bean.setPubTime(rs.getString("pubTime"));
                bean.setDescription(rs.getString("description"));
                return bean;
            }
        });
    }
}

