/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.es.pojo;

import com.chinamcloud.bigdata.haiheservice.es.EsFeedbackQuery;
import com.chinamcloud.bigdata.haiheservice.es.pojo.IEsBuildAgg;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;

public class EsFactAggWithEmotionRepetitionTendency
implements IEsBuildAgg {
    @Override
    public AggregationBuilder buildAgg(EsFeedbackQuery query) {
        String field = query.getFacetField();
        Integer pageSize = query.getPageSize();
        Integer typeValue = query.getTypeValue();
        Integer facetMincount = query.getFacetMincount();
        String type = query.getType();
        if (StringUtils.isNotBlank((CharSequence)type)) {
            switch (type) {
                case "source": {
                    TermsAggregationBuilder aggre = (TermsAggregationBuilder)AggregationBuilders.terms((String)"agg").field("source");
                    if (StringUtils.isNotBlank((CharSequence)field)) {
                        aggre.subAggregation((AggregationBuilder)AggregationBuilders.cardinality((String)"agg1").field(field));
                    }
                    return aggre;
                }
                case "day": {
                    DateHistogramAggregationBuilder format = (DateHistogramAggregationBuilder)((DateHistogramAggregationBuilder)AggregationBuilders.dateHistogram((String)"agg").field("pubTimeStr")).dateHistogramInterval(DateHistogramInterval.days((int)typeValue)).format("yyyy-MM-dd");
                    if (StringUtils.isNotBlank((CharSequence)field)) {
                        format.subAggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"agg1").field(field)).size(pageSize.intValue()).minDocCount((long)facetMincount.intValue()));
                    }
                    return format;
                }
                case "hour": {
                    DateHistogramAggregationBuilder dateHis = (DateHistogramAggregationBuilder)((DateHistogramAggregationBuilder)AggregationBuilders.dateHistogram((String)"agg").field("pubTimeStr")).dateHistogramInterval(DateHistogramInterval.hours((int)typeValue)).format("yyyy-MM-dd HH");
                    if (StringUtils.isNotBlank((CharSequence)field)) {
                        dateHis.subAggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"agg1").field(field)).size(pageSize.intValue()).minDocCount((long)facetMincount.intValue()));
                    }
                    return dateHis;
                }
                case "minute": {
                    DateHistogramAggregationBuilder mHis = (DateHistogramAggregationBuilder)((DateHistogramAggregationBuilder)AggregationBuilders.dateHistogram((String)"agg").field("pubTimeStr")).dateHistogramInterval(DateHistogramInterval.minutes((int)typeValue)).format("yyyy-MM-dd HH:mm");
                    if (StringUtils.isNotBlank((CharSequence)field)) {
                        mHis.subAggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"agg1").field(field)).size(pageSize.intValue()).minDocCount((long)facetMincount.intValue()));
                    }
                    return mHis;
                }
            }
        }
        return ((DateHistogramAggregationBuilder)((DateHistogramAggregationBuilder)AggregationBuilders.dateHistogram((String)"agg").field("pubTimeStr")).dateHistogramInterval(DateHistogramInterval.minutes((int)typeValue)).format("yyyy-MM-dd HH:mm")).subAggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"agg1").field(field)).size(pageSize.intValue()).minDocCount((long)facetMincount.intValue()));
    }
}

