/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.es.result;

import com.chinamcloud.bigdata.haiheservice.es.EsFeedbackQuery;
import com.chinamcloud.bigdata.haiheservice.es.bean.EsApsFacetField;
import com.chinamcloud.bigdata.haiheservice.es.result.EsFacetResult;
import com.chinamcloud.bigdata.haiheservice.es.result.EsResultProcessor;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.springframework.util.ObjectUtils;

public class EsFacetResultWitnCondtionProcessor
implements EsResultProcessor<EsFeedbackQuery, SearchResponse> {
    public EsFacetResult<List<EsApsFacetField>> processResult(EsFeedbackQuery query, SearchResponse response) {
        String name = query.getFacetField();
        EsFacetResult<List<EsApsFacetField>> facetResult = null;
        try {
            ArrayList<EsApsFacetField> list = new ArrayList<EsApsFacetField>();
            MultiBucketsAggregation agg = (MultiBucketsAggregation)response.getAggregations().get("agg");
            EsApsFacetField apsFacetField = new EsApsFacetField();
            ArrayList<String> values = new ArrayList<String>();
            ArrayList<Long> counts = new ArrayList<Long>();
            ArrayList<Long> metrics = new ArrayList<Long>();
            for (MultiBucketsAggregation.Bucket entry : agg.getBuckets()) {
                Object key = entry.getKey();
                long docCount = entry.getDocCount();
                if (ObjectUtils.isEmpty((Object)key)) continue;
                values.add(String.valueOf(key));
                counts.add(docCount);
                long negtive = 0L;
                MultiBucketsAggregation agg1 = (MultiBucketsAggregation)entry.getAggregations().get("agg1");
                for (MultiBucketsAggregation.Bucket entry1 : agg1.getBuckets()) {
                    Object key1 = entry1.getKey();
                    long docCount1 = entry1.getDocCount();
                    if (ObjectUtils.isEmpty((Object)key1) || !String.valueOf(key1).equals("-1")) continue;
                    negtive = docCount1;
                    break;
                }
                metrics.add(negtive);
            }
            apsFacetField.setName(name);
            apsFacetField.setValues(values);
            apsFacetField.setCounts(counts);
            apsFacetField.setMetrics(metrics);
            list.add(apsFacetField);
            facetResult = new EsFacetResult(list, (Boolean)true);
        }
        catch (Exception e) {
            facetResult = new EsFacetResult<List<EsApsFacetField>>(e.getMessage(), (Boolean)false);
        }
        return facetResult;
    }
}

