/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.es.result;

import com.chinamcloud.bigdata.haiheservice.bean.Trend;
import com.chinamcloud.bigdata.haiheservice.es.EsFeedbackQuery;
import com.chinamcloud.bigdata.haiheservice.es.bean.EsApsSearchField;
import com.chinamcloud.bigdata.haiheservice.es.bean.HotTopicStatistic;
import com.chinamcloud.bigdata.haiheservice.es.result.EsResultProcessor;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.metrics.cardinality.Cardinality;
import org.elasticsearch.search.aggregations.metrics.sum.Sum;
import org.elasticsearch.search.aggregations.metrics.tophits.TopHits;
import org.springframework.util.ObjectUtils;

public class EsTopicStatisticResultProcessor
implements EsResultProcessor<EsFeedbackQuery, SearchResponse> {
    private static Logger logger = LogManager.getLogger(EsTopicStatisticResultProcessor.class);
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static Map<String, Double> sourceMapping = new HashMap<String, Double>();

    public List<HotTopicStatistic> processResult(EsFeedbackQuery query, SearchResponse response) {
        Terms agg = (Terms)response.getAggregations().get("agg");
        ArrayList<HotTopicStatistic> records = new ArrayList<HotTopicStatistic>();
        for (Terms.Bucket entry : agg.getBuckets()) {
            SearchHit[] searchHits;
            HotTopicStatistic bean = new HotTopicStatistic();
            Object cluster = entry.getKey();
            long doc_count = entry.getDocCount();
            if (ObjectUtils.isEmpty((Object)cluster)) continue;
            bean.setCluster(String.valueOf(cluster));
            bean.setDoc_count(doc_count);
            ArrayList<EsApsSearchField> news = new ArrayList<EsApsSearchField>();
            TopHits topHits = (TopHits)entry.getAggregations().get("top");
            for (SearchHit searchHit : searchHits = topHits.getHits().getHits()) {
                Map source = searchHit.getSource();
                EsApsSearchField apsFeedback = new EsApsSearchField();
                Object cluter = source.get("cluster");
                apsFeedback.setCluster(cluter == null ? null : String.valueOf(cluter));
                Object clusterId = source.get("clusterId");
                apsFeedback.setClusterId(clusterId == null ? null : Long.valueOf(clusterId.toString()));
                Object description = source.get("description");
                apsFeedback.setDescription(description == null ? null : String.valueOf(description));
                apsFeedback.setSetShortcut(description == null ? null : String.valueOf(description).replace("[[+_+]]", "").replace("`n`", ""));
                Object emotionScore = source.get("emotionScore");
                apsFeedback.setEmotionScore(emotionScore == null ? null : Integer.valueOf(emotionScore.toString()));
                Object id = source.get("id");
                apsFeedback.setId(id == null ? null : String.valueOf(id.toString()));
                Object pubTime = source.get("pubTime");
                apsFeedback.setPubTime(pubTime == null ? null : Long.valueOf(pubTime.toString()));
                Object refererUrl = source.get("refererUrl");
                apsFeedback.setRefererUrl(refererUrl == null ? null : String.valueOf(refererUrl));
                Object subject = source.get("subject");
                apsFeedback.setSubject(subject == null ? null : String.valueOf(subject));
                Object summaryKeywordList = source.get("summaryKeywordList");
                apsFeedback.setSummaryKeywordList(summaryKeywordList instanceof ArrayList ? (List)summaryKeywordList : null);
                Object tbNickname = source.get("tbNickname");
                apsFeedback.setTbNickname(tbNickname == null ? null : String.valueOf(tbNickname));
                Object pics = source.get("pics");
                apsFeedback.setPics(pics instanceof ArrayList ? (List)pics : null);
                news.add(apsFeedback);
            }
            Histogram histogram = (Histogram)entry.getAggregations().get("histogram");
            ArrayList<Trend> media_cover = new ArrayList<Trend>();
            ArrayList<Trend> emotion_value = new ArrayList<Trend>();
            ArrayList<Trend> hot_value = new ArrayList<Trend>();
            ArrayList<Trend> doc_value = new ArrayList<Trend>();
            for (Histogram.Bucket bucket : histogram.getBuckets()) {
                String keyAsString = bucket.getKeyAsString();
                long count = bucket.getDocCount();
                long time = 0L;
                try {
                    time = dateFormat.parse(keyAsString).getTime();
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                if (count == 0L) {
                    emotion_value.add(new Trend(time, 0L));
                    media_cover.add(new Trend(time, 0L));
                    hot_value.add(new Trend(time, 0L));
                    doc_value.add(new Trend(time, 0L));
                    continue;
                }
                doc_value.add(new Trend(time, count));
                Sum sum_emo = (Sum)bucket.getAggregations().get("emotionscore");
                double avg_emo = sum_emo.getValue();
                emotion_value.add(new Trend(time, (long)avg_emo / count));
                Cardinality media = (Cardinality)bucket.getAggregations().get("tbnickname");
                long meidaValue = media.getValue();
                media_cover.add(new Trend(time, meidaValue));
                Terms terms = (Terms)bucket.getAggregations().get("source");
                long hotVal = 0L;
                for (Terms.Bucket term : terms.getBuckets()) {
                    Object media_type = term.getKey();
                    long media_count = term.getDocCount();
                    Double type = sourceMapping.getOrDefault(media_type, 1.336);
                    hotVal = (long)((double)hotVal + (type * type + type) * (double)media_count);
                }
                hot_value.add(new Trend(time, hotVal));
            }
            bean.setNews(news);
            bean.setEmotion_value(emotion_value);
            bean.setMedia_cover(media_cover);
            bean.setHot_value(hot_value);
            bean.setDoc_value(doc_value);
            records.add(bean);
        }
        return records;
    }

    static {
        sourceMapping.put("Government", 7.78);
        sourceMapping.put("News", 3.89);
        sourceMapping.put("Weibo", 1.99);
        sourceMapping.put("WeiboV", 1.99);
        sourceMapping.put("LunTan", 1.34);
        sourceMapping.put("Other", 1.34);
        sourceMapping.put("WeiXin", 1.78);
    }
}

